/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.RequestTimeoutException;
import oracle.kv.StoreIteratorException;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.IndexIterate;
import oracle.kv.impl.api.ops.IndexKeysIterate;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultTableIndex;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

class IndexScan {
    private static final long WAIT_TIME_MS = 100L;
    private static final int QUEUE_SIZE = 3;
    private static final long NANOS_TO_MILLIS = 1000000L;

    private IndexScan() {
    }

    static TableIterator<Row> createTableIterator(final TableAPIImpl apiImpl, final IndexKeyImpl indexKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), getOptions);
        return new IndexScanIterator<Row>(apiImpl.getStore(), indexKey, getOptions, iterateOptions){

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexIterate(this.index.getName(), targetTables, this.range, resumeSecondaryKey, resumePrimaryKey, this.batchSize);
            }

            @Override
            protected void convertResult(Result result, List<Row> rows) {
                List<ResultKeyValueVersion> keyValueVersionList = result.getKeyValueVersionList();
                for (ResultKeyValueVersion keyValue : keyValueVersionList) {
                    Row converted = this.convert(keyValue);
                    if (converted == null) continue;
                    rows.add(converted);
                }
            }

            private Row convert(ResultKeyValueVersion keyValue) {
                if (keyValue == null) {
                    return null;
                }
                TableImpl startingTable = targetTables.hasAncestorTables() ? this.table.getTopLevelTable() : this.table;
                RowImpl fullKey = startingTable.createRowFromKeyBytes(keyValue.getKeyBytes());
                if (fullKey == null) {
                    return null;
                }
                ValueVersion vv = new ValueVersion(keyValue.getValue(), keyValue.getVersion());
                return apiImpl.getRowFromValueVersion(vv, fullKey, false);
            }

            @Override
            protected byte[] extractResumeSecondaryKey(Row row) {
                return this.index.serializeIndexKey(this.index.createIndexKey(row));
            }

            @Override
            protected byte[] extractResumePrimaryKey(Row row) {
                TableKey key = TableKey.createKey(((RowImpl)row).getTableImpl(), row, false);
                return key.getKeyBytes();
            }

            @Override
            protected int compare(Row one, Row two) {
                return ((RecordValueImpl)((Object)one)).compare((RecordValueImpl)((Object)two), indexKey.getFields());
            }
        };
    }

    static TableIterator<KeyPair> createTableKeysIterator(TableAPIImpl apiImpl, IndexKeyImpl indexKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(indexKey.getTable(), getOptions);
        return new IndexScanIterator<KeyPair>(apiImpl.getStore(), indexKey, getOptions, iterateOptions){

            @Override
            protected InternalOperation createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                return new IndexKeysIterate(this.index.getName(), targetTables, this.range, resumeSecondaryKey, resumePrimaryKey, this.batchSize);
            }

            @Override
            protected void convertResult(Result result, List<KeyPair> elementList) {
                List<ResultTableIndex> results = result.getTableIndexList();
                for (ResultTableIndex res : results) {
                    PrimaryKeyImpl pkey;
                    IndexKeyImpl indexKeyImpl = this.convertIndexKey(res.getIndexKeyBytes());
                    if (indexKeyImpl == null || (pkey = this.convertPrimaryKey(res.getPrimaryKeyBytes())) == null) continue;
                    elementList.add(new KeyPair(pkey, indexKeyImpl));
                }
            }

            @Override
            protected byte[] extractResumeSecondaryKey(KeyPair element) {
                return this.index.serializeIndexKey((IndexKeyImpl)element.getIndexKey());
            }

            @Override
            protected byte[] extractResumePrimaryKey(KeyPair element) {
                PrimaryKeyImpl pkey = (PrimaryKeyImpl)element.getPrimaryKey();
                TableKey key = TableKey.createKey(pkey.getTableImpl(), pkey, false);
                return key.getKeyBytes();
            }

            @Override
            protected int compare(KeyPair one, KeyPair two) {
                return one.compareTo(two);
            }

            private IndexKeyImpl convertIndexKey(byte[] bytes) {
                return this.index.rowFromIndexKey(bytes, false);
            }

            private PrimaryKeyImpl convertPrimaryKey(byte[] bytes) {
                TableImpl startingTable = targetTables.hasAncestorTables() ? this.table.getTopLevelTable() : this.table;
                return startingTable.createPrimaryKeyFromKeyBytes(bytes);
            }
        };
    }

    private static class IndexScanExecutor
    extends ScheduledThreadPoolExecutor {
        IndexScanExecutor(int nThreads, Logger logger) {
            super(nThreads, new KVThreadFactory(" index scan", logger));
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
    }

    private static abstract class IndexScanIterator<K>
    implements TableIterator<K>,
    TopologyManager.PostUpdateListener {
        private final KVStoreImpl store;
        private final Logger logger;
        private final Consistency consistency;
        private final long timeoutMs;
        protected final IndexImpl index;
        protected final TableImpl table;
        protected final IndexRange range;
        protected final int batchSize;
        private final int nGroups;
        private final TreeSet<ShardStream> streams;
        private final ThreadPoolExecutor executor;
        private volatile boolean closed = false;
        private Exception closeException = null;
        private K next = null;
        private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();

        private IndexScanIterator(KVStoreImpl store, IndexKeyImpl indexKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
            this.store = store;
            this.range = new IndexRange(indexKey, getOptions, iterateOptions);
            this.consistency = TableAPIImpl.getConsistency(iterateOptions);
            long timeout = TableAPIImpl.getTimeout(iterateOptions);
            long l = this.timeoutMs = timeout == 0L ? (long)store.getDefaultRequestTimeoutMs() : TableAPIImpl.getTimeoutUnit(iterateOptions).toMillis(timeout);
            if (this.timeoutMs <= 0L) {
                throw new IllegalArgumentException("Timeout must be > 0 ms");
            }
            this.batchSize = TableAPIImpl.getBatchSize(iterateOptions);
            this.index = indexKey.getIndexImpl();
            this.table = this.index.getTableImpl();
            this.logger = store.getLogger();
            TopologyManager topoManager = store.getDispatcher().getTopologyManager();
            Topology topology = topoManager.getTopology();
            Set<RepGroupId> groups = topology.getRepGroupIds();
            this.nGroups = groups.size();
            if (this.nGroups == 0) {
                throw new IllegalStateException("Store not yet initialized");
            }
            int nThreads = Math.min(this.nGroups, Runtime.getRuntime().availableProcessors());
            if (nThreads == 0) {
                nThreads = 1;
            }
            this.executor = new IndexScanExecutor(nThreads, this.logger);
            this.streams = new TreeSet();
            for (RepGroupId groupId : groups) {
                ShardStream stream = new ShardStream(groupId, null, null);
                this.streams.add(stream);
                stream.submit();
            }
            topoManager.addPostUpdateListener(this);
        }

        protected abstract InternalOperation createOp(byte[] var1, byte[] var2);

        protected abstract void convertResult(Result var1, List<K> var2);

        protected abstract byte[] extractResumeSecondaryKey(K var1);

        protected abstract byte[] extractResumePrimaryKey(K var1);

        protected abstract int compare(K var1, K var2);

        @Override
        public synchronized boolean hasNext() {
            if (this.closed) {
                if (this.closeException != null) {
                    throw new StoreIteratorException(this.closeException, null);
                }
                return false;
            }
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public synchronized K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            K lastReturned = this.next;
            this.next = null;
            return lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.close(null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(Exception reason, boolean remove) {
            IndexScanIterator indexScanIterator = this;
            synchronized (indexScanIterator) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.closeException = reason;
            }
            if (remove) {
                this.store.getDispatcher().getTopologyManager().removePostUpdateListener(this);
            }
            try {
                List<Runnable> unfinishedBusiness = this.executor.shutdownNow();
                if (unfinishedBusiness != null) {
                    this.logger.log(Level.WARNING, "Index executor didn''t shutdown cleanly. {0} tasks remaining.", unfinishedBusiness.size());
                }
            }
            finally {
                this.streams.clear();
                this.next = null;
            }
        }

        private K getNext() {
            long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.timeoutMs);
            while (!this.closed) {
                ShardStream stream = this.streams.pollFirst();
                if (stream == null) {
                    this.close();
                    return null;
                }
                Object entry = stream.removeNext();
                if (!stream.isDone()) {
                    this.streams.add(stream);
                }
                if (entry != null || this.closed) {
                    return entry;
                }
                long waitMs = Math.min((limitNs - System.nanoTime()) / 1000000L, 100L);
                if (waitMs <= 0L) {
                    throw new RequestTimeoutException((int)this.timeoutMs, "Operation timed out", null, false);
                }
                stream.waitForNext(waitMs);
            }
            return null;
        }

        @Override
        public boolean postUpdate(Topology topology) {
            if (this.closed) {
                return true;
            }
            TopologyManager topoManager = this.store.getDispatcher().getTopologyManager();
            int newGroupSize = topoManager.getTopology().getRepGroupIds().size();
            if (this.nGroups == newGroupSize) {
                return false;
            }
            if (this.nGroups > newGroupSize) {
                this.close(new UnsupportedOperationException("The number of shards has decreased during the iteration"), false);
            }
            if (this.nGroups < newGroupSize) {
                this.close(new UnsupportedOperationException("The number of shards has increased during the iteration"), false);
            }
            return this.closed;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DetailedMetrics> getShardMetrics() {
            Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
            synchronized (map) {
                ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
                ret.addAll(this.shardMetrics.values());
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMetrics(RepGroupId groupId, long timeInMs, long recordCount) {
            DetailedMetricsImpl dmi;
            Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
            synchronized (map) {
                dmi = this.shardMetrics.get(groupId);
                if (dmi == null) {
                    dmi = new DetailedMetricsImpl(groupId.toString(), timeInMs, recordCount);
                    this.shardMetrics.put(groupId, dmi);
                    return;
                }
            }
            dmi.inc(timeInMs, recordCount);
        }

        public String toString() {
            return "IndexScanIterator[" + this.index.getName() + ", " + (Object)((Object)this.range.getDirection()) + "]";
        }

        private class ShardStream
        implements Comparable<ShardStream>,
        Runnable {
            protected final RepGroupId groupId;
            protected byte[] resumeSecondaryKey;
            protected byte[] resumePrimaryKey;
            private final BlockingQueue<List<K>> blocks = new LinkedBlockingQueue(3);
            private List<K> currentBlock;
            private K nextElem = null;
            private boolean doneReading = false;
            private boolean done = false;
            private boolean active = false;

            ShardStream(RepGroupId groupId, byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                this.groupId = groupId;
                this.resumeSecondaryKey = resumeSecondaryKey;
                this.resumePrimaryKey = resumePrimaryKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            K removeNext() {
                assert (!this.done);
                Object ret = this.nextElem;
                this.nextElem = this.currentBlock == null || this.currentBlock.isEmpty() ? null : this.currentBlock.remove(0);
                Object v0 = this.nextElem;
                if (this.nextElem == null) {
                    ShardStream shardStream = this;
                    synchronized (shardStream) {
                        this.currentBlock = (List)this.blocks.poll();
                        this.submit();
                        if (this.currentBlock == null) {
                            this.done = this.doneReading;
                        } else {
                            this.nextElem = this.currentBlock.remove(0);
                        }
                    }
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void waitForNext(long waitMs) {
                block7: {
                    if (this.nextElem != null) {
                        return;
                    }
                    try {
                        ShardStream shardStream = this;
                        synchronized (shardStream) {
                            if (this.blocks.isEmpty() && !this.doneReading) {
                                this.wait(waitMs);
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        if (IndexScanIterator.this.closed) break block7;
                        IndexScanIterator.this.logger.log(Level.WARNING, "Unexpected interrupt ", ex);
                    }
                }
            }

            boolean isDone() {
                return this.done;
            }

            private synchronized void submit() {
                if (this.active || this.doneReading || this.blocks.remainingCapacity() == 0) {
                    return;
                }
                this.active = true;
                IndexScanIterator.this.executor.submit(this);
            }

            @Override
            public void run() {
                try {
                    assert (this.active);
                    assert (!this.doneReading);
                    assert (this.blocks.remainingCapacity() > 0);
                    long start = System.nanoTime();
                    int count = this.readBlock();
                    long end = System.nanoTime();
                    long thisTimeMs = (end - start) / 1000000L;
                    IndexScanIterator.this.updateMetrics(this.groupId, thisTimeMs, count);
                }
                catch (RuntimeException re) {
                    this.active = false;
                    IndexScanIterator.this.close(re, true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int readBlock() {
                Request req = IndexScanIterator.this.store.makeReadRequest(IndexScanIterator.this.createOp(this.resumeSecondaryKey, this.resumePrimaryKey), this.groupId, IndexScanIterator.this.consistency, IndexScanIterator.this.timeoutMs, TimeUnit.MILLISECONDS);
                Result result = IndexScanIterator.this.store.executeRequest(req);
                boolean hasMore = result.hasMoreElements();
                int nRecords = result.getNumRecords();
                ArrayList elementList = null;
                if (nRecords > 0) {
                    elementList = new ArrayList(nRecords);
                    IndexScanIterator.this.convertResult(result, elementList);
                    nRecords = elementList.size();
                    this.resumeSecondaryKey = hasMore ? IndexScanIterator.this.extractResumeSecondaryKey(elementList.get(nRecords - 1)) : null;
                    this.resumePrimaryKey = hasMore ? IndexScanIterator.this.extractResumePrimaryKey(elementList.get(nRecords - 1)) : null;
                }
                ShardStream shardStream = this;
                synchronized (shardStream) {
                    this.active = false;
                    boolean bl = this.doneReading = !hasMore;
                    if (nRecords == 0) {
                        assert (this.doneReading);
                        this.notify();
                        return 0;
                    }
                    assert (elementList != null);
                    this.blocks.add(elementList);
                    this.notify();
                }
                this.submit();
                return nRecords;
            }

            @Override
            public int compareTo(ShardStream other) {
                if (IndexScanIterator.this.range.isUnordered()) {
                    return this.nextElem == null ? 1 : -1;
                }
                if (this.nextElem == null) {
                    return -1;
                }
                Object otherNext = other.nextElem;
                if (otherNext == null) {
                    return 1;
                }
                int comp = IndexScanIterator.this.compare(this.nextElem, otherNext);
                return IndexScanIterator.this.range.isForward() ? comp : comp * -1;
            }

            public String toString() {
                return "ShardStream[" + this.groupId + ", " + this.done + ", " + this.active + ", " + this.doneReading + ", " + this.blocks.size() + "]";
            }
        }
    }
}

