/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import java.util.List;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.table.FieldDef;
import oracle.kv.table.RecordDef;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class RecordBuilder
extends TableBuilderBase {
    private final String name;
    private String description;

    RecordBuilder(String name, String description) {
        this.name = name;
        this.description = description;
    }

    RecordBuilder(String name) {
        this.name = name;
    }

    @Override
    public String getBuilderType() {
        return "Record";
    }

    @Override
    public RecordDef build() {
        return new RecordDefImpl(this.name, this.fields, this.description);
    }

    @Override
    public TableBuilderBase addField(String name1, FieldDef field) {
        if (name1 == null) {
            throw new IllegalArgumentException("Record fields must have names");
        }
        return super.addField(name1, field);
    }

    @Override
    public TableBuilderBase setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    TableBuilderBase generateAvroSchemaFields(Schema schema, String name1, JsonNode defaultValue, String desc) {
        List schemaFields = schema.getFields();
        for (Schema.Field field : schemaFields) {
            super.generateAvroSchemaFields(field.schema(), field.name(), field.defaultValue(), field.doc());
        }
        return this;
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        RecordDefImpl tmp = new RecordDefImpl(this.name, this.fields, this.description);
        tmp.toJson(o);
        try {
            return writer.writeValueAsString((Object)o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }
}

