/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.ArrayBuilder;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.MapBuilder;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.Table;
import org.apache.avro.Schema;

public class TableBuilder
extends TableBuilderBase {
    private final String name;
    private String description;
    private final TableImpl parent;
    private List<String> primaryKey;
    private List<String> shardKey;
    private boolean r2compat;
    private boolean schemaAdded;
    private int schemaId;

    private TableBuilder(String name, String description, Table parent, boolean copyParentInfo) {
        this.name = name;
        this.description = description;
        this.schemaAdded = false;
        this.r2compat = false;
        this.parent = parent != null ? (TableImpl)parent : null;
        this.primaryKey = new ArrayList<String>();
        this.shardKey = new ArrayList<String>();
        if (parent != null && copyParentInfo) {
            this.addParentInfo();
        }
        TableImpl.validateComponent(name, true);
    }

    public static TableBuilder createTableBuilder(String name, String description, Table parent, boolean copyParentInfo) {
        return new TableBuilder(name, description, parent, copyParentInfo);
    }

    public static TableBuilder createTableBuilder(String name, String description, Table parent) {
        return new TableBuilder(name, description, parent, true);
    }

    public static TableBuilder createTableBuilder(String name) {
        return new TableBuilder(name, null, null, true);
    }

    public static ArrayBuilder createArrayBuilder(String description) {
        return new ArrayBuilder(description);
    }

    public static ArrayBuilder createArrayBuilder() {
        return new ArrayBuilder();
    }

    public static MapBuilder createMapBuilder(String description) {
        return new MapBuilder(description);
    }

    public static MapBuilder createMapBuilder() {
        return new MapBuilder();
    }

    public static RecordBuilder createRecordBuilder(String name, String description) {
        return new RecordBuilder(name, description);
    }

    public static RecordBuilder createRecordBuilder(String name) {
        return new RecordBuilder(name);
    }

    public static TableImpl fromJsonString(String jsonString, Table parent) {
        return JsonUtils.fromJsonString(jsonString, (TableImpl)parent);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public TableImpl getParent() {
        return this.parent;
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<String> getShardKey() {
        return this.shardKey;
    }

    public boolean isR2compatible() {
        return this.r2compat;
    }

    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    public TableBuilderBase setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public TableBuilderBase primaryKey(String ... key) {
        for (String field : key) {
            if (this.primaryKey.contains(field)) {
                throw new IllegalArgumentException("The primary key field already exists: " + field);
            }
            this.primaryKey.add(field);
        }
        return this;
    }

    @Override
    public TableBuilderBase shardKey(String ... key) {
        if (this.parent != null) {
            throw new IllegalArgumentException("Child tables cannot have a shard key.");
        }
        for (String field : key) {
            if (this.shardKey.contains(field)) {
                throw new IllegalArgumentException("The shard key field already exists: " + field);
            }
            this.shardKey.add(field);
        }
        return this;
    }

    @Override
    public TableBuilderBase primaryKey(List<String> pKey) {
        this.primaryKey = pKey;
        return this;
    }

    @Override
    public TableBuilderBase shardKey(List<String> mKey) {
        if (this.parent != null) {
            throw new IllegalArgumentException("Child tables cannot have a shard key.");
        }
        this.shardKey = mKey;
        return this;
    }

    @Override
    public TableBuilderBase setR2compat(boolean value) {
        this.r2compat = value;
        return this;
    }

    @Override
    public TableBuilderBase setSchemaId(int id) {
        this.schemaId = id;
        this.r2compat = true;
        return this;
    }

    @Override
    public TableBuilderBase addSchema(String avroSchema) {
        if (this.schemaAdded) {
            throw new IllegalArgumentException("Only one schema may be added to a table");
        }
        Schema schema = new Schema.Parser().parse(avroSchema);
        List schemaFields = schema.getFields();
        for (Schema.Field field : schemaFields) {
            this.generateAvroSchemaFields(field.schema(), field.name(), field.defaultValue(), field.doc());
        }
        this.schemaAdded = true;
        return this;
    }

    @Override
    public TableImpl buildTable() {
        if (this.shardKey.isEmpty()) {
            this.shardKey = this.parent != null ? new ArrayList<String>(this.parent.getShardKey()) : this.primaryKey;
        }
        return TableImpl.createTable(this.getName(), this.parent, this.getPrimaryKey(), this.getShardKey(), this.fields, this.r2compat, this.schemaId, this.getDescription(), true);
    }

    @Override
    void validateFieldAddition(String fieldName) {
        super.validateFieldAddition(fieldName);
        if (this.parent != null && this.parent.getPrimaryKey().contains(fieldName)) {
            throw new IllegalArgumentException("Cannot add field, it already exists in primary key fields of its parent table: " + fieldName);
        }
    }

    @Override
    public TableBuilderBase validate() {
        this.buildTable();
        return this;
    }

    public String toJsonString(boolean pretty) {
        TableImpl t = TableImpl.createTable(this.getName(), this.parent, this.getPrimaryKey(), this.getShardKey(), this.fields, this.r2compat, this.schemaId, this.getDescription(), false);
        return t.toJsonString(pretty);
    }

    private void addParentInfo() {
        for (String fieldName : this.parent.getPrimaryKey()) {
            this.fields.put(fieldName, this.parent.getFieldMapEntry(fieldName, true));
            this.primaryKey.add(fieldName);
        }
    }
}

