/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableBuilderBase {
    protected FieldMap fields;

    TableBuilderBase() {
        this.fields = new FieldMap();
    }

    TableBuilderBase(FieldMap map) {
        this.fields = map;
    }

    public FieldMap getFieldMap() {
        return this.fields;
    }

    public List<String> getFieldOrder() {
        return this.fields.getFieldOrder();
    }

    public FieldDef getField(String name) {
        return this.fields.get(name);
    }

    public String getBuilderType() {
        return "Table";
    }

    public boolean isCollectionBuilder() {
        return false;
    }

    public TableBuilderBase validate() {
        this.build();
        return this;
    }

    public TableBuilderBase primaryKey(String ... key) {
        throw new IllegalArgumentException("primaryKey not supported");
    }

    public TableBuilderBase shardKey(String ... key) {
        throw new IllegalArgumentException("shardKey not supported");
    }

    public TableBuilderBase primaryKey(List<String> key) {
        throw new IllegalArgumentException("primaryKey not supported");
    }

    public TableBuilderBase shardKey(List<String> key) {
        throw new IllegalArgumentException("shardKey not supported");
    }

    public TableBuilderBase setR2compat(boolean r2compat) {
        throw new IllegalArgumentException("setR2compat not supported");
    }

    public TableBuilderBase setSchemaId(int id) {
        throw new IllegalArgumentException("setSchemaId not supported");
    }

    public TableBuilderBase addSchema(String avroSchema) {
        throw new IllegalArgumentException("addSchema not supported");
    }

    public TableBuilderBase setDescription(String description) {
        throw new IllegalArgumentException("setDescription not supported");
    }

    public TableImpl buildTable() {
        throw new IllegalArgumentException("buildTable must be overridden");
    }

    public FieldDef build() {
        throw new IllegalArgumentException("build must be overridden");
    }

    public TableBuilderBase addInteger(String name) {
        return this.addInteger(name, null, null, null, null, null);
    }

    public TableBuilderBase addInteger(String name, String description, Boolean nullable, Integer defaultValue, Integer min, Integer max) {
        IntegerDefImpl def = new IntegerDefImpl(description, min, max);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        IntegerValueImpl value = defaultValue != null ? def.createInteger(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addInteger() {
        return this.addInteger(null, null, null, null, null, null);
    }

    public TableBuilderBase addInteger(String description, Integer min, Integer max) {
        return this.addInteger(null, description, null, null, min, max);
    }

    public TableBuilderBase addLong(String name) {
        return this.addLong(name, null, null, null, null, null);
    }

    public TableBuilderBase addLong(String name, String description, Boolean nullable, Long defaultValue, Long min, Long max) {
        LongDefImpl def = new LongDefImpl(description, min, max);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        LongValueImpl value = defaultValue != null ? def.createLong(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addLong() {
        return this.addLong(null, null, null, null, null, null);
    }

    public TableBuilderBase addLong(String description, Long min, Long max) {
        return this.addLong(null, description, null, null, min, max);
    }

    public TableBuilderBase addDouble(String name) {
        return this.addDouble(name, null, null, null, null, null);
    }

    public TableBuilderBase addDouble(String name, String description, Boolean nullable, Double defaultValue, Double min, Double max) {
        DoubleDefImpl def = new DoubleDefImpl(description, min, max);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        DoubleValueImpl value = defaultValue != null ? def.createDouble(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addDouble() {
        return this.addDouble(null, null, null, null, null, null);
    }

    public TableBuilderBase addDouble(String description, Double min, Double max) {
        return this.addDouble(null, description, null, null, min, max);
    }

    public TableBuilderBase addFloat(String name) {
        return this.addFloat(name, null, null, null, null, null);
    }

    public TableBuilderBase addFloat(String name, String description, Boolean nullable, Float defaultValue, Float min, Float max) {
        FloatDefImpl def = new FloatDefImpl(description, min, max);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        FloatValueImpl value = defaultValue != null ? def.createFloat(defaultValue.floatValue()) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addFloat() {
        return this.addFloat(null, null, null, null, null, null);
    }

    public TableBuilderBase addFloat(String description, Float min, Float max) {
        return this.addFloat(null, description, null, null, min, max);
    }

    public TableBuilderBase addBoolean(String name) {
        return this.addBoolean(name, null, null, null);
    }

    public TableBuilderBase addBoolean(String name, String description) {
        return this.addBoolean(name, description, null, null);
    }

    public TableBuilderBase addBoolean(String name, String description, Boolean nullable, Boolean defaultValue) {
        BooleanDefImpl def = new BooleanDefImpl(description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        BooleanValueImpl value = defaultValue != null ? def.createBoolean(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addBoolean() {
        return this.addBoolean(null, null, null, null);
    }

    public TableBuilderBase addString(String name) {
        return this.addString(name, null, null, null, null, null, null, null);
    }

    public TableBuilderBase addString(String name, String description, Boolean nullable, String defaultValue, String min, String max, Boolean minInclusive, Boolean maxInclusive) {
        StringDefImpl def = new StringDefImpl(description, min, max, minInclusive, maxInclusive);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        StringValueImpl value = defaultValue != null ? def.createString(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addString() {
        return this.addString(null, null, null, null, null);
    }

    public TableBuilderBase addString(String description, String min, String max, Boolean minInclusive, Boolean maxInclusive) {
        return this.addString(null, description, null, null, min, max, minInclusive, maxInclusive);
    }

    public TableBuilderBase addEnum(String name, String[] values, String description, Boolean nullable, String defaultValue) {
        EnumDefImpl def = new EnumDefImpl(name, values, description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        EnumValueImpl value = defaultValue != null ? def.createEnum(defaultValue) : null;
        return this.addField(name, this.makeFieldMapEntry(def, nullable, value));
    }

    public TableBuilderBase addEnum(String name, String[] values, String description) {
        return this.addEnum(name, values, description, null, null);
    }

    public TableBuilderBase addBinary() {
        return this.addBinary(null, null, null);
    }

    public TableBuilderBase addBinary(String name, String description) {
        return this.addBinary(name, description, null);
    }

    public TableBuilderBase addBinary(String name) {
        return this.addBinary(name, null, null);
    }

    public TableBuilderBase addBinary(String name, String description, Boolean nullable) {
        BinaryDefImpl def = new BinaryDefImpl(description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, this.makeFieldMapEntry(def, nullable, null));
    }

    public TableBuilderBase addFixedBinary(String name, int size) {
        return this.addFixedBinary(name, size, null);
    }

    public TableBuilderBase addFixedBinary(String name, int size, String description) {
        FixedBinaryDefImpl def = new FixedBinaryDefImpl(name, size, description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, this.makeFieldMapEntry(def, null, null));
    }

    public TableBuilderBase addFixedBinary(String name, int size, String description, Boolean nullable) {
        FixedBinaryDefImpl def = new FixedBinaryDefImpl(name, size, description);
        if (this.isCollectionBuilder()) {
            return this.addField(def);
        }
        return this.addField(name, this.makeFieldMapEntry(def, nullable, null));
    }

    public void removeField(String fieldName) {
        FieldDef toBeRemoved = this.getField(fieldName);
        if (toBeRemoved == null) {
            throw new IllegalArgumentException("Field does not exist: " + fieldName);
        }
        this.validateFieldRemoval(fieldName);
        this.fields.remove(fieldName);
    }

    void validateFieldRemoval(String fieldName) {
    }

    public int size() {
        return this.fields.size();
    }

    public TableBuilderBase addField(FieldDef field) {
        throw new IllegalArgumentException("addField(FieldDef) can only be used for maps and arrays");
    }

    public TableBuilderBase addField(String name, FieldDef field) {
        return this.addField(name, this.makeFieldMapEntry((FieldDefImpl)field, null, null));
    }

    public TableBuilderBase addField(String name, FieldMapEntry field) {
        this.validateFieldAddition(name);
        assert (name != null);
        if (this.fields.exists(name)) {
            throw new IllegalArgumentException("Named field already exists: " + name);
        }
        this.fields.put(name, field);
        return this;
    }

    void validateFieldAddition(String name) {
        if (name != null) {
            TableImpl.validateComponent(name, false);
        }
    }

    TableBuilderBase generateAvroSchemaFields(Schema schema, String name, JsonNode defaultValue, String desc) {
        return this.generateAvroSchemaFields(schema, name, defaultValue, desc, false);
    }

    private TableBuilderBase generateAvroSchemaFields(Schema schema, String name, JsonNode defaultValue, String desc, boolean isUnion) {
        Schema.Type ftype = schema.getType();
        switch (ftype) {
            case BOOLEAN: {
                if (this.isCollectionBuilder()) {
                    this.addBoolean();
                    break;
                }
                this.addBoolean(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Boolean.valueOf(defaultValue.getBooleanValue()) : null);
                break;
            }
            case BYTES: {
                if (this.isCollectionBuilder()) {
                    this.addBinary();
                    break;
                }
                this.addBinary(name, desc, isUnion);
                break;
            }
            case FIXED: {
                if (this.isCollectionBuilder()) {
                    this.addFixedBinary(name, schema.getFixedSize(), desc);
                    break;
                }
                this.addFixedBinary(name, schema.getFixedSize(), desc, isUnion);
                break;
            }
            case DOUBLE: {
                if (this.isCollectionBuilder()) {
                    this.addDouble();
                    break;
                }
                this.addDouble(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Double.valueOf(defaultValue.getValueAsDouble()) : null, null, null);
                break;
            }
            case FLOAT: {
                if (this.isCollectionBuilder()) {
                    this.addFloat();
                    break;
                }
                this.addFloat(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Float.valueOf((float)defaultValue.getValueAsDouble()) : null, null, null);
                break;
            }
            case ENUM: {
                List symbols = schema.getEnumSymbols();
                String[] enumValues = new String[symbols.size()];
                for (int i = 0; i < enumValues.length; ++i) {
                    enumValues[i] = (String)symbols.get(i);
                }
                if (this.isCollectionBuilder()) {
                    this.addEnum(name, enumValues, null);
                    break;
                }
                this.addEnum(name, enumValues, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.getValueAsText() : null);
                break;
            }
            case INT: {
                if (this.isCollectionBuilder()) {
                    this.addInteger();
                    break;
                }
                this.addInteger(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Integer.valueOf(defaultValue.getIntValue()) : null, null, null);
                break;
            }
            case LONG: {
                if (this.isCollectionBuilder()) {
                    this.addLong();
                    break;
                }
                this.addLong(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? Long.valueOf(defaultValue.getLongValue()) : null, null, null);
                break;
            }
            case ARRAY: {
                ArrayDefImpl arrayDef = (ArrayDefImpl)TableBuilder.createArrayBuilder(desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(arrayDef);
                    break;
                }
                FieldValueImpl defaultVal = arrayDef.createValue(defaultValue);
                this.addField(name, this.makeFieldMapEntry(arrayDef, isUnion, defaultVal));
                break;
            }
            case MAP: {
                MapDefImpl mapDef = (MapDefImpl)TableBuilder.createMapBuilder(desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(mapDef);
                    break;
                }
                FieldValueImpl defaultVal = mapDef.createValue(defaultValue);
                this.addField(name, this.makeFieldMapEntry(mapDef, isUnion, defaultVal));
                break;
            }
            case RECORD: {
                RecordDefImpl recordDef = (RecordDefImpl)TableBuilder.createRecordBuilder(schema.getName(), desc).generateAvroSchemaFields(schema, null, null, desc).build();
                if (this.isCollectionBuilder()) {
                    this.addField(recordDef);
                    break;
                }
                FieldValueImpl defaultVal = recordDef.createValue(defaultValue);
                this.addField(name, this.makeFieldMapEntry(recordDef, isUnion, defaultVal));
                break;
            }
            case STRING: {
                if (this.isCollectionBuilder()) {
                    this.addString();
                    break;
                }
                this.addString(name, desc, isUnion, defaultValue != null && !defaultValue.isNull() ? defaultValue.getTextValue() : null, null, null, null, null);
                break;
            }
            case UNION: {
                this.unionNotAllowed(isUnion, Schema.Type.UNION);
                this.handleUnion(schema, name, defaultValue, desc);
                break;
            }
            case NULL: {
                throw new IllegalArgumentException("Unsupported Avro type: " + ftype);
            }
            default: {
                throw new IllegalStateException("Unknown type: " + ftype);
            }
        }
        return this;
    }

    private void handleUnion(Schema schema, String name, JsonNode defaultValue, String desc) {
        List unionSchemas = schema.getTypes();
        if (unionSchemas.size() != 2) {
            throw new IllegalArgumentException("Avro unions must contain only 2 members");
        }
        boolean foundNull = false;
        Schema nonNullSchema = null;
        for (Schema s : unionSchemas) {
            if (s.getType() == Schema.Type.NULL) {
                foundNull = true;
                continue;
            }
            nonNullSchema = s;
        }
        if (!foundNull) {
            throw new IllegalArgumentException("Avro union must include null");
        }
        this.generateAvroSchemaFields(nonNullSchema, name, defaultValue, desc, true);
    }

    private void unionNotAllowed(boolean isUnion, Schema.Type type) {
        if (isUnion) {
            throw new IllegalArgumentException("Avro union with type is not supported: " + type);
        }
    }

    private FieldMapEntry makeFieldMapEntry(FieldDefImpl def, Boolean nullable, FieldValueImpl defaultValue) {
        return new FieldMapEntry(def, nullable != null ? nullable : true, defaultValue);
    }

    void fromJson(String fieldName, ObjectNode node) {
        JsonNode defaultNode = node.get("default");
        Boolean nullable = JsonUtils.getBooleanFromJson(node, "nullable");
        FieldDefImpl def = JsonUtils.fromJson(node);
        FieldValueImpl value = defaultNode == null || defaultNode.isNull() ? null : def.createValue(defaultNode);
        this.addField(fieldName, this.makeFieldMapEntry(def, nullable, value));
    }
}

