/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.kv.Key;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.Row;
import oracle.kv.table.Table;

public class TableKey {
    private final ArrayList<String> major;
    private final ArrayList<String> minor;
    private final Iterator<String> pkIterator;
    private final Iterator<String> majorIterator;
    private final boolean allowPartial;
    private final Row row;
    private final Table table;
    private Key key;
    private boolean majorComplete;
    private boolean keyComplete;
    private boolean done;
    private ArrayList<String> current;

    private TableKey(Table table, Row row, boolean allowPartial) {
        this.row = row;
        this.allowPartial = allowPartial;
        this.major = new ArrayList();
        this.minor = new ArrayList();
        this.pkIterator = table.getPrimaryKey().iterator();
        this.majorIterator = table.getShardKey().iterator();
        this.current = this.major;
        this.keyComplete = true;
        this.table = table;
    }

    public static TableKey createKey(Table table, Row row, boolean allowPartial) {
        if (row.size() == 0) {
            if (!allowPartial) {
                throw new IllegalArgumentException("Primary key is empty");
            }
            return new TableKey(table, row, allowPartial).create();
        }
        return new TableKey(table, row, allowPartial).create();
    }

    public TableKey create() {
        this.validateKey();
        this.createPrimaryKey(this.table);
        this.key = Key.createKey(this.major, this.minor);
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getKeyComplete() {
        return this.keyComplete;
    }

    public boolean getMajorKeyComplete() {
        return this.majorComplete;
    }

    public Key getKey() {
        return this.key;
    }

    RowImpl getRow() {
        return (RowImpl)this.row;
    }

    public byte[] getKeyBytes() {
        return this.key.toByteArray();
    }

    private void incrementMajor() {
        if (this.majorIterator.hasNext()) {
            this.majorIterator.next();
        } else {
            this.current = this.minor;
            this.majorComplete = true;
        }
    }

    private void createPrimaryKey(Table currentTable) {
        if (currentTable.getParent() != null) {
            this.createPrimaryKey(currentTable.getParent());
        }
        if (this.done) {
            return;
        }
        List<String> primaryKey = currentTable.getPrimaryKey();
        this.current.add(((TableImpl)currentTable).getIdString());
        String lastKeyField = primaryKey.get(primaryKey.size() - 1);
        while (this.pkIterator.hasNext()) {
            String fieldName = this.pkIterator.next();
            FieldDef field = currentTable.getField(fieldName);
            this.incrementMajor();
            FieldValueImpl value = (FieldValueImpl)this.row.get(fieldName);
            if (value == null) {
                this.keyComplete = false;
                if (!this.allowPartial) {
                    throw new IllegalArgumentException("Missing primary key field: " + fieldName);
                }
                this.done = true;
                break;
            }
            this.current.add(value.formatForKey(field));
            if (!fieldName.equals(lastKeyField)) continue;
            this.incrementMajor();
            break;
        }
    }

    void validateFieldOrder(FieldRange range) {
        if (range != null) {
            List<String> primaryKey = this.table.getPrimaryKey();
            int index = primaryKey.indexOf(range.getFieldName());
            if (index < 0) {
                throw new IllegalArgumentException("Field is not part of primary key: " + range.getFieldName());
            }
            if (this.row.size() < index) {
                throw new IllegalArgumentException("PrimaryKey is missing fields more significant than field: " + range.getFieldName());
            }
            if (this.row.size() > index) {
                throw new IllegalArgumentException("PrimaryKey has extra fields beyond field: " + range.getFieldName());
            }
        }
    }

    private void validateKey() {
        if (this.row.size() != 0) {
            boolean fieldMissing = false;
            for (String keyField : this.table.getPrimaryKey()) {
                if (this.row.get(keyField) == null) {
                    fieldMissing = true;
                    continue;
                }
                if (!fieldMissing) continue;
                throw new IllegalArgumentException("Primary key fields are specified out of order");
            }
        }
    }
}

