/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.AddIndex;
import oracle.kv.impl.api.table.AddTable;
import oracle.kv.impl.api.table.DropIndex;
import oracle.kv.impl.api.table.DropTable;
import oracle.kv.impl.api.table.EvolveTable;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableChangeList;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.UpdateIndexStatus;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.table.Index;
import oracle.kv.table.Table;

public class TableMetadata
implements Metadata<TableChangeList>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Table> tables = new TreeMap<String, Table>(FieldComparator.instance);
    private int seqNum = 0;
    private long keyId = 1L;
    private static final int INITIAL_KEY_ID = 1;
    private final List<TableChange> changeHistory;

    public TableMetadata(boolean keepChanges) {
        this.changeHistory = keepChanges ? new LinkedList() : null;
    }

    public TableImpl addTable(String name, String parentName, List<String> primaryKey, List<String> shardKey, FieldMap fieldMap, boolean r2compat, int schemaId, String description) {
        TableImpl table = this.insertTable(name, parentName, primaryKey, shardKey, fieldMap, r2compat, schemaId, description);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddTable(table, this.seqNum));
        }
        return table;
    }

    public void dropTable(String tableName, boolean markForDelete) {
        this.removeTable(tableName, markForDelete);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new DropTable(tableName, markForDelete, this.seqNum));
        }
    }

    public boolean evolveTable(TableImpl table, int tableVersion, FieldMap fieldMap) {
        if (fieldMap.equals(table.getFieldMap())) {
            return false;
        }
        if (tableVersion != table.numTableVersions()) {
            throw new IllegalCommandException("Table evolution must be performed on the latest version");
        }
        table.evolve(fieldMap);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new EvolveTable(table, this.seqNum));
        }
        return true;
    }

    public void addIndex(String indexName, String tableName, List<String> fields, String description) {
        IndexImpl index = this.insertIndex(indexName, tableName, fields, description);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddIndex(index, this.seqNum));
        }
    }

    public void dropIndex(String indexName, String tableName) {
        if (this.removeIndex(indexName, tableName)) {
            this.bumpSeqNum();
            if (this.changeHistory != null) {
                this.changeHistory.add(new DropIndex(indexName, tableName, this.seqNum));
            }
        }
    }

    public boolean updateIndexStatus(String indexName, String tableName, IndexImpl.IndexStatus status) {
        IndexImpl index = this.changeIndexStatus(indexName, tableName, status);
        if (index != null) {
            this.bumpSeqNum();
            if (this.changeHistory != null) {
                this.changeHistory.add(new UpdateIndexStatus(index, this.seqNum));
            }
            return true;
        }
        return false;
    }

    TableImpl insertTable(String name, String parentName, List<String> primaryKey, List<String> shardKey, FieldMap fields, boolean r2compat, int schemaId, String description) {
        TableImpl table = null;
        if (parentName != null) {
            TableImpl parent = this.getTable(parentName, true);
            if (parent.childTableExists(name)) {
                throw new IllegalArgumentException("Cannot create table.  Table exists: " + TableMetadata.makeQualifiedName(name, parentName));
            }
            table = TableImpl.createTable(name, parent, primaryKey, shardKey, fields, r2compat, schemaId, description, true);
            table.setId(this.allocateId());
            parent.getMutableChildTables().put(name, table);
        } else {
            if (this.tables.containsKey(name)) {
                throw new IllegalArgumentException("Cannot create table.  Table exists: " + name);
            }
            table = TableImpl.createTable(name, null, primaryKey, shardKey, fields, r2compat, schemaId, description, true);
            table.setId(this.allocateId());
            this.tables.put(name, table);
        }
        return table;
    }

    TableImpl evolveTable(String tableName, FieldMap fields) {
        TableImpl table = this.getTable(tableName, true);
        table.evolve(fields);
        return table;
    }

    Table removeTable(String tableName, boolean markForDelete) {
        TableImpl table = this.checkForRemove(tableName, true);
        if (markForDelete) {
            table.setStatus(TableImpl.TableStatus.DELETING);
            return table;
        }
        Table parent = table.getParent();
        if (parent != null) {
            ((TableImpl)parent).getMutableChildTables().remove(table.getName());
        } else {
            this.tables.remove(table.getName());
        }
        return table;
    }

    public TableImpl checkForRemove(String tableName, boolean mustExist) {
        TableImpl table = this.getTable(tableName, mustExist);
        String qname = TableMetadata.makeQualifiedName(null, tableName);
        if (table != null && !table.getChildTables().isEmpty()) {
            throw new IllegalCommandException("Cannot remove " + qname + ", it is still referenced by " + "child tables");
        }
        return table;
    }

    IndexImpl insertIndex(String indexName, String tableName, List<String> fields, String description) {
        TableImpl table = this.getTable(tableName, true);
        if (table.getIndex(indexName) != null) {
            throw new IllegalArgumentException("Index exists: " + indexName + " on table: " + TableMetadata.makeQualifiedName(null, tableName));
        }
        IndexImpl index = new IndexImpl(indexName, table, fields, description);
        index.setStatus(IndexImpl.IndexStatus.POPULATING);
        table.addIndex(index);
        return index;
    }

    boolean removeIndex(String indexName, String tableName) {
        TableImpl table = this.getTable(tableName, true);
        if (table.getIndex(indexName) == null) {
            throw new IllegalArgumentException("Index does not exist: " + indexName + " on table: " + TableMetadata.makeQualifiedName(null, tableName));
        }
        table.removeIndex(indexName);
        return true;
    }

    IndexImpl changeIndexStatus(String indexName, String tableName, IndexImpl.IndexStatus status) {
        TableImpl table = this.getTable(tableName, true);
        IndexImpl index = (IndexImpl)table.getIndex(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Index does not exist: " + indexName + " on table: " + TableMetadata.makeQualifiedName(null, tableName));
        }
        if (index.getStatus() == status) {
            return null;
        }
        index.setStatus(status);
        return index;
    }

    public TableImpl getTable(String tableName, boolean mustExist) {
        String[] path = TableImpl.parseFullName(tableName);
        String firstKey = path[0];
        TableImpl targetTable = this.findTable(firstKey);
        if (path.length > 1) {
            for (int i = 1; i < path.length && targetTable != null; ++i) {
                try {
                    targetTable = this.getChildTable(path[i], targetTable);
                    continue;
                }
                catch (IllegalArgumentException ignored) {
                    targetTable = null;
                    break;
                }
            }
        }
        if (targetTable == null && mustExist) {
            throw new IllegalArgumentException("Table: " + TableMetadata.makeQualifiedName(null, tableName) + " does not exist in " + this);
        }
        return targetTable;
    }

    public TableImpl getTable(String tableName) {
        return this.getTable(tableName, false);
    }

    public boolean tableExists(String name, String tableName) {
        StringBuilder sb = new StringBuilder();
        if (tableName != null) {
            sb.append(tableName);
            sb.append(".");
        }
        if (name != null) {
            sb.append(name);
        }
        return this.getTable(sb.toString()) != null;
    }

    public static String makeQualifiedName(TableImpl table) {
        return TableMetadata.makeQualifiedName(null, table.getFullName());
    }

    public static String makeQualifiedName(String name, String parentName) {
        StringBuilder sb = new StringBuilder();
        if (parentName != null) {
            sb.append(parentName);
            if (name != null) {
                sb.append(".");
            }
        }
        if (name != null) {
            sb.append(name);
        }
        return sb.toString();
    }

    public TableImpl getChildTable(String tableName, Table parent) {
        return (TableImpl)parent.getChildTable(tableName);
    }

    public TableImpl getTable(TableMetadataKey mdKey) {
        TableImpl table = this.getTable(mdKey.getTableName());
        if (table != null && table.getIndexes().size() > 0) {
            table = table.clone();
            for (Map.Entry<String, Index> entry : table.getIndexes().entrySet()) {
                if (((IndexImpl)entry.getValue()).getStatus().isReady()) continue;
                table.removeIndex(entry.getKey());
            }
        }
        return table;
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    private TableImpl findTable(String key) {
        return (TableImpl)this.tables.get(key);
    }

    private void bumpSeqNum() {
        ++this.seqNum;
    }

    private long allocateId() {
        return ++this.keyId;
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public int getSequenceNumber() {
        return this.seqNum;
    }

    @Override
    public TableChangeList getChangeInfo(int startSeqNum) {
        return new TableChangeList(this.seqNum, this.getChanges(startSeqNum));
    }

    private List<TableChange> getChanges(int startSeqNum) {
        if (startSeqNum >= this.seqNum || this.changeHistory == null || this.changeHistory.isEmpty()) {
            return null;
        }
        if (startSeqNum < this.changeHistory.get(0).getSequenceNumber()) {
            return null;
        }
        LinkedList<TableChange> list = null;
        for (TableChange change : this.changeHistory) {
            if (change.getSequenceNumber() <= startSeqNum) continue;
            if (list == null) {
                list = new LinkedList<TableChange>();
            }
            list.add(change);
        }
        return list;
    }

    public boolean update(MetadataInfo metadataInfo) {
        if (metadataInfo instanceof TableChangeList) {
            return this.apply((TableChangeList)metadataInfo);
        }
        throw new IllegalArgumentException("Unknow metadata info: " + metadataInfo);
    }

    private boolean apply(TableChangeList changeList) {
        if (changeList.isEmpty()) {
            return false;
        }
        int origSeqNum = this.seqNum;
        for (TableChange change : changeList) {
            if (change.getSequenceNumber() <= this.seqNum || change.getSequenceNumber() > this.seqNum + 1 || !change.apply(this)) break;
            this.seqNum = change.getSequenceNumber();
            if (this.changeHistory == null) continue;
            this.changeHistory.add(change);
        }
        return origSeqNum != this.seqNum;
    }

    public TableMetadata getCopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (TableMetadata)ois.readObject();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public String toString() {
        return "TableMetadata[" + this.seqNum + ", " + this.tables.size() + ", " + (this.changeHistory == null ? "-" : Integer.valueOf(this.changeHistory.size())) + "]";
    }

    public static class TableMetadataKey
    implements MetadataKey,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String tableName;

        public TableMetadataKey(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public MetadataKey getMetadataKey() {
            return this;
        }

        public String toString() {
            return "TableMetadataKey[" + (this.tableName != null ? this.tableName : "null") + "]";
        }
    }
}

