/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Arrays;
import java.util.List;
import oracle.kv.Depth;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.parallelscan.ParallelScan;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

class TableScan {
    private TableScan() {
    }

    static TableIterator<Row> createTableIterator(final TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
            config.setMaxResultsBatches(iterateOptions.getMaxResultsBatches());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        return new TableIteratorWrapper<Row>(new ParallelScan.ParallelScanIteratorImpl<Row>(apiImpl.getStore(), config, params){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected ParallelScan.ConvertResultsReturnValue convertResults(Result result) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return new ParallelScan.ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(cnt - 1).getKeyBytes();
                ParallelScan.ResultsQueueEntry[] rowResults = new ParallelScan.ResultsQueueEntry[cnt];
                int actualCount = 0;
                for (ResultKeyValueVersion entry : byteKeyResults) {
                    ValueVersion vv;
                    RowImpl row;
                    RowImpl fullKey;
                    TableImpl table = (TableImpl)key.getTable();
                    if (targetTables.hasAncestorTables()) {
                        table = table.getTopLevelTable();
                    }
                    if ((fullKey = table.createRowFromKeyBytes(entry.getKeyBytes())) == null || (row = apiImpl.getRowFromValueVersion(vv = new ValueVersion(entry.getValue(), entry.getVersion()), fullKey, false)) == null) continue;
                    rowResults[actualCount++] = new ParallelScan.ResultsQueueEntry<RowImpl>(row, null);
                }
                if (actualCount < cnt) {
                    this.putResult(Arrays.copyOf(rowResults, actualCount));
                } else {
                    this.putResult(rowResults);
                }
                return new ParallelScan.ConvertResultsReturnValue(actualCount, resumeKey);
            }
        });
    }

    static TableIterator<PrimaryKey> createTableKeysIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        StoreIteratorConfig config = new StoreIteratorConfig();
        if (iterateOptions != null) {
            config.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
            config.setMaxResultsBatches(iterateOptions.getMaxResultsBatches());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        return new TableIteratorWrapper<PrimaryKey>(new ParallelScan.ParallelScanIteratorImpl<PrimaryKey>(apiImpl.getStore(), config, params){

            @Override
            protected InternalOperation generateGetterOp(byte[] resumeKey) {
                return new TableKeysIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey);
            }

            @Override
            protected ParallelScan.ConvertResultsReturnValue convertResults(Result result) {
                List<byte[]> byteKeyResults = result.getKeyList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return new ParallelScan.ConvertResultsReturnValue(0, null);
                }
                byte[] resumeKey = byteKeyResults.get(cnt - 1);
                ParallelScan.ResultsQueueEntry[] keyResults = new ParallelScan.ResultsQueueEntry[cnt];
                int actualCount = 0;
                for (byte[] entry : byteKeyResults) {
                    PrimaryKeyImpl pKey;
                    TableImpl table = (TableImpl)key.getTable();
                    if (targetTables.hasAncestorTables()) {
                        table = table.getTopLevelTable();
                    }
                    if ((pKey = table.createPrimaryKeyFromKeyBytes(entry)) == null) continue;
                    keyResults[actualCount++] = new ParallelScan.ResultsQueueEntry<PrimaryKeyImpl>(pKey, null);
                }
                if (actualCount < cnt) {
                    this.putResult(Arrays.copyOf(keyResults, actualCount));
                } else {
                    this.putResult(keyResults);
                }
                return new ParallelScan.ConvertResultsReturnValue(actualCount, resumeKey);
            }
        });
    }

    private static class TableIteratorWrapper<K>
    implements TableIterator<K> {
        private final ParallelScanIterator<K> psi;

        private TableIteratorWrapper(ParallelScanIterator<K> psi) {
            this.psi = psi;
        }

        @Override
        public void close() {
            this.psi.close();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return this.psi.getPartitionMetrics();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return this.psi.getShardMetrics();
        }

        @Override
        public K next() {
            return this.psi.next();
        }

        @Override
        public boolean hasNext() {
            return this.psi.hasNext();
        }

        @Override
        public void remove() {
            this.psi.remove();
        }
    }
}

