/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.map;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.kv.Key;
import oracle.kv.impl.map.KeyToPartitionMap;
import oracle.kv.impl.topo.PartitionId;

public class HashKeyToPartitionMap
implements KeyToPartitionMap {
    private static final long serialVersionUID = 1L;
    final BigInteger nPartitions;
    transient DigestCache digestCache = new DigestCache();

    public HashKeyToPartitionMap(int nPartitions) {
        this.nPartitions = new BigInteger(Integer.toString(nPartitions));
    }

    @Override
    public int getNPartitions() {
        return this.nPartitions.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionId getPartitionId(byte[] keyBytes) {
        MessageDigest md = null;
        try {
            if (this.digestCache == null) {
                this.digestCache = new DigestCache();
            }
            md = this.digestCache.get();
            md.update(keyBytes, 0, Key.getMajorPathLength(keyBytes));
            BigInteger index = new BigInteger(md.digest()).mod(this.nPartitions);
            PartitionId partitionId = new PartitionId(index.intValue() + 1);
            this.digestCache.free(md);
            return partitionId;
        }
        catch (Throwable throwable) {
            this.digestCache.free(md);
            throw throwable;
        }
    }

    static class DigestCache {
        private final AtomicBoolean inUse;
        private final MessageDigest digest;
        private final MessageDigest protoDigest;

        public DigestCache() {
            try {
                this.protoDigest = MessageDigest.getInstance("MD5");
                this.digest = (MessageDigest)this.protoDigest.clone();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MD5 algorithm unavailable");
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("MD5 clone failed");
            }
            this.inUse = new AtomicBoolean(false);
        }

        MessageDigest get() {
            if (this.inUse.compareAndSet(false, true)) {
                this.digest.reset();
                return this.digest;
            }
            try {
                return (MessageDigest)this.protoDigest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("MD5 clone failed");
            }
        }

        void free(MessageDigest md) {
            if (md == this.digest && !this.inUse.getAndSet(false)) {
                throw new IllegalStateException("Expected digest to be in use");
            }
        }
    }
}

