/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.VLSN;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.impl.mgmt.RepNodeStatusReceiver;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.OperationsStatsTracker;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.IllegalRepNodeServiceStateException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultHandler;
import oracle.kv.impl.rep.admin.RepNodeInfo;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureInternalMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

@SecureAPI
public class RepNodeAdminImpl
extends VersionedRemoteImpl
implements RepNodeAdmin {
    private final RepNode repNode;
    private final RepNodeService repNodeService;
    private final RepNodeAdminFaultHandler faultHandler;
    private final Logger logger;
    private RepNodeAdmin exportableRepNodeAdmin;
    private DbBackup dbBackup;
    RepNodeStatusReceiver statusReceiver = null;
    private RemoteTestInterface rti;
    private static final int REQUEST_QUIESCE_POLL_MS = 100;
    private static final int REQUEST_QUIESCE_MS = 10000;
    private volatile boolean shutdownActive = false;
    private static final String TEST_INTERFACE_NAME = "oracle.kv.impl.rep.RepNodeTestInterface";

    public RepNodeAdminImpl(RepNodeService repNodeService, RepNode repNode) {
        this.repNodeService = repNodeService;
        this.repNode = repNode;
        this.rti = null;
        this.logger = LoggerUtils.getLogger(this.getClass(), (RepNodeService.Params)repNodeService.getParams());
        this.faultHandler = new RepNodeAdminFaultHandler(repNodeService, this.logger, ProcessExitCode.RESTART);
    }

    private void assertRunning() {
        ConfigurableService.ServiceStatus status = this.repNodeService.getStatusTracker().getServiceStatus();
        if (status != ConfigurableService.ServiceStatus.RUNNING) {
            throw new IllegalRepNodeServiceStateException("RepNode is not RUNNING, current status is " + (Object)((Object)status));
        }
    }

    private void startTestInterface() {
        try {
            Class<?> cl = Class.forName(TEST_INTERFACE_NAME);
            Constructor<?> c = cl.getConstructor(this.repNodeService.getClass());
            this.rti = (RemoteTestInterface)c.newInstance(this.repNodeService);
            this.rti.start((short)4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @SecureR2Method
    public void newParameters(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void newParameters(AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNodeService.newParameters();
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void newGlobalParameters(AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNodeService.newGlobalParameters();
            }
        });
    }

    @Override
    @SecureR2Method
    public Topology getTopology(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.AUTHENTICATED})
    public Topology getTopology(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Topology>(){

            @Override
            public Topology execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getTopology() : null;
            }
        });
    }

    @Override
    @SecureR2Method
    public int getTopoSeqNum(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.AUTHENTICATED})
    public int getTopoSeqNum(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                if (status != ConfigurableService.ServiceStatus.RUNNING) {
                    return 0;
                }
                Topology topology = RepNodeAdminImpl.this.repNode.getTopology();
                return topology != null ? topology.getSequenceNumber() : 0;
            }
        });
    }

    @Override
    @SecureR2Method
    public LoadParameters getParams(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public LoadParameters getParams(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoadParameters>(){

            @Override
            public LoadParameters execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.getAllParams();
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void configure(final Set<Metadata<? extends MetadataInfo>> metadataSet, AuthContext authCtx, short serialVersion) {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                for (Metadata md : metadataSet) {
                    RepNodeAdminImpl.this.repNode.updateMetadata(md);
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public void configure(Topology topology, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @Deprecated
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void configure(final Topology topology, AuthContext authCtx, short serialVersion) {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNode.updateMetadata((Metadata)topology);
            }
        });
    }

    @Override
    @SecureR2Method
    @Deprecated
    public void updateTopology(Topology newTopology, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @Deprecated
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void updateTopology(Topology newTopology, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.updateMetadata(newTopology, authCtx, serialVersion);
    }

    @Override
    @Deprecated
    @SecureR2Method
    public int updateTopology(TopologyInfo topoInfo, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @Deprecated
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public int updateTopology(TopologyInfo topoInfo, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.updateMetadata(topoInfo, authCtx, serialVersion);
    }

    @Override
    @Deprecated
    @SecureR2Method
    public void shutdown(boolean force, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void shutdown(final boolean force, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                RepNodeAdminImpl.this.logger.log(Level.INFO, "RepNodeAdmin shutdown({0})", force);
                RepNodeAdminImpl.this.shutdownActive = true;
                try {
                    RepNodeAdminImpl.this.repNodeService.stop(force);
                }
                finally {
                    RepNodeAdminImpl.this.shutdownActive = false;
                }
            }
        });
    }

    public void startup() throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                String kvsName = RepNodeAdminImpl.this.repNodeService.getParams().getGlobalParams().getKVStoreName();
                RepNodeParams rnp = RepNodeAdminImpl.this.repNodeService.getRepNodeParams();
                StorageNodeParams snp = RepNodeAdminImpl.this.repNodeService.getParams().getStorageNodeParams();
                String csfName = ClientSocketFactory.factoryName(kvsName, RepNodeId.getPrefix(), RegistryUtils.InterfaceType.ADMIN.interfaceName());
                RMISocketPolicy rmiPolicy = RepNodeAdminImpl.this.repNodeService.getParams().getSecurityParams().getRMISocketPolicy();
                RMISocketPolicy.SocketFactoryPair sfp = rnp.getAdminSFP(rmiPolicy, snp.getServicePortRange(), csfName);
                if (sfp.getServerFactory() != null) {
                    sfp.getServerFactory().setConnectionLogger(RepNodeAdminImpl.this.logger);
                }
                RepNodeAdminImpl.this.initExportableRepNodeAdmin();
                RepNodeAdminImpl.this.repNodeService.rebind((Remote)RepNodeAdminImpl.this.exportableRepNodeAdmin, RegistryUtils.InterfaceType.ADMIN, sfp.getClientFactory(), sfp.getServerFactory());
                RepNodeAdminImpl.this.logger.info("RepNodeAdmin registered");
                RepNodeAdminImpl.this.startTestInterface();
            }
        });
    }

    private void initExportableRepNodeAdmin() {
        try {
            this.exportableRepNodeAdmin = (RepNodeAdmin)SecureProxy.create((Object)this, (AccessChecker)this.repNodeService.getRepNodeSecurity().getAccessChecker(), (ProcessFaultHandler)((Object)this.faultHandler));
            this.logger.info("Successfully created secure proxy for the repnode admin");
        }
        catch (ConfigurationException ce) {
            this.logger.info("Unable to create proxy: " + (Object)((Object)ce) + " : " + ce.getMessage());
            throw new IllegalStateException("Unabled to create proxy", ce);
        }
    }

    public void stop() {
        try {
            boolean quiesced;
            this.repNodeService.unbind((Remote)this.exportableRepNodeAdmin, RegistryUtils.InterfaceType.ADMIN);
            this.logger.info("RepNodeAdmin stopping");
            if (this.rti != null) {
                this.rti.stop((short)4);
            }
            if (!(quiesced = new PollCondition(100, 10000){

                @Override
                protected boolean condition() {
                    return RepNodeAdminImpl.this.faultHandler.getActiveRequests() == (RepNodeAdminImpl.this.shutdownActive ? 1 : 0);
                }
            }.await())) {
                this.logger.info(this.faultHandler.getActiveRequests() + " admin requests were active on close.");
            }
        }
        catch (RemoteException e) {
            this.logger.log(Level.INFO, "Ignoring exception while stopping repNodeAdmin", e);
            return;
        }
    }

    @Override
    @SecureR2Method
    public RepNodeStatus ping(short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @PublicMethod
    public RepNodeStatus ping(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeStatus>(){

            @Override
            public RepNodeStatus execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                ReplicatedEnvironment.State state = ReplicatedEnvironment.State.DETACHED;
                long currentVLSN = 0L;
                try {
                    ReplicatedEnvironment env = RepNodeAdminImpl.this.repNode.getEnv(1L);
                    if (env != null) {
                        RepImpl repImpl = RepInternal.getRepImpl((ReplicatedEnvironment)env);
                        VLSNIndex vlsnIndex = repImpl == null ? null : RepInternal.getRepImpl((ReplicatedEnvironment)env).getVLSNIndex();
                        currentVLSN = vlsnIndex == null ? VLSN.NULL_VLSN.getSequence() : vlsnIndex.getRange().getLast().getSequence();
                        try {
                            state = env.getState();
                        }
                        catch (IllegalStateException iae) {
                            state = ReplicatedEnvironment.State.DETACHED;
                        }
                    }
                }
                catch (EnvironmentFailureException ignored) {
                    // empty catch block
                }
                String haHostPort = RepNodeAdminImpl.this.repNode.getRepNodeParams().getJENodeHostPort();
                return new RepNodeStatus(status, state, currentVLSN, haHostPort, RepNodeAdminImpl.this.repNode.getMigrationStatus());
            }
        });
    }

    @Override
    @SecureR2Method
    public RepNodeInfo getInfo(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public RepNodeInfo getInfo(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeInfo>(){

            @Override
            public RepNodeInfo execute() {
                RepNodeAdminImpl.this.assertRunning();
                return new RepNodeInfo(RepNodeAdminImpl.this.repNode);
            }
        });
    }

    @Override
    @SecureR2Method
    public String[] startBackup(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public String[] startBackup(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<String[]>(){

            @Override
            public String[] execute() {
                ReplicatedEnvironment env;
                RepNodeAdminImpl.this.assertRunning();
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    RepNodeAdminImpl.this.logger.warning("startBackup: dbBackup not null");
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                }
                if ((env = RepNodeAdminImpl.this.repNode.getEnv(1L)) == null) {
                    throw new OperationFaultException("Environment unavailable");
                }
                RepNodeAdminImpl.this.logger.info("startBackup: starting backup/snapshot");
                RepNodeAdminImpl.this.dbBackup = new DbBackup((Environment)env);
                RepNodeAdminImpl.this.dbBackup.startBackup();
                return RepNodeAdminImpl.this.dbBackup.getLogFilesInBackupSet();
            }
        });
    }

    @Override
    @SecureR2Method
    public long stopBackup(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public long stopBackup(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Long>(){

            @Override
            public Long execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.logger.info("Ending backup/snapshot");
                long lastFile = -1L;
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    lastFile = RepNodeAdminImpl.this.dbBackup.getLastFileInBackupSet();
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                    RepNodeAdminImpl.this.dbBackup = null;
                }
                return lastFile;
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean updateMemberHAAddress(String groupName, String targetNodeName, String targetHelperHosts, String newNodeHostPort, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean updateMemberHAAddress(final String groupName, final String targetNodeName, final String targetHelperHosts, final String newNodeHostPort, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() {
                RepNodeAdminImpl.this.assertRunning();
                try {
                    RepNodeAdminImpl.this.repNodeService.updateMemberHAAddress(groupName, targetNodeName, targetHelperHosts, newNodeHostPort);
                    return true;
                }
                catch (UnknownMasterException e) {
                    return false;
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean initiateMasterTransfer(RepNodeId replicaId, int timeout, TimeUnit timeUnit, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean initiateMasterTransfer(final RepNodeId replicaId, final int timeout, final TimeUnit timeUnit, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status != ConfigurableService.ServiceStatus.RUNNING ? false : RepNodeAdminImpl.this.repNode.initiateMasterTransfer(replicaId, timeout, timeUnit);
            }
        });
    }

    @Override
    @SecureR2Method
    public RepNodeAdmin.PartitionMigrationState migratePartition(PartitionId partitionId, RepGroupId sourceRGId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public RepNodeAdmin.PartitionMigrationState migratePartition(final PartitionId partitionId, final RepGroupId sourceRGId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.PartitionMigrationState>(){

            @Override
            public RepNodeAdmin.PartitionMigrationState execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.migratePartition(partitionId, sourceRGId);
            }
        });
    }

    @Override
    @SecureR2Method
    public RepNodeAdmin.PartitionMigrationState getMigrationState(PartitionId partitionId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public RepNodeAdmin.PartitionMigrationState getMigrationState(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.PartitionMigrationState>(){

            @Override
            public RepNodeAdmin.PartitionMigrationState execute() {
                try {
                    RepNodeAdminImpl.this.assertRunning();
                    return RepNodeAdminImpl.this.repNode.getMigrationState(partitionId);
                }
                catch (IllegalRepNodeServiceStateException irnsse) {
                    return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause((Exception)((Object)irnsse));
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public RepNodeAdmin.PartitionMigrationState canCancel(PartitionId partitionId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public RepNodeAdmin.PartitionMigrationState canCancel(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.PartitionMigrationState>(){

            @Override
            public RepNodeAdmin.PartitionMigrationState execute() {
                try {
                    RepNodeAdminImpl.this.assertRunning();
                    return RepNodeAdminImpl.this.repNode.canCancel(partitionId);
                }
                catch (IllegalRepNodeServiceStateException irnsse) {
                    return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause((Exception)((Object)irnsse));
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean canceled(PartitionId partitionId, RepGroupId targetRGId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean canceled(final PartitionId partitionId, final RepGroupId targetRGId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status != ConfigurableService.ServiceStatus.RUNNING ? false : RepNodeAdminImpl.this.repNode.canceled(partitionId, targetRGId);
            }
        });
    }

    @Override
    @SecureR2Method
    public PartitionMigrationStatus getMigrationStatus(PartitionId partitionId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public PartitionMigrationStatus getMigrationStatus(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<PartitionMigrationStatus>(){

            @Override
            public PartitionMigrationStatus execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.getMigrationStatus(partitionId);
            }
        });
    }

    @Override
    @SecureR2Method
    public void installStatusReceiver(RepNodeStatusReceiver receiver, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void installStatusReceiver(final RepNodeStatusReceiver receiver, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.statusReceiver = receiver;
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                ServiceStatusTracker rnStatusTracker = RepNodeAdminImpl.this.repNodeService.getStatusTracker();
                ConfigurableService.ServiceStatus status = rnStatusTracker.getServiceStatus();
                ServiceStatusChange s = new ServiceStatusChange(status);
                receiver.updateRnStatus(s);
                rnStatusTracker.addListener((ServiceStatusTracker.Listener)new StatusListener());
                OperationsStatsTracker opStatsTracker = RepNodeAdminImpl.this.repNodeService.getOpStatsTracker();
                opStatsTracker.addListener((OperationsStatsTracker.Listener)new OpStatsListener());
                RepNodeAdminImpl.this.repNodeService.addParameterListener((ParameterListener)new ParameterChangeListener());
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean awaitConsistency(long targetTime, int timeout, TimeUnit timeoutUnit, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean awaitConsistency(final long targetTime, final int timeout, final TimeUnit timeoutUnit, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.awaitConsistency(targetTime, timeout, timeoutUnit);
            }
        });
    }

    @Override
    @SecureR2Method
    public int getMetadataSeqNum(Metadata.MetadataType type, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public int getMetadataSeqNum(final Metadata.MetadataType type, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                RepNodeAdminImpl.this.checkMetadataAccess(type);
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                if (status != ConfigurableService.ServiceStatus.RUNNING) {
                    return 0;
                }
                return RepNodeAdminImpl.this.repNode.getMetadataSeqNum(type);
            }
        });
    }

    @Override
    @SecureR2Method
    public Metadata<?> getMetadata(Metadata.MetadataType type, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public Metadata<?> getMetadata(final Metadata.MetadataType type, AuthContext authCtx, short serialVersion) {
        return (Metadata)this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Metadata<?>>(){

            @Override
            public Metadata<?> execute() {
                RepNodeAdminImpl.this.checkMetadataAccess(type);
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type) : null;
            }
        });
    }

    @Override
    @SecureR2Method
    public MetadataInfo getMetadata(Metadata.MetadataType type, int seqNum, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public MetadataInfo getMetadata(final Metadata.MetadataType type, final int seqNum, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                RepNodeAdminImpl.this.checkMetadataAccess(type);
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type, seqNum) : null;
            }
        });
    }

    @Override
    @SecureR2Method
    public MetadataInfo getMetadata(Metadata.MetadataType type, MetadataKey key, int seqNum, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureInternalMethod
    public MetadataInfo getMetadata(final Metadata.MetadataType type, final MetadataKey key, final int seqNum, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                RepNodeAdminImpl.this.checkMetadataAccess(type);
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type, key, seqNum) : null;
            }
        });
    }

    @Override
    @SecureR2Method
    public void updateMetadata(Metadata<?> newMetadata, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public void updateMetadata(final Metadata<?> newMetadata, AuthContext authCtx, short serialVersion) {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                if (!RepNodeAdminImpl.this.repNode.updateMetadata(newMetadata)) {
                    throw new OperationFaultException("Update " + (Object)((Object)newMetadata.getType()) + " metadata seq# " + newMetadata.getSequenceNumber() + " failed");
                }
            }
        });
    }

    @Override
    @SecureR2Method
    public int updateMetadata(MetadataInfo metadataInfo, short serialVersion) {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public int updateMetadata(final MetadataInfo metadataInfo, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.updateMetadata(metadataInfo);
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean addIndexComplete(final String indexId, final String tableName, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.addIndexComplete(indexId, tableName);
            }
        });
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.INTERNAL})
    public boolean removeTableDataComplete(final String tableName, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.removeTableDataComplete(tableName);
            }
        });
    }

    private void checkMetadataAccess(Metadata.MetadataType mdType) throws SessionAccessException, KVSecurityException {
        AccessChecker accessChecker = this.repNodeService.getRepNodeSecurity().getAccessChecker();
        if (accessChecker != null) {
            try {
                accessChecker.checkAccess(ExecutionContext.getCurrent(), (OperationContext)new MetadataContext(mdType));
            }
            catch (KVSecurityException kvse) {
                throw new ClientAccessException(kvse);
            }
        }
    }

    private class ParameterChangeListener
    implements ParameterListener {
        private ParameterChangeListener() {
        }

        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            try {
                RepNodeAdminImpl.this.statusReceiver.receiveNewParams(newMap);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.WARNING, "Failure to deliver parameter change to MgmtAgent", re);
                return;
            }
        }
    }

    private class OpStatsListener
    implements OperationsStatsTracker.Listener {
        private OpStatsListener() {
        }

        public void receiveStats(StatsPacket packet) {
            try {
                RepNodeAdminImpl.this.statusReceiver.receiveStats(packet);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.WARNING, "Failure to deliver perf stats to MgmtAgent", re);
                return;
            }
        }
    }

    private class StatusListener
    implements ServiceStatusTracker.Listener {
        private StatusListener() {
        }

        public void update(ServiceStatusChange prevStatus, ServiceStatusChange newStatus) {
            try {
                RepNodeAdminImpl.this.statusReceiver.updateRnStatus(newStatus);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.WARNING, "Failure to deliver status update to SNA", re);
                return;
            }
        }
    }

    private static class MetadataContext
    implements OperationContext {
        private final Metadata.MetadataType mdType;
        private static final List<KVStoreRolePrincipal> authenticatedRoleList = Collections.unmodifiableList(Arrays.asList(KVStoreRolePrincipal.AUTHENTICATED));
        private static final List<KVStoreRolePrincipal> internalRoleList = Collections.unmodifiableList(Arrays.asList(KVStoreRolePrincipal.INTERNAL));

        private MetadataContext(Metadata.MetadataType type) {
            this.mdType = type;
        }

        public String describe() {
            return "Metadata request for type: " + (Object)((Object)this.mdType);
        }

        public List<KVStoreRolePrincipal> getRequiredRoles() {
            if (this.mdType.equals((Object)Metadata.MetadataType.SECURITY)) {
                return internalRoleList;
            }
            return authenticatedRoleList;
        }
    }
}

