/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.File;
import oracle.kv.impl.security.PasswordStore;

public abstract class PasswordManager {
    public static final String FILE_STORE_MANAGER_CLASS = "oracle.kv.impl.security.filestore.FileStoreManager";
    public static final String WALLET_MANAGER_CLASS = "oracle.kv.impl.security.wallet.WalletManager";
    private static final String[] preferredImplementations = new String[]{"oracle.kv.impl.security.wallet.WalletManager", "oracle.kv.impl.security.filestore.FileStoreManager"};

    public static PasswordManager load(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> pwdMgrClass = Class.forName(className);
        return (PasswordManager)pwdMgrClass.newInstance();
    }

    public static String preferredManagerClass() {
        for (String s : preferredImplementations) {
            try {
                Class.forName(s);
                return s;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        return null;
    }

    public abstract PasswordStore getStoreHandle(File var1);

    public abstract boolean storeLocationIsDirectory();
}

