/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.concurrent.atomic.AtomicReference;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.topo.ResourceId;

public abstract class LoginHandle {
    private final AtomicReference<LoginToken> loginToken;

    protected LoginHandle(LoginToken loginToken) {
        this.loginToken = new AtomicReference<LoginToken>(loginToken);
    }

    public LoginToken getLoginToken() {
        return this.loginToken.get();
    }

    protected boolean updateLoginToken(LoginToken oldToken, LoginToken newToken) {
        return this.loginToken.compareAndSet(oldToken, newToken);
    }

    public abstract LoginToken renewToken(LoginToken var1) throws SessionAccessException;

    public abstract void logoutToken() throws SessionAccessException;

    public abstract boolean isUsable(ResourceId.ResourceType var1);
}

