/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.AccessException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.List;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.FaultException;
import oracle.kv.KVStoreException;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.fault.EnvironmentTimeoutException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.security.ClientProxyCredentials;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.security.login.UserLoginAPI;
import oracle.kv.impl.security.login.UserLoginManager;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeLoginManager
extends UserLoginManager {
    private TopologyManager topoManager;

    public RepNodeLoginManager(String username, boolean autoRenew) {
        super(username, autoRenew);
    }

    public void bootstrap(String[] registryHostPorts, LoginCredentials loginCreds, String expectedStoreName) throws KVStoreException, AuthenticationFailureException {
        HostPort[] hostPorts;
        Exception cause = null;
        String wrongStoreName = null;
        for (HostPort hostPort : hostPorts = HostPort.parse(registryHostPorts)) {
            String registryHostname = hostPort.hostname();
            int registryPort = hostPort.port();
            try {
                Registry snRegistry = RegistryUtils.getRegistry(registryHostname, registryPort, expectedStoreName);
                for (String serviceName : snRegistry.list()) {
                    try {
                        HostPort loginTarget;
                        String svcStoreName = RegistryUtils.isRepNodeLogin(serviceName);
                        if (svcStoreName == null) continue;
                        if (expectedStoreName != null && !expectedStoreName.equals(svcStoreName)) {
                            wrongStoreName = svcStoreName;
                            continue;
                        }
                        Remote stub = snRegistry.lookup(serviceName);
                        if (!(stub instanceof UserLogin) || !this.bootstrapLogin((UserLogin)stub, loginCreds, loginTarget = new HostPort(registryHostname, registryPort))) continue;
                        break;
                    }
                    catch (SessionAccessException e) {
                        cause = e;
                    }
                    catch (AccessException e) {
                        cause = e;
                    }
                    catch (ConnectIOException e) {
                        cause = e;
                    }
                    catch (NotBoundException e) {
                        cause = e;
                    }
                    catch (InternalFaultException e) {
                        if (cause != null) continue;
                        cause = e;
                    }
                    catch (FaultException fe) {
                        if (fe.getFaultClassName().equals(EnvironmentTimeoutException.class.getName())) {
                            if (cause != null) continue;
                            cause = fe;
                            continue;
                        }
                        throw fe;
                    }
                }
                if (this.getLoginHandle() == null) continue;
                break;
            }
            catch (RemoteException e) {
                cause = e;
            }
        }
        if (this.getLoginHandle() == null) {
            if (wrongStoreName != null) {
                throw new KVStoreException("Could not establish an initial login from: " + Arrays.toString(registryHostPorts) + " - ignored non-matching store name " + wrongStoreName, cause);
            }
            throw new KVStoreException("Could not establish an initial login from: " + Arrays.toString(registryHostPorts), cause);
        }
    }

    public void setTopology(TopologyManager topoMgr) {
        this.topoManager = topoMgr;
        LoginHandle currentHandle = this.getLoginHandle();
        if (currentHandle == null) {
            return;
        }
        LiveRNLoginHandle liveLoginHandle = new LiveRNLoginHandle(currentHandle.getLoginToken());
        this.init(liveLoginHandle);
    }

    public synchronized void login(LoginCredentials creds) throws AuthenticationRequiredException, AuthenticationFailureException {
        if (this.topoManager == null) {
            throw new IllegalStateException("Not properly initialized");
        }
        Exception cause = null;
        Topology topo = this.topoManager.getLocalTopology();
        RegistryUtils ru = new RegistryUtils(topo, null);
        for (RepGroup rg : topo.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                try {
                    UserLoginAPI rnLogin = ru.getRepNodeLogin((RepNodeId)rn.getResourceId());
                    LoginResult result = rnLogin.login(creds);
                    if (result.getLoginToken() == null) continue;
                    LiveRNLoginHandle loginHandle = new LiveRNLoginHandle(result.getLoginToken());
                    this.init(loginHandle);
                    return;
                }
                catch (AuthenticationFailureException e) {
                    throw e;
                }
                catch (AccessException e) {
                    cause = e;
                }
                catch (NotBoundException e) {
                    cause = e;
                }
                catch (InternalFaultException e) {
                    if (cause != null) continue;
                    cause = e;
                }
                catch (FaultException fe) {
                    if (fe.getFaultClassName().equals(EnvironmentTimeoutException.class.getName())) {
                        if (cause != null) continue;
                        cause = fe;
                        continue;
                    }
                    throw fe;
                }
                catch (RemoteException re) {
                    if (cause != null) continue;
                    cause = re;
                }
            }
        }
        throw new AuthenticationRequiredException(cause, false);
    }

    private boolean bootstrapLogin(UserLogin userLogin, LoginCredentials loginCreds, HostPort loginTarget) throws RemoteException, AuthenticationFailureException, SessionAccessException {
        UserLoginAPI ulAPI = UserLoginAPI.wrap(userLogin);
        LoginResult loginResult = loginCreds instanceof ClientProxyCredentials ? this.proxyBootstrapLogin(userLogin, (ClientProxyCredentials)loginCreds, loginTarget) : ulAPI.login(loginCreds);
        if (loginResult.getLoginToken() != null) {
            BSRNLoginHandle loginHandle = new BSRNLoginHandle(loginResult.getLoginToken(), ulAPI);
            this.init(loginHandle);
            return true;
        }
        return false;
    }

    private LoginResult proxyBootstrapLogin(UserLogin userLogin, ClientProxyCredentials loginCreds, HostPort loginTarget) throws RemoteException, SessionAccessException {
        UserLoginAPI localAPI = UserLoginAPI.wrap(userLogin, loginCreds.getInternalManager().getHandle(loginTarget, ResourceId.ResourceType.REP_NODE));
        return localAPI.proxyLogin(new ProxyCredentials(loginCreds.getUser()));
    }

    static class BSRNLoginHandle
    extends UserLoginManager.AbstractUserLoginHandle {
        private UserLoginAPI loginAPI;

        public BSRNLoginHandle(LoginToken loginToken, UserLoginAPI loginAPI) {
            super(loginToken);
            this.loginAPI = loginAPI;
        }

        @Override
        protected UserLoginAPI getLoginAPI() throws RemoteException {
            return this.loginAPI;
        }

        @Override
        public boolean isUsable(ResourceId.ResourceType rtype) {
            return rtype.equals((Object)ResourceId.ResourceType.REP_NODE) || rtype.equals((Object)ResourceId.ResourceType.ADMIN);
        }
    }

    class LiveRNLoginHandle
    extends UserLoginManager.AbstractUserLoginHandle {
        public LiveRNLoginHandle(LoginToken loginToken) {
            super(loginToken);
        }

        @Override
        protected UserLoginAPI getLoginAPI() throws RemoteException {
            LoginToken token = this.getLoginToken();
            if (token == null) {
                return null;
            }
            SessionId sessId = token.getSessionId();
            String storename = RepNodeLoginManager.this.topoManager.getTopology().getKVStoreName();
            Topology topo = RepNodeLoginManager.this.topoManager.getTopology();
            if (sessId.getIdValueScope() == SessionId.IdScope.PERSISTENT) {
                List<RepNode> repNodes = topo.getSortedRepNodes();
                RemoteException toThrow = null;
                for (RepNode rn : repNodes) {
                    StorageNodeId snid = rn.getStorageNodeId();
                    StorageNode sn = topo.get(snid);
                    try {
                        return RegistryUtils.getRepNodeLogin(storename, sn.getHostname(), sn.getRegistryPort(), (RepNodeId)rn.getResourceId(), (LoginManager)null);
                    }
                    catch (RemoteException re) {
                        if (toThrow != null) continue;
                        toThrow = re;
                    }
                    catch (NotBoundException nbe) {
                    }
                }
                if (toThrow != null) {
                    throw toThrow;
                }
                throw new RemoteException("No RepNode available");
            }
            ResourceId rid = sessId.getAllocator();
            if (!(rid instanceof RepNodeId)) {
                throw new IllegalStateException("Expected a RepNodeId");
            }
            RepNodeId rnid = (RepNodeId)rid;
            RepGroup rg = topo.get(new RepGroupId(rnid.getGroupId()));
            RepNode rn = rg.get(rnid);
            if (rn == null) {
                throw new IllegalStateException("Missing RepNode with id " + rnid + " in topology");
            }
            StorageNodeId snid = rn.getStorageNodeId();
            StorageNode sn = topo.get(snid);
            try {
                return RegistryUtils.getRepNodeLogin(storename, sn.getHostname(), sn.getRegistryPort(), (RepNodeId)rn.getResourceId(), (LoginManager)null);
            }
            catch (NotBoundException nbe) {
                throw new RemoteException("login interface not bound", nbe);
            }
        }

        @Override
        public boolean isUsable(ResourceId.ResourceType rtype) {
            return rtype.equals((Object)ResourceId.ResourceType.REP_NODE) || rtype.equals((Object)ResourceId.ResourceType.ADMIN);
        }
    }
}

