/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RepNodeId
extends ResourceId
implements Comparable<RepNodeId> {
    private static final long serialVersionUID = 1L;
    private static final String RN_PREFIX = "rn";
    private int groupId;
    private int nodeNum;

    public RepNodeId(int groupId, int nodeNum) {
        this.groupId = groupId;
        this.nodeNum = nodeNum;
    }

    public static String getPrefix() {
        return RN_PREFIX;
    }

    private RepNodeId() {
    }

    public RepNodeId(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.groupId = in.readInt();
        this.nodeNum = in.readInt();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.groupId);
        out.writeInt(this.nodeNum);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.REP_NODE;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    @Override
    public String getFullName() {
        return new RepGroupId(this.getGroupId()).getGroupName() + "-" + RN_PREFIX + this.getNodeNum();
    }

    public static RepNodeId parse(String fullName) {
        String[] idArgs = fullName.split("-");
        if (idArgs.length == 2) {
            RepGroupId rgId = RepGroupId.parse(idArgs[0]);
            int nodeNum = RepNodeId.parseForInt(RN_PREFIX, idArgs[1]);
            return new RepNodeId(rgId.getGroupId(), nodeNum);
        }
        idArgs = fullName.split(",");
        if (idArgs.length == 2) {
            try {
                return new RepNodeId(Integer.parseInt(idArgs[0]), Integer.parseInt(idArgs[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(fullName + " is not a valid RepNode id. It must follow the format rgX-rnY");
    }

    public String getGroupName() {
        return new RepGroupId(this.getGroupId()).getGroupName();
    }

    public String toString() {
        return this.getFullName();
    }

    public RepNode getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepNodeId other = (RepNodeId)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        return this.nodeNum == other.nodeNum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        result = 31 * result + this.nodeNum;
        return result;
    }

    @Override
    public int compareTo(RepNodeId other) {
        int grp = this.getGroupId() - other.getGroupId();
        if (grp != 0) {
            return grp;
        }
        return this.getNodeNum() - other.getNodeNum();
    }
}

