/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Persistent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.fault.UnknownVersionException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterMap;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepGroupMap;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.StorageNodeMap;
import oracle.kv.impl.topo.TopologyHolder;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.topo.change.TopologyChangeTracker;

@Persistent(version=1)
public class Topology
implements Metadata<TopologyInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int version;
    private long id = 0L;
    private String kvStoreName;
    private PartitionMap partitionMap;
    private RepGroupMap repGroupMap;
    private StorageNodeMap storageNodeMap;
    private DatacenterMap datacenterMap;
    private Map<ResourceId.ResourceType, ComponentMap<? extends ResourceId, ? extends Component<?>>> typeToComponentMaps;
    private TopologyChangeTracker changeTracker;
    public static final int EMPTY_TOPOLOGY_ID = -1;
    public static final int NOCHECK_TOPOLOGY_ID = 0;
    public static final int CURRENT_VERSION = 1;

    public Topology(String kvStoreName) {
        this(kvStoreName, System.currentTimeMillis());
    }

    public Topology(String kvStoreName, long topoId) {
        this.kvStoreName = kvStoreName;
        this.partitionMap = new PartitionMap(this);
        this.repGroupMap = new RepGroupMap(this);
        this.storageNodeMap = new StorageNodeMap(this);
        this.datacenterMap = new DatacenterMap(this);
        this.changeTracker = new TopologyChangeTracker(this);
        this.typeToComponentMaps = new HashMap();
        for (ComponentMap<?, ?> m : this.getAllComponentMaps()) {
            this.typeToComponentMaps.put(m.getResourceType(), m);
        }
        this.id = topoId;
        this.version = 1;
    }

    private Topology() {
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TOPOLOGY;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    ComponentMap<?, ?>[] getAllComponentMaps() {
        return new ComponentMap[]{this.partitionMap, this.repGroupMap, this.storageNodeMap, this.datacenterMap};
    }

    public String getKVStoreName() {
        return this.kvStoreName;
    }

    public Component<?> get(ResourceId resourceId) {
        return resourceId.getComponent(this);
    }

    public Datacenter get(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.get(datacenterId);
    }

    public StorageNode get(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.get(storageNodeId);
    }

    public RepGroup get(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.get(repGroupId);
    }

    public Partition get(PartitionId partitionMapId) {
        return (Partition)this.partitionMap.get(partitionMapId);
    }

    public RepNode get(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        return rg == null ? null : rg.get(repNodeId);
    }

    public Datacenter getDatacenter(StorageNodeId storageNodeId) {
        return this.get(this.get(storageNodeId).getDatacenterId());
    }

    public Datacenter getDatacenter(RepNodeId repNodeId) {
        return this.getDatacenter(this.get(repNodeId).getStorageNodeId());
    }

    public PartitionId getPartitionId(byte[] keyBytes) {
        if (this.partitionMap.size() == 0) {
            throw new IllegalArgumentException("Store is not yet configured and deployed, and cannot accept data");
        }
        return this.partitionMap.getPartitionId(keyBytes);
    }

    public RepGroupId getRepGroupId(PartitionId partitionId) {
        return this.partitionMap.getRepGroupId(partitionId);
    }

    public Set<RepGroupId> getRepGroupIds() {
        HashSet<RepGroupId> rgIdSet = new HashSet<RepGroupId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            rgIdSet.add((RepGroupId)rg.getResourceId());
        }
        return rgIdSet;
    }

    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    public RepGroupMap getRepGroupMap() {
        return this.repGroupMap;
    }

    public StorageNodeMap getStorageNodeMap() {
        return this.storageNodeMap;
    }

    public List<RepNode> getSortedRepNodes() {
        ArrayList<RepNode> srn = new ArrayList<RepNode>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                srn.add(rn);
            }
        }
        Collections.sort(srn);
        return srn;
    }

    public List<RepNodeId> getSortedRepNodeIds(RepGroupId rgId) {
        ArrayList<RepNodeId> srn = new ArrayList<RepNodeId>();
        for (RepNode rn : ((RepGroup)this.repGroupMap.get(rgId)).getRepNodes()) {
            srn.add((RepNodeId)rn.getResourceId());
        }
        Collections.sort(srn);
        return srn;
    }

    public List<StorageNode> getSortedStorageNodes() {
        ArrayList<StorageNode> sns = new ArrayList<StorageNode>(this.storageNodeMap.getAll());
        Collections.sort(sns);
        return sns;
    }

    public List<StorageNodeId> getStorageNodeIds() {
        ArrayList<StorageNodeId> snIds = new ArrayList<StorageNodeId>();
        for (StorageNode sn : this.storageNodeMap.getAll()) {
            snIds.add((StorageNodeId)sn.getResourceId());
        }
        return snIds;
    }

    public Set<RepNodeId> getRepNodeIds(DatacenterId dcid) {
        HashSet<RepNodeId> allRNIds = new HashSet<RepNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeId rnid = (RepNodeId)rn.getResourceId();
                if (dcid == null) {
                    allRNIds.add(rnid);
                    continue;
                }
                if (!dcid.equals(this.getDatacenter(rnid).getResourceId())) continue;
                allRNIds.add(rnid);
            }
        }
        return allRNIds;
    }

    public Set<RepNodeId> getRepNodeIds() {
        return this.getRepNodeIds(null);
    }

    public Set<RepNodeId> getHostedRepNodeIds(StorageNodeId snId) {
        HashSet<RepNodeId> snRNIds = new HashSet<RepNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                if (!rn.getStorageNodeId().equals(snId)) continue;
                snRNIds.add((RepNodeId)rn.getResourceId());
            }
        }
        return snRNIds;
    }

    public DatacenterMap getDatacenterMap() {
        return this.datacenterMap;
    }

    public List<Datacenter> getSortedDatacenters() {
        ArrayList<Datacenter> sdc = new ArrayList<Datacenter>(this.datacenterMap.getAll());
        Collections.sort(sdc, new Comparator<Datacenter>(){

            @Override
            public int compare(Datacenter o1, Datacenter o2) {
                DatacenterId id1 = (DatacenterId)o1.getResourceId();
                DatacenterId id2 = (DatacenterId)o2.getResourceId();
                return id1.getDatacenterId() - id2.getDatacenterId();
            }
        });
        return sdc;
    }

    public TopologyChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    @Override
    public int getSequenceNumber() {
        return this.changeTracker.getSeqNum();
    }

    public Topology getCopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Topology)ois.readObject();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public boolean apply(List<TopologyChange> changes) {
        if (changes == null) {
            return false;
        }
        if (changes.size() == 0) {
            return false;
        }
        if (changes.get(0).getSequenceNumber() > this.getSequenceNumber() + 1) {
            throw new IllegalStateException("Unexpected gap in topology sequence. Current sequence=" + this.getSequenceNumber() + ", first change =" + changes.get(0).getSequenceNumber());
        }
        int changeCount = 0;
        for (TopologyChange change : changes) {
            if (change.getSequenceNumber() <= this.getSequenceNumber()) continue;
            ++changeCount;
            ResourceId.ResourceType rtype = change.getResourceId().getType();
            if (rtype == ResourceId.ResourceType.REP_NODE) {
                RepNodeId rnId = (RepNodeId)change.getResourceId();
                RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(rnId.getGroupId()));
                rg.apply(change);
                continue;
            }
            this.typeToComponentMaps.get((Object)rtype).apply(change);
        }
        return changeCount > 0;
    }

    @Override
    public TopologyInfo getChangeInfo(int startSeqNum) {
        return new TopologyInfo(this, this.getChanges(startSeqNum));
    }

    public List<TopologyChange> getChanges(int startSeqNum) {
        return this.changeTracker.getChanges(startSeqNum);
    }

    public void discardChanges(int startSeqNum) {
        this.changeTracker.discardChanges(startSeqNum);
    }

    public void persist(EntityStore estore, Transaction txn) {
        PrimaryIndex<String, TopologyHolder> ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        ti.put(txn, (Object)new TopologyHolder(this));
    }

    public static Topology fetch(EntityStore estore, Transaction txn) {
        PrimaryIndex<String, TopologyHolder> ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        TopologyHolder holder = (TopologyHolder)ti.get(txn, (Object)TopologyHolder.getKey(), LockMode.READ_UNCOMMITTED);
        return holder == null ? null : holder.getTopology();
    }

    public static Topology fetchCommitted(EntityStore estore, Transaction txn) {
        PrimaryIndex<String, TopologyHolder> ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        TopologyHolder holder = (TopologyHolder)ti.get(txn, (Object)TopologyHolder.getKey(), LockMode.READ_COMMITTED);
        return holder == null ? null : holder.getTopology();
    }

    public Datacenter add(Datacenter datacenter) {
        return this.datacenterMap.add(datacenter);
    }

    public StorageNode add(StorageNode storageNode) {
        return this.storageNodeMap.add(storageNode);
    }

    public RepGroup add(RepGroup repGroup) {
        return this.repGroupMap.add(repGroup);
    }

    public Partition add(Partition partition) {
        return this.partitionMap.add(partition);
    }

    public Partition add(Partition partition, PartitionId partitionId) {
        return this.partitionMap.add(partition, partitionId);
    }

    public Datacenter update(DatacenterId datacenterId, Datacenter datacenter) {
        return this.datacenterMap.update(datacenterId, datacenter);
    }

    public StorageNode update(StorageNodeId storageNodeId, StorageNode storageNode) {
        return this.storageNodeMap.update(storageNodeId, storageNode);
    }

    public RepGroup update(RepGroupId repGroupId, RepGroup repGroup) {
        return this.repGroupMap.update(repGroupId, repGroup);
    }

    public Partition update(PartitionId partitionId, Partition partition) {
        return this.partitionMap.update(partitionId, partition);
    }

    public Partition updatePartition(PartitionId partitionId, RepGroupId repGroupId) {
        return this.update(partitionId, new Partition(repGroupId));
    }

    public Datacenter remove(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.remove(datacenterId);
    }

    public StorageNode remove(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.remove(storageNodeId);
    }

    public RepGroup remove(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.remove(repGroupId);
    }

    public Partition remove(PartitionId partitionId) {
        return (Partition)this.partitionMap.remove(partitionId);
    }

    public RepNode remove(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        if (rg == null) {
            throw new IllegalArgumentException("Rep Group: " + repNodeId.getGroupId() + " is not in the topology");
        }
        return rg.remove(repNodeId);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.upgrade();
    }

    public boolean upgrade() throws UnknownVersionException {
        if (this.version == 1) {
            return false;
        }
        if (this.version > 1) {
            throw new UnknownVersionException("Upgrade encountered unknown version", Topology.class.getName(), 1, this.version);
        }
        if (this.getRepGroupMap().getAll().size() == 0) {
            this.version = 1;
            return true;
        }
        RepGroup protoGroup = (RepGroup)this.getRepGroupMap().getAll().iterator().next();
        HashMap<DatacenterId, Integer> protoMap = this.getRFMap(protoGroup);
        for (RepGroup repGroup : this.getRepGroupMap().getAll()) {
            HashMap<DatacenterId, Integer> rfMap = this.getRFMap(repGroup);
            if (protoMap.equals(rfMap)) continue;
            return false;
        }
        for (Map.Entry entry : protoMap.entrySet()) {
            Datacenter dc = this.get((DatacenterId)entry.getKey());
            dc.setRepFactor((Integer)entry.getValue());
        }
        this.version = 1;
        return true;
    }

    private HashMap<DatacenterId, Integer> getRFMap(RepGroup rgProto) {
        HashMap<DatacenterId, Integer> rfMap = new HashMap<DatacenterId, Integer>();
        for (RepNode rn : rgProto.getRepNodes()) {
            DatacenterId dcId = this.get(rn.getStorageNodeId()).getDatacenterId();
            Integer rf = rfMap.get(dcId);
            if (rf == null) {
                rf = 0;
            }
            rfMap.put(dcId, rf + 1);
        }
        return rfMap;
    }

    @Persistent
    public static abstract class Component<T extends ResourceId>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private Topology topology;
        private ResourceId resourceId;
        private int sequenceNumber;

        public Component() {
        }

        public abstract Component<?> clone();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
            result = 31 * result + this.sequenceNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Component other = (Component)obj;
            if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
                return false;
            }
            return this.sequenceNumber == other.sequenceNumber;
        }

        public Component<?> cloneForLog() {
            Object clone = this.clone();
            ((Component)clone).topology = null;
            return clone;
        }

        protected Component(Component<?> other) {
            this.topology = other.topology;
            this.resourceId = other.resourceId;
            this.sequenceNumber = other.sequenceNumber;
        }

        public Topology getTopology() {
            return this.topology;
        }

        public void setTopology(Topology topology) {
            assert (this.topology == null || topology == null);
            this.topology = topology;
        }

        public void setResourceId(T resourceId) {
            assert (this.resourceId == null);
            this.resourceId = resourceId;
        }

        public T getResourceId() {
            return (T)this.resourceId;
        }

        abstract ResourceId.ResourceType getResourceType();

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public StorageNodeId getStorageNodeId() {
            throw new UnsupportedOperationException("Not supported for component " + this.resourceId);
        }

        public boolean isMonitorEnabled() {
            return false;
        }
    }
}

