/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.ServerSocketFactory;

public class ClearServerSocketFactory
extends ServerSocketFactory {
    public ClearServerSocketFactory(String name, int backlog, int startPort, int endPort) {
        super(name, backlog, startPort, endPort);
    }

    public String toString() {
        return "<ClearServerSocketFactory name=" + this.name + " backlog=" + this.backlog + " port range=" + this.startPort + "," + this.endPort + ">";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ClearServerSocketFactory;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.commonCreateServerSocket(port);
    }

    @Override
    public ServerSocket prepareServerSocket() {
        return null;
    }

    @Override
    public void discardServerSocket(ServerSocket ss) {
        throw new UnsupportedOperationException("discardServerSocket is not supported by this implementation.");
    }

    public static ClearServerSocketFactory create(String name, int backlog, String portRange) {
        if (ServerSocketFactory.isDisabled()) {
            return null;
        }
        if (PortRange.isUnconstrained((String)portRange)) {
            return new ClearServerSocketFactory(name, backlog, 0, 0);
        }
        List range = PortRange.getRange((String)portRange);
        return new ClearServerSocketFactory(name, backlog, (Integer)range.get(0), (Integer)range.get(1));
    }

    @Override
    protected ServerSocket instantiateServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    @Override
    protected ServerSocket instantiateServerSocket(int port, int backlog1) throws IOException {
        return new ServerSocket(port, backlog1);
    }
}

