/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry.ssl;

import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ssl.SSLClientSocketFactory;
import oracle.kv.impl.util.registry.ssl.SSLServerSocketFactory;

public class SSLSocketPolicy
implements RMISocketPolicy {
    private SSLControl serverSSLControl;
    private SSLControl clientSSLControl;

    public SSLSocketPolicy(SSLControl serverSSLControl, SSLControl clientSSLControl) {
        this.serverSSLControl = serverSSLControl;
        this.clientSSLControl = clientSSLControl;
    }

    @Override
    public void prepareClient(String storeContext) {
        if (this.isTrusted()) {
            SSLClientSocketFactory.setTrustedControl(this.clientSSLControl);
        } else {
            SSLClientSocketFactory.setUserControl(this.clientSSLControl, storeContext);
        }
    }

    @Override
    public RMISocketPolicy.SocketFactoryPair getRegistryPair(RMISocketPolicy.SocketFactoryArgs args) {
        SSLServerSocketFactory ssf = SSLServerSocketFactory.create(this.serverSSLControl, args.getSsfName(), args.getSsfBacklog(), args.getSsfPortRange());
        ClientSocketFactory csf = null;
        return new RMISocketPolicy.SocketFactoryPair(ssf, csf);
    }

    @Override
    public ClientSocketFactory getRegistryCSF(RMISocketPolicy.SocketFactoryArgs args) {
        return new SSLClientSocketFactory(args.getCsfName(), args.getCsfConnectTimeout(), args.getCsfReadTimeout(), args.getKvStoreName());
    }

    @Override
    public RMISocketPolicy.SocketFactoryPair getBindPair(RMISocketPolicy.SocketFactoryArgs args) {
        SSLServerSocketFactory ssf = SSLServerSocketFactory.create(this.serverSSLControl, args.getSsfName(), args.getSsfBacklog(), args.getSsfPortRange());
        SSLClientSocketFactory csf = null;
        if (args.getCsfName() != null) {
            csf = this.isTrusted() ? new SSLClientSocketFactory(args.getCsfName(), args.getCsfConnectTimeout(), args.getCsfReadTimeout(), SSLClientSocketFactory.Use.TRUSTED) : new SSLClientSocketFactory(args.getCsfName(), args.getCsfConnectTimeout(), args.getCsfReadTimeout(), args.getKvStoreName());
        }
        return new RMISocketPolicy.SocketFactoryPair(ssf, csf);
    }

    @Override
    public boolean isPolicyOptional() {
        return false;
    }

    @Override
    public boolean isTrustCapable() {
        return this.isTrusted();
    }

    private boolean isTrusted() {
        return this.serverSSLControl != null && this.serverSSLControl.peerAuthenticator() != null;
    }
}

