/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:17:01_PDT_2011";
    public static final boolean TRACE = false;

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 231, 231, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 231, 231, s2, false);
        this.initForDescribe(231, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 11;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n3 = this.columnIndex + this.byteLength * n2;
        short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
        int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        this.TimeZoneAdjust(calendar, calendar2);
        n4 = calendar2.get(1);
        int n5 = calendar2.get(2) + 1;
        int n6 = calendar2.get(5);
        int n7 = calendar2.get(11);
        int n8 = calendar2.get(12);
        int n9 = calendar2.get(13);
        int n10 = 0;
        boolean bl = n7 < 12;
        String string2 = calendar2.getTimeZone().getID();
        if (string2.length() > 3 && string2.startsWith("GMT")) {
            string2 = string2.substring(3);
        }
        if (s2 == 11) {
            n10 = this.oracleNanos(n3);
        }
        return this.toText(n4, n5, n6, n7, n8, n9, n10, bl, string2);
    }

    Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    Date getDate(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n3 = this.columnIndex + this.byteLength * n2;
        int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        long l2 = this.TimeZoneAdjustUTC(calendar);
        return new Date(l2);
    }

    Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    Time getTime(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n3 = this.columnIndex + this.byteLength * n2;
        int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        long l2 = this.TimeZoneAdjustUTC(calendar);
        return new Time(l2);
    }

    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n3 = this.columnIndex + this.byteLength * n2;
        short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
        int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        long l2 = this.TimeZoneAdjustUTC(calendar);
        Timestamp timestamp = new Timestamp(l2);
        if (s2 == 11) {
            timestamp.setNanos(this.oracleNanos(n3));
        }
        return timestamp;
    }

    Object getObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            tIMESTAMPLTZ = new TIMESTAMPLTZ(byArray);
        }
        return tIMESTAMPLTZ;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            tIMESTAMPTZ = oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, byArray);
        }
        return tIMESTAMPTZ;
    }

    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    DATE getDATE(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    void TimeZoneAdjust(Calendar calendar, Calendar calendar2) throws SQLException {
        int n2;
        int n3;
        int n4;
        String string = calendar.getTimeZone().getID();
        String string2 = calendar2.getTimeZone().getID();
        if (!string2.equals(string)) {
            int n5;
            OffsetDST offsetDST = new OffsetDST();
            n4 = this.getZoneOffset(calendar, offsetDST);
            n3 = offsetDST.getOFFSET();
            calendar.add(11, -(n3 / 3600000));
            calendar.add(12, -(n3 % 3600000) / 60000);
            if (string2.equals("Custom") || string2.startsWith("GMT") && string2.length() > 3) {
                n5 = calendar2.getTimeZone().getRawOffset();
            } else {
                n2 = ZONEIDMAP.getID(string2);
                if (!ZONEIDMAP.isValidID(n2)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n2)) {
                    tIMEZONETAB.updateTable(this.statement.connection, n2);
                }
                Calendar calendar3 = this.statement.getGMTCalendar();
                calendar3.set(1, calendar.get(1));
                calendar3.set(2, calendar.get(2));
                calendar3.set(5, calendar.get(5));
                calendar3.set(11, calendar.get(11));
                calendar3.set(12, calendar.get(12));
                calendar3.set(13, calendar.get(13));
                calendar3.set(14, calendar.get(14));
                n5 = tIMEZONETAB.getOffset(calendar3, n2);
            }
            calendar.add(11, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        }
        if (string2.equals("Custom") && string.equals("Custom") || string2.startsWith("GMT") && string2.length() > 3 && string.startsWith("GMT") && string.length() > 3) {
            int n6 = calendar.getTimeZone().getRawOffset();
            n4 = calendar2.getTimeZone().getRawOffset();
            n3 = 0;
            if (n6 != n4) {
                n3 = n6 - n4;
                int n7 = n3 = n3 > 0 ? n3 : -n3;
            }
            if (n6 > n4) {
                n3 = -n3;
            }
            calendar.add(11, n3 / 3600000);
            calendar.add(12, n3 % 3600000 / 60000);
        }
        int n8 = calendar.get(1);
        n4 = calendar.get(2);
        n3 = calendar.get(5);
        n2 = calendar.get(11);
        int n9 = calendar.get(12);
        int n10 = calendar.get(13);
        int n11 = calendar.get(14);
        calendar2.set(1, n8);
        calendar2.set(2, n4);
        calendar2.set(5, n3);
        calendar2.set(11, n2);
        calendar2.set(12, n9);
        calendar2.set(13, n10);
        calendar2.set(14, n11);
    }

    long TimeZoneAdjustUTC(Calendar calendar) throws SQLException {
        int n2;
        int n3;
        int n4;
        String string = calendar.getTimeZone().getID();
        if (string.equals("Custom") || string.startsWith("GMT") && string.length() > 3) {
            n4 = calendar.getTimeZone().getRawOffset();
            calendar.add(11, -(n4 / 3600000));
            calendar.add(12, -(n4 % 3600000) / 60000);
        } else if (!string.equals("GMT") && !string.equals("UTC")) {
            OffsetDST offsetDST = new OffsetDST();
            n3 = this.getZoneOffset(calendar, offsetDST);
            n2 = offsetDST.getOFFSET();
            calendar.add(11, -(n2 / 3600000));
            calendar.add(12, -(n2 % 3600000) / 60000);
        }
        n4 = calendar.get(1);
        n3 = calendar.get(2);
        n2 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = calendar.get(14);
        Calendar calendar2 = this.statement.getGMTCalendar();
        calendar2.set(1, n4);
        calendar2.set(2, n3);
        calendar2.set(5, n2);
        calendar2.set(11, n5);
        calendar2.set(12, n6);
        calendar2.set(13, n7);
        calendar2.set(14, n8);
        long l2 = calendar2.getTimeInMillis();
        return l2;
    }

    byte getZoneOffset(Calendar calendar, OffsetDST offsetDST) throws SQLException {
        byte by = 0;
        String string = calendar.getTimeZone().getID();
        if (string == "Custom" || string.startsWith("GMT") && string.length() > 3) {
            offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
        } else {
            int n2 = ZONEIDMAP.getID(string);
            if (!ZONEIDMAP.isValidID(n2)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
            if (tIMEZONETAB.checkID(n2)) {
                tIMEZONETAB.updateTable(this.statement.connection, n2);
            }
            by = tIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
        }
        return by;
    }
}

