/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestore;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FrozenFieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class FieldTypeStore {
    private static final AtomicReferenceFieldUpdater<FieldTypeStore, FieldFilterTypeFlow> FILTER_FLOW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldTypeStore.class, FieldFilterTypeFlow.class, "filterFlow");
    private static final AtomicReferenceFieldUpdater<FieldTypeStore, FrozenFieldFilterTypeFlow> FROZEN_FILTER_FLOW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldTypeStore.class, FrozenFieldFilterTypeFlow.class, "frozenFilterFlow");
    private static final AtomicReferenceFieldUpdater<FieldTypeStore, UnsafeWriteSinkTypeFlow> UNSAFE_WRITE_SINK_FLOW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldTypeStore.class, UnsafeWriteSinkTypeFlow.class, "unsafeWriteSinkFlow");
    protected final AnalysisObject object;
    protected final AnalysisField field;
    private volatile FieldFilterTypeFlow filterFlow;
    private volatile FrozenFieldFilterTypeFlow frozenFilterFlow;
    private volatile UnsafeWriteSinkTypeFlow unsafeWriteSinkFlow;

    public FieldTypeStore(AnalysisField field, AnalysisObject object) {
        this.field = field;
        this.object = object;
    }

    public AnalysisObject object() {
        return this.object;
    }

    public AnalysisField field() {
        return this.field;
    }

    public abstract FieldTypeFlow writeFlow();

    public abstract FieldTypeFlow readFlow();

    public FieldFilterTypeFlow filterFlow(BigBang bb) {
        assert (this.field.isUnsafeAccessed()) : "Filter flow requested for non unsafe accessed field.";
        if (this.filterFlow == null && FILTER_FLOW_UPDATER.compareAndSet(this, null, new FieldFilterTypeFlow(this.field))) {
            this.filterFlow.addUse(bb, this.writeFlow());
        }
        return this.filterFlow;
    }

    public void init(BigBang bb) {
    }

    public UnsafeWriteSinkTypeFlow unsafeWriteSinkFlow(BigBang bb) {
        assert (this.field.hasUnsafeFrozenTypeState()) : "Unsafe write sink flow requested for non unsafe accessed frozen field.";
        if (this.unsafeWriteSinkFlow == null) {
            UNSAFE_WRITE_SINK_FLOW_UPDATER.compareAndSet(this, null, new UnsafeWriteSinkTypeFlow(bb, this.field));
        }
        if (this.frozenFilterFlow == null && FROZEN_FILTER_FLOW_UPDATER.compareAndSet(this, null, new FrozenFieldFilterTypeFlow(bb, this.field, this.unsafeWriteSinkFlow))) {
            this.frozenFilterFlow.addUse(bb, this.writeFlow());
            this.unsafeWriteSinkFlow.addUse(bb, this.frozenFilterFlow);
        }
        return this.unsafeWriteSinkFlow;
    }
}

