/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import oracle.toplink.essentials.internal.helper.TOPComparison;

public class TOPSort {
    public static void quicksort(Object[] arrayToSort, int left, int right, TOPComparison compareOperator) {
        if (left >= right) {
            return;
        }
        TOPSort.swapElements(arrayToSort, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (compareOperator.compare(arrayToSort[i], arrayToSort[left]) >= 0) continue;
            TOPSort.swapElements(arrayToSort, ++last, i);
        }
        TOPSort.swapElements(arrayToSort, left, last);
        TOPSort.quicksort(arrayToSort, left, last - 1, compareOperator);
        TOPSort.quicksort(arrayToSort, last + 1, right, compareOperator);
    }

    public static void quicksort(Object[] arrayToSort, TOPComparison compareOperator) {
        TOPSort.quicksort(arrayToSort, 0, arrayToSort.length - 1, compareOperator);
    }

    protected static void swapElements(Object[] arrayToSort, int index1, int index2) {
        Object tempIndex = arrayToSort[index1];
        arrayToSort[index1] = arrayToSort[index2];
        arrayToSort[index2] = tempIndex;
    }
}

