/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;

public class DeleteObjectQuery
extends ObjectLevelModifyQuery {
    public DeleteObjectQuery() {
    }

    public DeleteObjectQuery(Object objectToDelete) {
        this();
        this.setObject(objectToDelete);
    }

    public DeleteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasDeleteQuery()) {
            return queryManager.getDeleteQuery();
        }
        return null;
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        Object result = unitOfWork.processDeleteObjectQuery(this);
        if (result != null) {
            return result;
        }
        return super.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, translationRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        try {
            int rowCount;
            if (this.getSession().getCommitManager().isCommitCompleted(this.getObject()) || this.getSession().getCommitManager().isCommitInPostModify(this.getObject()) || this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
                return this.object;
            }
            this.getSession().getCommitManager().markPreModifyCommitInProgress(this.getObject());
            this.getSession().beginTransaction();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(2, this));
            }
            if (this.shouldCascadeParts()) {
                this.getDescriptor().getQueryManager().preDelete(this);
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(14, this);
                event.setRecord(this.getModifyRow());
                this.getDescriptor().getEventManager().executeEvent(event);
            }
            if ((rowCount = this.getQueryMechanism().deleteObject().intValue()) < 1) {
                this.getSession().getEventManager().noRowsModified(this, this.object);
            }
            if (this.getDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().getOptimisticLockingPolicy().validateDelete(rowCount, this.object, this);
            }
            this.getSession().getCommitManager().markPostModifyCommitInProgress(this.getObject());
            if (this.shouldCascadeParts()) {
                this.getDescriptor().getQueryManager().postDelete(this);
            }
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(3, this));
            }
            this.getSession().commitTransaction();
            this.getSession().getCommitManager().markCommitCompleted(this.getObject());
            if (this.shouldMaintainCache()) {
                if (this.getSession().isUnitOfWork()) {
                    ((UnitOfWorkImpl)this.getSession()).addObjectDeletedDuringCommit(this.getObject(), this.getDescriptor());
                } else {
                    this.session.getIdentityMapAccessorInstance().removeFromIdentityMap(this.getPrimaryKey(), this.getDescriptor().getJavaClass(), this.getDescriptor());
                }
            }
            return this.getObject();
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            this.getSession().getCommitManager().markCommitCompleted(this.getObject());
            throw exception;
        }
    }

    public boolean isDeleteObjectQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareDeleteObject();
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        DeleteObjectQuery customDeleteQuery = (DeleteObjectQuery)customQuery;
        customDeleteQuery.setObject(this.getObject());
        customDeleteQuery.setObjectChangeSet(this.getObjectChangeSet());
        customDeleteQuery.setCascadePolicy(this.getCascadePolicy());
        customDeleteQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customDeleteQuery.setTranslationRow(customDeleteQuery.getDescriptor().getObjectBuilder().buildRow(this.getObject(), customDeleteQuery.getSession()));
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockValuesToTranslationRow(this);
        }
    }
}

