/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import com.orangesignal.csv.bean.AbstractCsvBeanTemplate;
import com.orangesignal.csv.bean.CsvColumnNameMappingBeanOperation;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsvColumnNameMappingBeanTemplate<T>
extends AbstractCsvBeanTemplate<T, CsvColumnNameMappingBeanTemplate<T>>
implements CsvColumnNameMappingBeanOperation<CsvColumnNameMappingBeanTemplate<T>> {
    private Map<String, String> columnMapping = new LinkedHashMap<String, String>();
    private CsvNamedValueFilter filter;

    public static <T> CsvColumnNameMappingBeanTemplate<T> newInstance(Class<T> type) {
        return new CsvColumnNameMappingBeanTemplate<T>(type);
    }

    public CsvColumnNameMappingBeanTemplate(Class<T> type) {
        super(type);
    }

    @Override
    public CsvColumnNameMappingBeanTemplate<T> column(String column, String field) {
        return this.column(column, field, null);
    }

    @Override
    public CsvColumnNameMappingBeanTemplate<T> column(String column, String field, Format format) {
        this.columnMapping.put(column, field);
        if (format != null) {
            this.setValueParser(field, format);
            this.setValueFormatter(column, format);
        }
        return this;
    }

    @Override
    public void setColumnMapping(Map<String, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.columnMapping = new LinkedHashMap<String, String>(columnMapping);
    }

    @Override
    public CsvColumnNameMappingBeanTemplate<T> columnMapping(Map<String, String> columnMapping) {
        this.setColumnMapping(columnMapping);
        return this;
    }

    @Override
    public CsvColumnNameMappingBeanTemplate<T> filter(CsvNamedValueFilter filter) {
        this.filter = filter;
        return this;
    }

    public void setupColumnMappingIfNeed() {
        if (this.columnMapping.size() == 0) {
            for (Field f : this.getType().getDeclaredFields()) {
                String name = f.getName();
                this.column(name, name);
            }
        }
    }

    public boolean isAccept(List<String> columnNames, List<String> values) {
        return this.filter != null && !this.filter.accept(columnNames, values);
    }

    public Map<String, Object[]> createFieldAndColumnsMap() {
        return super.createFieldAndColumnsMap(this.columnMapping);
    }

    public List<String> createColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.columnMapping.entrySet()) {
            columnNames.add(entry.getKey());
        }
        return columnNames;
    }

    public String getFieldName(String columnName) {
        return this.columnMapping.get(columnName);
    }
}

