/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import java.io.IOException;
import java.lang.reflect.Field;

public abstract class FieldUtils {
    protected FieldUtils() {
    }

    public static final Field getField(Class<?> type, String name) throws IOException {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Field " + name + " not found in " + type.getName() + ": " + e.getMessage(), e);
        }
    }

    public static final void setFieldValue(Object bean, Field field, Object value) throws IOException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot set " + field.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot set " + field.getName() + ": " + e.getMessage(), e);
        }
    }

    public static final Object getFieldValue(Object bean, Field field) throws IOException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot get " + field.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot get " + field.getName() + ": " + e.getMessage(), e);
        }
    }
}

