/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import com.orangesignal.csv.bean.CsvValueConverter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SimpleCsvValueConverter
implements CsvValueConverter {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS;
    private static final Map<String, Boolean> BOOLEAN_DEFAULTS;
    private DateFormat dateFormat;

    private static void putBooleanMap(Map<String, Boolean> map, String falseValue, String trueValue) {
        map.put(falseValue, Boolean.FALSE);
        map.put(trueValue, Boolean.TRUE);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Object convert(String str, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (str == null) {
            if (type.isPrimitive()) {
                return PRIMITIVE_DEFAULTS.get(type);
            }
            return null;
        }
        if (type.equals(String.class)) {
            return str;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            for (Map.Entry<String, Boolean> entry : BOOLEAN_DEFAULTS.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(str)) continue;
                return entry.getValue();
            }
        } else {
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return Byte.valueOf(str);
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return Short.valueOf(str);
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Integer.valueOf(str);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return Long.valueOf(str);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(str);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Double.valueOf(str);
            }
            if (type.equals(BigInteger.class)) {
                return new BigInteger(str);
            }
            if (type.equals(Number.class) || type.equals(BigDecimal.class)) {
                return new BigDecimal(str);
            }
            if (this.dateFormat != null && Date.class.isAssignableFrom(type)) {
                try {
                    return type.getConstructor(Long.TYPE).newInstance(this.dateFormat.parse(str).getTime());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
            if (Enum.class.isAssignableFrom(type)) {
                try {
                    return type.getMethod("valueOf", String.class).invoke(null, str);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(String.format("Unknown convert type %s", type.getName()), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(String.format("Unknown convert type %s", type.getName()), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(String.format("Unknown convert type %s", type.getName()), e);
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unknown convert type %s", type.getName()));
    }

    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date && this.dateFormat != null) {
            return this.dateFormat.format(value);
        }
        return value.toString();
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> primitiveMap = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        primitiveMap.put(Boolean.TYPE, Boolean.FALSE);
        primitiveMap.put(Byte.TYPE, Byte.valueOf((byte)0));
        primitiveMap.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveMap.put(Short.TYPE, Short.valueOf((short)0));
        primitiveMap.put(Integer.TYPE, Integer.valueOf(0));
        primitiveMap.put(Long.TYPE, Long.valueOf(0L));
        primitiveMap.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveMap.put(Double.TYPE, Double.valueOf(0.0));
        PRIMITIVE_DEFAULTS = Collections.unmodifiableMap(primitiveMap);
        HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "0", "1");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "false", "true");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "f", "t");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "no", "yes");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "n", "y");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "off", "on");
        SimpleCsvValueConverter.putBooleanMap(booleanMap, "x", "o");
        BOOLEAN_DEFAULTS = Collections.unmodifiableMap(booleanMap);
    }
}

