/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.filters;

import com.orangesignal.csv.filters.BeanExpression;
import com.orangesignal.csv.filters.BeanExpressionUtils;
import java.io.IOException;
import java.util.Comparator;

public class BeanBetweenExpression
extends BeanExpression {
    private Object low;
    private Object high;
    private Comparator comparator;

    protected BeanBetweenExpression(String name, Object low, Object high) {
        this(name, low, high, null);
    }

    protected BeanBetweenExpression(String name, Object low, Object high, Comparator comparator) {
        super(name);
        if (low == null || high == null) {
            throw new IllegalArgumentException("Low or High must not be null");
        }
        this.low = low;
        this.high = high;
        this.comparator = comparator;
    }

    @Override
    public boolean accept(Object bean) throws IOException {
        return BeanExpressionUtils.between(bean, this.name, this.low, this.high, this.comparator);
    }
}

