/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.bean.AbstractCsvBeanTemplate;
import com.orangesignal.csv.bean.CsvValueConverter;
import com.orangesignal.csv.filters.BeanFilter;
import com.orangesignal.csv.handlers.AbstractCsvListHandler;
import com.orangesignal.csv.handlers.BeanOrder;
import com.orangesignal.csv.handlers.BeanOrderComparator;
import java.text.Format;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractBeanListHandler<T, O extends AbstractCsvBeanTemplate<T, O>, H extends AbstractBeanListHandler<T, O, H>>
extends AbstractCsvListHandler<T, H> {
    protected final O template;
    protected BeanFilter beanFilter;
    protected List<BeanOrder> orders;

    protected AbstractBeanListHandler(O template) {
        if (template == null) {
            throw new IllegalArgumentException("AbstractCsvBeanTemplate must not be null");
        }
        this.template = template;
    }

    @Override
    public List<T> processScalar(List<T> beans) {
        if (this.orders != null) {
            BeanOrderComparator.sort(beans, this.orders);
        }
        return super.processScalar(beans);
    }

    public Class<T> getType() {
        return ((AbstractCsvBeanTemplate)this.template).getType();
    }

    public void setValueParserMapping(Map<String, Format> valueParserMapping) {
        ((AbstractCsvBeanTemplate)this.template).setValueParserMapping(valueParserMapping);
    }

    public H valueParserMapping(Map<String, Format> valueParserMapping) {
        this.setValueParserMapping(valueParserMapping);
        return (H)this;
    }

    public void setValueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        ((AbstractCsvBeanTemplate)this.template).setValueFormatterMapping(valueFormatterMapping);
    }

    public H valueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        this.setValueFormatterMapping(valueFormatterMapping);
        return (H)this;
    }

    public void setValueConverter(CsvValueConverter valueConverter) {
        ((AbstractCsvBeanTemplate)this.template).setValueConverter(valueConverter);
    }

    public H valueConverter(CsvValueConverter valueConverter) {
        this.setValueConverter(valueConverter);
        return (H)this;
    }

    public H filter(BeanFilter beanFilter) {
        this.beanFilter = beanFilter;
        return (H)this;
    }

    public void setOrder(List<BeanOrder> orders) {
        this.orders = orders;
    }

    public H order(BeanOrder ... orders) {
        this.setOrder(orders != null ? Arrays.asList(orders) : null);
        return (H)this;
    }
}

