/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.bean.CsvBeanOperation;
import com.orangesignal.csv.bean.CsvBeanTemplate;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import com.orangesignal.csv.handlers.AbstractBeanListHandler;
import com.orangesignal.csv.io.CsvBeanReader;
import com.orangesignal.csv.io.CsvBeanWriter;
import java.io.IOException;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class BeanListHandler<T>
extends AbstractBeanListHandler<T, CsvBeanTemplate<T>, BeanListHandler<T>>
implements CsvBeanOperation<BeanListHandler<T>> {
    private boolean header = true;

    public BeanListHandler(Class<T> type) {
        super(CsvBeanTemplate.newInstance(type));
    }

    @Override
    public BeanListHandler<T> includes(String ... names) {
        ((CsvBeanTemplate)this.template).includes(names);
        return this;
    }

    @Override
    public BeanListHandler<T> excludes(String ... names) {
        ((CsvBeanTemplate)this.template).excludes(names);
        return this;
    }

    public BeanListHandler<T> format(String name, Format format) {
        ((CsvBeanTemplate)this.template).format(name, format);
        return this;
    }

    @Override
    public BeanListHandler<T> filter(CsvNamedValueFilter filter) {
        ((CsvBeanTemplate)this.template).filter(filter);
        return this;
    }

    public BeanListHandler<T> header(boolean header) {
        this.header = header;
        return this;
    }

    @Override
    public List<T> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        CsvBeanReader r = new CsvBeanReader(reader, (CsvBeanTemplate)this.template);
        ArrayList results = new ArrayList();
        boolean order = ignoreScalar || this.orders != null && !this.orders.isEmpty();
        int offset = 0;
        while ((values = r.readValues()) != null && (order || this.limit <= 0 || results.size() < this.limit)) {
            if (this.beanFilter == null && !order && offset < this.offset) {
                ++offset;
                continue;
            }
            Object bean = r.toBean(values);
            if (this.beanFilter != null) {
                if (!this.beanFilter.accept(bean)) continue;
                if (!order && offset < this.offset) {
                    ++offset;
                    continue;
                }
            }
            results.add(bean);
        }
        if (ignoreScalar || !order) {
            return results;
        }
        return this.processScalar(results);
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        CsvBeanWriter<T> w = new CsvBeanWriter<T>(writer, (CsvBeanTemplate)this.template, this.header);
        for (T bean : list) {
            if (bean == null) {
                w.write(null);
                continue;
            }
            if (this.beanFilter != null && !this.beanFilter.accept(bean)) continue;
            w.write(bean);
        }
    }
}

