/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import com.orangesignal.csv.handlers.AbstractCsvListHandler;
import com.orangesignal.csv.io.CsvColumnNameMapReader;
import com.orangesignal.csv.io.CsvColumnNameMapWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ColumnNameMapListHandler
extends AbstractCsvListHandler<Map<String, String>, ColumnNameMapListHandler> {
    private List<String> columnNames;
    private boolean header = true;
    private CsvNamedValueFilter valueFilter;

    public ColumnNameMapListHandler addColumn(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnName);
        return this;
    }

    public ColumnNameMapListHandler columnNames(Collection<String> columnNames) {
        this.columnNames = new ArrayList<String>(columnNames);
        return this;
    }

    public ColumnNameMapListHandler filter(CsvNamedValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    public ColumnNameMapListHandler header(boolean header) {
        this.header = header;
        return this;
    }

    @Override
    public List<Map<String, String>> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        CsvColumnNameMapReader r = new CsvColumnNameMapReader(reader, this.columnNames);
        r.setFilter(this.valueFilter);
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        int offset = 0;
        while ((values = r.readValues()) != null && (ignoreScalar || this.limit <= 0 || results.size() < this.limit)) {
            if (!ignoreScalar && offset < this.offset) {
                ++offset;
                continue;
            }
            results.add(r.toMap(values));
        }
        return results;
    }

    @Override
    public void save(List<Map<String, String>> list, CsvWriter writer) throws IOException {
        CsvColumnNameMapWriter w = new CsvColumnNameMapWriter(writer, this.columnNames, this.header);
        w.setFilter(this.valueFilter);
        for (Map<String, String> map : list) {
            w.write(map);
        }
    }
}

