/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.filters.CsvValueFilter;
import com.orangesignal.csv.handlers.AbstractCsvListHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArrayListHandler
extends AbstractCsvListHandler<String[], StringArrayListHandler> {
    private CsvValueFilter valueFilter;

    public StringArrayListHandler filter(CsvValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    @Override
    public List<String[]> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        ArrayList<String[]> results = new ArrayList<String[]>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (ignoreScalar || this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(values)) continue;
            if (!ignoreScalar && offset < this.offset) {
                ++offset;
                continue;
            }
            results.add(values.toArray(new String[0]));
        }
        return results;
    }

    @Override
    public void save(List<String[]> list, CsvWriter writer) throws IOException {
        for (String[] values : list) {
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(_values)) continue;
            writer.writeValues(_values);
        }
    }
}

