/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.bean.CsvBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CsvBeanWriter<T>
implements Closeable,
Flushable {
    private CsvWriter writer;
    private final CsvBeanTemplate<T> template;
    private final boolean header;
    private List<String> columnNames;

    public static <T> CsvBeanWriter<T> newInstance(CsvWriter writer, Class<T> type) {
        return new CsvBeanWriter<T>(writer, type);
    }

    public static <T> CsvBeanWriter<T> newInstance(CsvWriter writer, Class<T> type, boolean header) {
        return new CsvBeanWriter<T>(writer, type, header);
    }

    public static <T> CsvBeanWriter<T> newInstance(CsvWriter writer, CsvBeanTemplate<T> template) {
        return new CsvBeanWriter<T>(writer, template);
    }

    public static <T> CsvBeanWriter<T> newInstance(CsvWriter writer, CsvBeanTemplate<T> template, boolean header) {
        return new CsvBeanWriter<T>(writer, template, header);
    }

    public CsvBeanWriter(CsvWriter writer, Class<T> type) {
        this(writer, new CsvBeanTemplate<T>(type), true);
    }

    public CsvBeanWriter(CsvWriter writer, Class<T> type, boolean header) {
        this(writer, new CsvBeanTemplate<T>(type), header);
    }

    public CsvBeanWriter(CsvWriter writer, CsvBeanTemplate<T> template) {
        this(writer, template, true);
    }

    public CsvBeanWriter(CsvWriter writer, CsvBeanTemplate<T> template, boolean header) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvBeanTemplate must not be null");
        }
        this.writer = writer;
        this.template = template;
        this.header = header;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvBeanWriter csvBeanWriter = this;
        synchronized (csvBeanWriter) {
            if (this.columnNames == null) {
                ArrayList<String> names = new ArrayList<String>();
                for (Field f : this.template.getType().getDeclaredFields()) {
                    String name = f.getName();
                    if (!this.template.isTargetName(name)) continue;
                    names.add(name);
                }
                if (this.header) {
                    this.writer.writeValues(names);
                }
                this.columnNames = Collections.unmodifiableList(names);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvBeanWriter csvBeanWriter = this;
        synchronized (csvBeanWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvBeanWriter csvBeanWriter = this;
        synchronized (csvBeanWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
            this.columnNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader() throws IOException {
        CsvBeanWriter csvBeanWriter = this;
        synchronized (csvBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(T bean) throws IOException {
        CsvBeanWriter csvBeanWriter = this;
        synchronized (csvBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
            if (bean == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.toValues(bean);
            if (this.template.isAccept(this.columnNames, values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> toValues(T bean) throws IOException {
        int columnCount = this.columnNames.size();
        String[] values = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String name = this.columnNames.get(i);
            if (name == null) continue;
            Field f = FieldUtils.getField(bean.getClass(), name);
            values[i] = this.template.objectToString(name, FieldUtils.getFieldValue(bean, f));
        }
        return Arrays.asList(values);
    }

    public CsvBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

