/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CsvColumnNameMapWriter
implements Closeable,
Flushable {
    private CsvWriter writer;
    private List<String> columnNames;
    private final boolean header;
    private int columnCount = -1;
    private CsvNamedValueFilter filter;

    public CsvColumnNameMapWriter(CsvWriter writer) {
        this(writer, null, true);
    }

    public CsvColumnNameMapWriter(CsvWriter writer, boolean header) {
        this(writer, null, header);
    }

    public CsvColumnNameMapWriter(CsvWriter writer, List<String> columnNames) {
        this(writer, columnNames, true);
    }

    public CsvColumnNameMapWriter(CsvWriter writer, List<String> columnNames, boolean header) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        this.writer = writer;
        if (columnNames != null) {
            this.columnNames = Collections.unmodifiableList(columnNames);
        }
        this.header = header;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    private void ensureHeader(Map<String, String> map) throws IOException {
        if (this.columnNames == null && map != null) {
            this.columnNames = new ArrayList<String>(map.keySet());
        }
        if (this.columnNames == null) {
            throw new IOException("No header is available");
        }
        if (this.columnCount == -1) {
            if (this.header) {
                this.writer.writeValues(this.columnNames);
            }
            this.columnCount = this.columnNames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvColumnNameMapWriter csvColumnNameMapWriter = this;
        synchronized (csvColumnNameMapWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnNameMapWriter csvColumnNameMapWriter = this;
        synchronized (csvColumnNameMapWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
            this.columnNames = null;
            this.columnCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader(Map<String, String> map) throws IOException {
        CsvColumnNameMapWriter csvColumnNameMapWriter = this;
        synchronized (csvColumnNameMapWriter) {
            this.ensureOpen();
            this.ensureHeader(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Map<String, String> map) throws IOException {
        CsvColumnNameMapWriter csvColumnNameMapWriter = this;
        synchronized (csvColumnNameMapWriter) {
            this.ensureOpen();
            this.ensureHeader(map);
            if (map == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.toValues(map);
            if (this.filter != null && !this.filter.accept(this.columnNames, values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> toValues(Map<String, String> map) {
        String[] values = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            values[i] = map.get(this.columnNames.get(i));
        }
        return Arrays.asList(values);
    }

    public CsvNamedValueFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(CsvNamedValueFilter filter) {
        CsvColumnNameMapWriter csvColumnNameMapWriter = this;
        synchronized (csvColumnNameMapWriter) {
            this.filter = filter;
        }
    }
}

