/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.filters.CsvValueFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class CsvColumnPositionMapReader
implements Closeable {
    private CsvReader reader;
    private CsvValueFilter filter;

    public CsvColumnPositionMapReader(CsvReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        this.reader = reader;
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnPositionMapReader csvColumnPositionMapReader = this;
        synchronized (csvColumnPositionMapReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, String> read() throws IOException {
        CsvColumnPositionMapReader csvColumnPositionMapReader = this;
        synchronized (csvColumnPositionMapReader) {
            this.ensureOpen();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvColumnPositionMapReader csvColumnPositionMapReader = this;
        synchronized (csvColumnPositionMapReader) {
            this.ensureOpen();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, String> toMap(List<String> values) throws IOException {
        CsvColumnPositionMapReader csvColumnPositionMapReader = this;
        synchronized (csvColumnPositionMapReader) {
            this.ensureOpen();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.filter != null && !this.filter.accept(values)) continue;
            return values;
        }
        return null;
    }

    private SortedMap<Integer, String> convert(List<String> values) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int len = values.size();
        for (int pos = 0; pos < len; ++pos) {
            map.put(pos, values.get(pos));
        }
        return map;
    }

    public CsvValueFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(CsvValueFilter filter) {
        CsvColumnPositionMapReader csvColumnPositionMapReader = this;
        synchronized (csvColumnPositionMapReader) {
            this.filter = filter;
        }
    }
}

