/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.filters.CsvValueFilter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CsvColumnPositionMapWriter
implements Closeable,
Flushable {
    private CsvWriter writer;
    private CsvValueFilter filter;

    public CsvColumnPositionMapWriter(CsvWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        this.writer = writer;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvColumnPositionMapWriter csvColumnPositionMapWriter = this;
        synchronized (csvColumnPositionMapWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnPositionMapWriter csvColumnPositionMapWriter = this;
        synchronized (csvColumnPositionMapWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Map<Integer, String> map) throws IOException {
        CsvColumnPositionMapWriter csvColumnPositionMapWriter = this;
        synchronized (csvColumnPositionMapWriter) {
            this.ensureOpen();
            if (map == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.convert(map);
            if (this.filter != null && !this.filter.accept(values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> convert(Map<Integer, String> map) {
        String[] values = new String[CsvColumnPositionMapWriter.getMaxColumnPosition(map) + 1];
        for (Map.Entry<Integer, String> e : map.entrySet()) {
            int pos = e.getKey();
            if (pos < 0) continue;
            values[pos] = e.getValue();
        }
        return Arrays.asList(values);
    }

    private static int getMaxColumnPosition(Map<Integer, String> map) {
        TreeMap<Integer, String> sortedMap = map instanceof SortedMap ? (TreeMap<Integer, String>)map : new TreeMap<Integer, String>(map);
        return Math.max((Integer)sortedMap.lastKey(), 0);
    }

    public CsvValueFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(CsvValueFilter filter) {
        CsvColumnPositionMapWriter csvColumnPositionMapWriter = this;
        synchronized (csvColumnPositionMapWriter) {
            this.filter = filter;
        }
    }
}

