/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.manager;

import com.orangesignal.csv.Csv;
import com.orangesignal.csv.CsvConfig;
import com.orangesignal.csv.CsvListHandler;
import com.orangesignal.csv.manager.CsvSaver;
import com.orangesignal.jlha.LhaOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipOutputStream;

public abstract class AbstractCsvSaver<T, H extends CsvListHandler<T>>
implements CsvSaver<T> {
    private final CsvConfig cfg;
    private final List<T> beans;

    protected AbstractCsvSaver(CsvConfig cfg, List<T> beans) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        this.cfg = cfg;
        this.beans = beans;
    }

    protected abstract H getCsvListHandler();

    @Override
    public void to(Writer writer) throws IOException {
        Csv.save(this.beans, writer, this.cfg, this.getCsvListHandler());
    }

    @Override
    public void to(OutputStream out, String encoding) throws IOException {
        Csv.save(this.beans, out, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public void to(OutputStream out) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.getCsvListHandler());
    }

    @Override
    public void to(File file, String encoding) throws IOException {
        Csv.save(this.beans, file, encoding, this.cfg, this.getCsvListHandler());
    }

    @Override
    public void to(File file) throws IOException {
        Csv.save(this.beans, file, this.cfg, this.getCsvListHandler());
    }

    @Override
    public void to(LhaOutputStream out, String encoding, String entryName) throws IOException {
        Csv.save(this.beans, out, encoding, this.cfg, this.getCsvListHandler(), entryName);
    }

    @Override
    public void to(LhaOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.getCsvListHandler(), entryName);
    }

    @Override
    public void to(ZipOutputStream out, String encoding, String entryName) throws IOException {
        Csv.save(this.beans, out, encoding, this.cfg, this.getCsvListHandler(), entryName);
    }

    @Override
    public void to(ZipOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.getCsvListHandler(), entryName);
    }
}

