/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Disconnectable;
import java.io.IOException;
import java.io.InputStream;

public class DisconnectableInputStream
extends InputStream
implements Disconnectable {
    private InputStream in;

    public DisconnectableInputStream(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.in.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        if (0 < length) {
            return this.in.read(buffer, index, length);
        }
        return 0;
    }

    @Override
    public long skip(long length) throws IOException {
        if (0L < length) {
            return this.in.skip(length);
        }
        return 0L;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupprted() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public void disconnect() {
        this.in = null;
    }
}

