/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.CRC16;
import com.orangesignal.jlha.LhaChecksum;
import com.orangesignal.jlha.LhaProperty;
import com.orangesignal.jlha.LittleEndian;
import com.orangesignal.jlha.MsdosDate;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LhaHeader
implements Cloneable {
    public static final int UNKNOWN = -1;
    public static final int NO_CRC = -2;
    private long originalSize = -1L;
    private Date lastModified = null;
    private String path = "";
    private int crc = -1;
    private String method = "-lh5-";
    private long compressedSize = -1L;
    private int headerLevel = 2;
    private byte osid = (byte)74;
    private static final int HEADER_LEVEL_INDEX = 20;
    private byte[] extraData = null;
    private byte level0DosAttribute = (byte)32;
    private Vector<byte[]> extraExtHeaders = null;

    private LhaHeader() {
    }

    public LhaHeader(String path) {
        this(path, new Date(System.currentTimeMillis()));
    }

    public LhaHeader(String path, Date date) {
        this();
        if (path != null && !path.equals("") && date != null) {
            if (path.endsWith(File.separator)) {
                this.method = "-lhd-";
            }
        } else {
            if (path == null) {
                throw new NullPointerException("path");
            }
            if (path.equals("")) {
                throw new IllegalArgumentException("path must not be empty.");
            }
            throw new NullPointerException("date");
        }
        this.path = path;
        this.lastModified = date;
    }

    public LhaHeader(byte[] HeaderData) {
        this();
        if (HeaderData != null) {
            try {
                this.importHeader(HeaderData, LhaProperty.ENCODING);
            }
            catch (UnsupportedEncodingException exception) {
                throw new Error("Java Runtime Environment not support " + LhaProperty.ENCODING + " encoding");
            }
        } else {
            throw new NullPointerException("HeaderData");
        }
    }

    public LhaHeader(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        this();
        if (HeaderData == null || encode == null) {
            if (HeaderData == null) {
                throw new NullPointerException("HeaderData");
            }
            throw new NullPointerException("encode");
        }
        this.importHeader(HeaderData, encode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new Error("java.lang.Object is not support clone().");
        }
    }

    public String getCompressMethod() {
        return this.method;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public Date getLastModified() {
        return new Date(this.lastModified.getTime());
    }

    public int getHeaderLevel() {
        return this.headerLevel;
    }

    public String getPath() {
        return this.path;
    }

    public int getCrc() {
        return this.crc;
    }

    public byte getOsid() {
        return this.osid;
    }

    protected byte[] getExtraData() {
        return (byte[])this.extraData.clone();
    }

    protected byte getLevel0DosAttribute() {
        return this.level0DosAttribute;
    }

    private String getFileName() {
        return this.path.substring(this.path.lastIndexOf(File.separatorChar) + 1);
    }

    private String getDirName() {
        return this.path.substring(0, this.path.lastIndexOf(File.separatorChar) + 1);
    }

    public byte[] getBytes() {
        try {
            return this.exportHeader(LhaProperty.ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            throw new Error("Java Runtime Environment not support " + LhaProperty.ENCODING + " encoding");
        }
    }

    public byte[] getBytes(String encode) throws UnsupportedEncodingException {
        return this.exportHeader(encode);
    }

    public void setCompressMethod(String method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        if (!method.startsWith("-") || !method.endsWith("-")) {
            throw new IllegalArgumentException("method must starts with '-' and ends with '-'");
        }
        this.method = method;
    }

    public void setOriginalSize(long size) {
        if (size == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.originalSize = size;
    }

    public void setCompressedSize(long size) {
        if (size == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.compressedSize = size;
    }

    public void setLastModified(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.lastModified = date;
    }

    public void setHeaderLevel(int level) {
        this.headerLevel = level;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.equals("")) {
            throw new IllegalArgumentException("path must not empty.");
        }
        this.path = path;
    }

    public void setCrc(int crc) {
        if (crc == -1) {
            throw new IllegalArgumentException("crc must not LhaHeader.UNKNOWN( -1 )");
        }
        this.crc = crc;
    }

    public void setOsid(byte id) {
        this.osid = id;
    }

    protected void setExtraData(byte[] data) {
        this.extraData = data;
    }

    protected void setLevel0DosAttribute(byte attribute) {
        this.level0DosAttribute = attribute;
    }

    private void setFileName(String filename) {
        this.path = this.getDirName() + filename;
    }

    private void setDirName(String dirname) {
        this.path = dirname + this.getFileName();
    }

    private void importLevel0Header(byte[] headerData, String encode) throws UnsupportedEncodingException {
        boolean headerSizeIndex = false;
        int headerSize = (headerData[0] & 0xFF) + 2;
        int compressMethodIndex = 2;
        int compressedSizeIndex = 7;
        int originalSizeIndex = 11;
        int lastModifiedIndex = 15;
        int dosAttributeIndex = 19;
        int pathLengthIndex = 21;
        int pathLength = headerData[21] & 0xFF;
        int pathIndex = 22;
        int crcIndex = 22 + pathLength;
        int extraDataIndex = 24 + pathLength;
        int extraDataLength = headerSize - extraDataIndex;
        this.method = new String(headerData, 2, 5, encode);
        this.compressedSize = (long)LittleEndian.readInt(headerData, 7) & 0xFFFFFFFFL;
        this.originalSize = (long)LittleEndian.readInt(headerData, 11) & 0xFFFFFFFFL;
        this.lastModified = new MsdosDate(LittleEndian.readInt(headerData, 15));
        this.level0DosAttribute = headerData[19];
        this.headerLevel = headerData[20] & 0xFF;
        this.path = new String(headerData, 22, pathLength, encode);
        this.path = this.path.replace('\\', File.separatorChar);
        if (crcIndex + 2 <= headerSize) {
            this.crc = LittleEndian.readShort(headerData, crcIndex);
            if (0 < extraDataLength) {
                this.extraData = new byte[extraDataLength];
                System.arraycopy(headerData, extraDataIndex, this.extraData, 0, extraDataLength);
            }
        } else {
            this.crc = -2;
        }
    }

    private void importLevel1Header(byte[] headerData, String encode) throws UnsupportedEncodingException {
        boolean BaseHeaderSizeIndex = false;
        int BaseHeaderSize = (headerData[0] & 0xFF) + 2;
        int CompressMethodIndex = 2;
        int SkipSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int FileNameLengthIndex = 21;
        int FileNameLength = headerData[21] & 0xFF;
        int FileNameIndex = 22;
        int CRCIndex = 22 + FileNameLength;
        int OSIDIndex = 24 + FileNameLength;
        int ExtraDataIndex = 25 + FileNameLength;
        int ExtraDataLength = BaseHeaderSize - ExtraDataIndex - 2;
        this.method = new String(headerData, 2, 5, encode);
        this.compressedSize = (long)LittleEndian.readInt(headerData, 7) & 0xFFFFFFFFL;
        this.originalSize = (long)LittleEndian.readInt(headerData, 11) & 0xFFFFFFFFL;
        this.lastModified = new MsdosDate(LittleEndian.readInt(headerData, 15));
        this.headerLevel = headerData[20] & 0xFF;
        this.path = new String(headerData, 22, FileNameLength, encode);
        this.crc = LittleEndian.readShort(headerData, CRCIndex);
        this.osid = headerData[OSIDIndex];
        if (0 < ExtraDataLength) {
            this.extraData = new byte[ExtraDataLength];
            System.arraycopy(headerData, ExtraDataIndex, this.extraData, 0, ExtraDataLength);
        }
        boolean hasFileSize = false;
        int index = BaseHeaderSize;
        int length = LittleEndian.readShort(headerData, index - 2);
        while (length != 0) {
            if (!hasFileSize) {
                this.compressedSize -= (long)length;
            }
            this.importExtHeader(headerData, index, length - 2, encode);
            if (headerData[index] == 66) {
                hasFileSize = true;
            }
            length = LittleEndian.readShort(headerData, (index += length) - 2);
        }
    }

    private void importLevel2Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean HeaderSizeIndex = false;
        LittleEndian.readShort(HeaderData, 0);
        int CompressMethodIndex = 2;
        int CompressedSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int CRCIndex = 21;
        int OSIDIndex = 23;
        this.method = new String(HeaderData, 2, 5, encode);
        this.compressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.originalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.lastModified = new Date((long)LittleEndian.readInt(HeaderData, 15) * 1000L);
        this.headerLevel = HeaderData[20] & 0xFF;
        this.crc = LittleEndian.readShort(HeaderData, 21);
        this.osid = HeaderData[23];
        int BaseHeaderSize = 26;
        int index = 26;
        int length = LittleEndian.readShort(HeaderData, index - 2);
        while (length != 0) {
            this.importExtHeader(HeaderData, index, length - 2, encode);
            length = LittleEndian.readShort(HeaderData, (index += length) - 2);
        }
    }

    private void importLevel3Header(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        boolean WordSizeIndex = false;
        LittleEndian.readShort(HeaderData, 0);
        int CompressMethodIndex = 2;
        int CompressedSizeIndex = 7;
        int OriginalSizeIndex = 11;
        int LastModifiedIndex = 15;
        int HeaderLevelIndex = 20;
        int CRCIndex = 21;
        int OSIDIndex = 23;
        this.method = new String(HeaderData, 2, 5, encode);
        this.compressedSize = (long)LittleEndian.readInt(HeaderData, 7) & 0xFFFFFFFFL;
        this.originalSize = (long)LittleEndian.readInt(HeaderData, 11) & 0xFFFFFFFFL;
        this.lastModified = new Date((long)LittleEndian.readInt(HeaderData, 15) * 1000L);
        this.headerLevel = HeaderData[20] & 0xFF;
        this.crc = LittleEndian.readShort(HeaderData, 21);
        this.osid = HeaderData[23];
        int BaseHeaderSize = 32;
        int index = 32;
        int length = LittleEndian.readInt(HeaderData, index - 4);
        while (length != 0) {
            this.importExtHeader(HeaderData, index, length - 4, encode);
            length = LittleEndian.readInt(HeaderData, (index += length) - 4);
        }
    }

    private void importHeader(byte[] HeaderData, String encode) throws UnsupportedEncodingException {
        switch (HeaderData[20]) {
            case 0: {
                this.importLevel0Header(HeaderData, encode);
                break;
            }
            case 1: {
                this.importLevel1Header(HeaderData, encode);
                break;
            }
            case 2: {
                this.importLevel2Header(HeaderData, encode);
                break;
            }
            case 3: {
                this.importLevel3Header(HeaderData, encode);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown header level \"" + HeaderData[20] + "\".");
            }
        }
    }

    private void importCommonExtHeader(byte[] headerData, int index, int length) {
        if (3 < length) {
            if (this.extraExtHeaders == null) {
                this.extraExtHeaders = new Vector();
            }
            byte[] ExtHeaderData = new byte[length];
            System.arraycopy(headerData, index, ExtHeaderData, 0, length);
            this.extraExtHeaders.addElement(ExtHeaderData);
        }
    }

    private void importFileNameExtHeader(byte[] headerData, int index, int length, String encode) throws UnsupportedEncodingException {
        this.setFileName(new String(headerData, index + 1, length - 1, encode));
    }

    private void importDirNameExtHeader(byte[] headerData, int index, int length, String encode) throws UnsupportedEncodingException {
        int len;
        int LhaFileSeparator = -1;
        String dir = "";
        for (int off = 1; off < length; off += len + 1) {
            len = 0;
            while (off + len < length && headerData[index + off + len] != -1) {
                ++len;
            }
            dir = off + len < length ? dir + new String(headerData, index + off, len, encode) + File.separator : dir + new String(headerData, index + off, len, encode);
        }
        this.setDirName(dir);
    }

    private void importFileSizeHeader(byte[] headerData, int index, int length) {
        if (length == 17) {
            this.compressedSize = LittleEndian.readLong(headerData, index + 1);
            this.originalSize = LittleEndian.readLong(headerData, index + 9);
        }
    }

    protected void importExtendHeader(byte[] headerData, int index, int length, String encode) throws UnsupportedEncodingException {
        if (this.extraExtHeaders == null) {
            this.extraExtHeaders = new Vector();
        }
        byte[] extHeaderData = new byte[length];
        System.arraycopy(headerData, index, extHeaderData, 0, length);
        this.extraExtHeaders.addElement(extHeaderData);
    }

    private void importExtHeader(byte[] headerData, int index, int length, String encode) throws UnsupportedEncodingException {
        boolean extendHeaderIdIndex = false;
        switch (headerData[index + 0]) {
            case 0: {
                this.importCommonExtHeader(headerData, index, length);
                break;
            }
            case 1: {
                this.importFileNameExtHeader(headerData, index, length, encode);
                break;
            }
            case 2: {
                this.importDirNameExtHeader(headerData, index, length, encode);
                break;
            }
            case 66: {
                this.importFileSizeHeader(headerData, index, length);
                break;
            }
            default: {
                this.importExtendHeader(headerData, index, length, encode);
            }
        }
    }

    private byte[] exportLevel0Header(String encode) throws UnsupportedEncodingException {
        byte[] headerData;
        int LHarcHeaderSize = 100;
        int CRCLength = this.crc == -2 || this.crc == -1 ? 0 : 2;
        byte[] CompressMethod2 = this.method.getBytes(encode);
        MsdosDate dosDate = null;
        try {
            dosDate = this.lastModified instanceof MsdosDate ? (MsdosDate)this.lastModified : new MsdosDate(this.lastModified);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(exception.toString());
        }
        byte[] PathData = this.path.replace(File.separatorChar, '\\').getBytes(encode);
        int HeaderLength = 22 + CRCLength + PathData.length;
        byte[] ExtraData = CRCLength != 0 && this.extraData != null && HeaderLength + this.extraData.length <= 100 ? this.extraData : new byte[]{};
        HeaderLength += ExtraData.length;
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (100 < HeaderLength) {
            throw new IllegalStateException("Header size too large.");
        }
        if (this.compressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.compressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.compressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.originalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.originalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.originalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(HeaderLength - 2);
            out.write(0);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)this.compressedSize);
            LittleEndian.writeInt(out, (int)this.originalSize);
            LittleEndian.writeInt(out, dosDate.getMsdosTime());
            out.write(this.level0DosAttribute);
            out.write(this.headerLevel);
            out.write(PathData.length);
            out.write(PathData);
            if (this.crc != -1) {
                LittleEndian.writeShort(out, this.crc);
                out.write(ExtraData);
            }
            out.close();
            headerData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        boolean ChecksumIndex = true;
        headerData[1] = (byte)LhaHeader.calcHeaderChecksum(headerData);
        return headerData;
    }

    private byte[] exportLevel1Header(String encode) throws UnsupportedEncodingException {
        byte[] headerData;
        MsdosDate dosDate;
        int LHarcHeaderSize = 100;
        boolean hasFileName = false;
        boolean hasCRC = false;
        byte[] CompressMethod2 = this.method.getBytes(encode);
        try {
            dosDate = this.lastModified instanceof MsdosDate ? (MsdosDate)this.lastModified : new MsdosDate(this.lastModified);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(exception.toString());
        }
        int HeaderLength = 27;
        byte[] ExtraData = this.extraData != null && HeaderLength + this.extraData.length <= 100 ? this.extraData : new byte[]{};
        byte[] FileName = this.getFileName().getBytes(encode);
        if (100 < (HeaderLength += ExtraData.length) + FileName.length) {
            FileName = new byte[]{};
        } else {
            hasFileName = true;
        }
        HeaderLength += FileName.length;
        byte[][] extendHeaders = this.exportExtHeaders(encode);
        long SkipSize = this.compressedSize;
        for (int i = 0; i < extendHeaders.length; ++i) {
            if (extendHeaders[i].length == 0 || 65534 <= extendHeaders[i].length || extendHeaders[i][0] == 1 && hasFileName) {
                extendHeaders[i] = null;
                continue;
            }
            if (extendHeaders[i][0] == 0) {
                hasCRC = true;
            }
            if (extendHeaders[i][0] == 1) {
                hasFileName = true;
            }
            SkipSize += (long)(extendHeaders[i].length + 2);
        }
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (SkipSize != this.compressedSize && !hasCRC) {
            throw new IllegalStateException("no Header CRC field.");
        }
        if (!hasFileName) {
            throw new IllegalStateException("no Filename infomation.");
        }
        if (this.crc == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.crc == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.compressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.compressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.compressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.originalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.originalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.originalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        if (0x100000000L <= SkipSize) {
            throw new IllegalStateException("SkipSize must be 0xFFFFFFFF or less.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(HeaderLength - 2);
            out.write(0);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)SkipSize);
            LittleEndian.writeInt(out, (int)this.originalSize);
            LittleEndian.writeInt(out, dosDate.getMsdosTime());
            out.write(32);
            out.write(this.headerLevel);
            out.write(FileName.length);
            out.write(FileName);
            LittleEndian.writeShort(out, this.crc);
            out.write(this.osid);
            out.write(ExtraData);
            for (byte[] extendHeader : extendHeaders) {
                if (extendHeader == null) continue;
                LittleEndian.writeShort(out, extendHeader.length + 2);
                out.write(extendHeader);
            }
            LittleEndian.writeShort(out, 0);
            out.close();
            headerData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        boolean ChecksumIndex = true;
        int CRCIndex = LhaHeader.getCRC16Position(headerData);
        headerData[1] = (byte)LhaHeader.calcHeaderChecksum(headerData);
        if (hasCRC) {
            LittleEndian.writeShort(headerData, CRCIndex, LhaHeader.calcHeaderCRC16(headerData));
        }
        return headerData;
    }

    private byte[] exportLevel2Header(String encode) throws UnsupportedEncodingException {
        byte[] headerData;
        int MaxHeaderLength = 65535;
        boolean hasFileName = false;
        boolean hasCRC = false;
        boolean needExtraByte = false;
        boolean hasFileSize = false;
        byte[] CompressMethod2 = this.method.getBytes(encode);
        int HeaderLength = 26;
        boolean needFileSize = 0x100000000L <= this.compressedSize || 0x100000000L <= this.originalSize;
        byte[][] ExtendHeaders = this.exportExtHeaders(encode);
        for (int i = 0; i < ExtendHeaders.length; ++i) {
            if (ExtendHeaders[i].length == 0 || 65535 <= HeaderLength + ExtendHeaders[i].length + 2) {
                ExtendHeaders[i] = null;
                continue;
            }
            if (ExtendHeaders[i][0] == 0) {
                hasCRC = true;
            }
            if (ExtendHeaders[i][0] == 1) {
                hasFileName = true;
            }
            if (ExtendHeaders[i][0] == 66) {
                hasFileSize = true;
            }
            HeaderLength += ExtendHeaders[i].length + 2;
        }
        if ((HeaderLength & 0xFF) == 0) {
            ++HeaderLength;
            needExtraByte = true;
        }
        if (CompressMethod2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.lastModified.getTime() < 0L || (this.lastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (!hasCRC) {
            throw new IllegalStateException("HeaderSize too large. can not contain CRC of the Header.");
        }
        if (!hasFileName) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filename.");
        }
        if (needFileSize && !hasFileSize) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filesize.");
        }
        if (this.crc == -2) {
            throw new IllegalStateException("no CRC.");
        }
        if (this.crc == -1) {
            throw new IllegalStateException("CRC must not be UNKNOWN.");
        }
        if (this.compressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (this.compressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.originalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (this.originalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LittleEndian.writeShort(out, HeaderLength);
            out.write(CompressMethod2);
            LittleEndian.writeInt(out, (int)this.compressedSize);
            LittleEndian.writeInt(out, (int)this.originalSize);
            LittleEndian.writeInt(out, (int)(this.lastModified.getTime() / 1000L));
            out.write(32);
            out.write(this.headerLevel);
            LittleEndian.writeShort(out, this.crc);
            out.write(this.osid);
            for (byte[] extendHeader : ExtendHeaders) {
                if (extendHeader == null) continue;
                LittleEndian.writeShort(out, extendHeader.length + 2);
                out.write(extendHeader);
            }
            LittleEndian.writeShort(out, 0);
            if (needExtraByte) {
                out.write(0);
            }
            out.close();
            headerData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int CRCIndex = LhaHeader.getCRC16Position(headerData);
        LittleEndian.writeShort(headerData, CRCIndex, LhaHeader.calcHeaderCRC16(headerData));
        return headerData;
    }

    private byte[] exportLevel3Header(String encode) throws UnsupportedEncodingException {
        byte[] headerData;
        int wordSize = 4;
        byte[] compressMethod = this.method.getBytes(encode);
        int headerLength = 32;
        byte[][] extendHeaders = this.exportExtHeaders(encode);
        for (int i = 0; i < extendHeaders.length; ++i) {
            if (extendHeaders[i].length == 0) {
                extendHeaders[i] = null;
                continue;
            }
            headerLength += extendHeaders[i].length + 4;
        }
        if (compressMethod.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.lastModified.getTime() < 0L || (this.lastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (this.crc == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.crc == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.compressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.compressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.compressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.originalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.originalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.originalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LittleEndian.writeShort(out, 4);
            out.write(compressMethod);
            LittleEndian.writeInt(out, (int)this.compressedSize);
            LittleEndian.writeInt(out, (int)this.originalSize);
            LittleEndian.writeInt(out, (int)(this.lastModified.getTime() / 1000L));
            out.write(32);
            out.write(this.headerLevel);
            LittleEndian.writeShort(out, this.crc);
            out.write(this.osid);
            LittleEndian.writeInt(out, headerLength);
            for (byte[] extendHeader : extendHeaders) {
                if (extendHeader == null) continue;
                LittleEndian.writeInt(out, extendHeader.length + 4);
                out.write(extendHeader);
            }
            LittleEndian.writeInt(out, 0);
            out.close();
            headerData = out.toByteArray();
        }
        catch (IOException exception) {
            throw new Error("caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int CRCIndex = LhaHeader.getCRC16Position(headerData);
        LittleEndian.writeShort(headerData, CRCIndex, LhaHeader.calcHeaderCRC16(headerData));
        return headerData;
    }

    private byte[] exportHeader(String encode) throws UnsupportedEncodingException {
        switch (this.headerLevel) {
            case 0: {
                return this.exportLevel0Header(encode);
            }
            case 1: {
                return this.exportLevel1Header(encode);
            }
            case 2: {
                return this.exportLevel2Header(encode);
            }
            case 3: {
                return this.exportLevel3Header(encode);
            }
        }
        throw new IllegalStateException("unknown header level \"" + this.headerLevel + "\".");
    }

    private byte[] exportCommonExtHeader() {
        if (this.extraExtHeaders != null) {
            for (int i = 0; i < this.extraExtHeaders.size(); ++i) {
                byte[] extendHeaderData = this.extraExtHeaders.elementAt(i);
                if (extendHeaderData[0] != 0) continue;
                return extendHeaderData;
            }
        }
        return new byte[3];
    }

    private byte[] exportFileNameExtHeader(String encode) throws UnsupportedEncodingException {
        byte[] filename = this.getFileName().getBytes(encode);
        byte[] extendHeaderData = new byte[filename.length + 1];
        extendHeaderData[0] = 1;
        System.arraycopy(filename, 0, extendHeaderData, 1, filename.length);
        return extendHeaderData;
    }

    private byte[] exportDirNameExtHeader(String encode) throws UnsupportedEncodingException {
        int LhaFileSeparator = -1;
        String dir = this.getDirName();
        Vector<byte[]> vec = new Vector<byte[]>();
        int index = 0;
        int len = 0;
        int length = 0;
        while (index + len < dir.length()) {
            if (dir.charAt(index + len) == File.separatorChar) {
                byte[] src = dir.substring(index, index + len).getBytes(encode);
                byte[] array = new byte[src.length + 1];
                System.arraycopy(src, 0, array, 0, src.length);
                array[src.length] = -1;
                length += array.length;
                vec.addElement(array);
                index += len + 1;
                len = 0;
                continue;
            }
            if (index + len + 1 < dir.length()) {
                byte[] array = dir.substring(index, index + len + 1).getBytes(encode);
                length += array.length;
                vec.addElement(array);
                index += len + 1;
                len = 0;
                continue;
            }
            ++len;
        }
        byte[] ExtendHeaderData = new byte[length + 1];
        ExtendHeaderData[0] = 2;
        index = 1;
        for (int i = 0; i < vec.size(); ++i) {
            byte[] array = (byte[])vec.elementAt(i);
            System.arraycopy(array, 0, ExtendHeaderData, index, array.length);
            index += array.length;
        }
        return ExtendHeaderData;
    }

    private byte[] exportFileSizeHeader() {
        byte[] extendHeaderData = new byte[17];
        extendHeaderData[0] = 66;
        LittleEndian.writeLong(extendHeaderData, 1, this.compressedSize);
        LittleEndian.writeLong(extendHeaderData, 9, this.originalSize);
        return extendHeaderData;
    }

    protected byte[][] exportExtendHeaders(String encode) throws UnsupportedEncodingException {
        if (this.extraExtHeaders != null) {
            byte[][] extendHeaders = new byte[this.extraExtHeaders.size()][];
            for (int i = 0; i < this.extraExtHeaders.size(); ++i) {
                extendHeaders[i] = this.extraExtHeaders.elementAt(i);
            }
            return extendHeaders;
        }
        return new byte[0][];
    }

    private byte[][] exportExtHeaders(String encode) throws UnsupportedEncodingException {
        byte[] commonExtHeader = this.exportCommonExtHeader();
        byte[] filenameExtHeader = this.exportFileNameExtHeader(encode);
        byte[] dirNameExtHeader = this.exportDirNameExtHeader(encode);
        byte[][] ExtraExtHeaders = this.exportExtendHeaders(encode);
        Vector<byte[]> headers = new Vector<byte[]>();
        headers.addElement(commonExtHeader);
        headers.addElement(filenameExtHeader);
        if (1 < dirNameExtHeader.length) {
            headers.addElement(dirNameExtHeader);
        }
        if (this.headerLevel == 2 && (0x100000000L <= this.compressedSize || 0x100000000L <= this.originalSize)) {
            headers.addElement(this.exportFileSizeHeader());
        }
        for (byte[] ExtendHeaderData : ExtraExtHeaders) {
            if (0 >= ExtendHeaderData.length || ExtendHeaderData[0] == 0 || ExtendHeaderData[0] == 1 || ExtendHeaderData[0] == 2) continue;
            headers.addElement(ExtendHeaderData);
        }
        byte[][] ExtendHeaders = new byte[headers.size()][];
        for (int i = 0; i < ExtendHeaders.length; ++i) {
            ExtendHeaders[i] = (byte[])headers.elementAt(i);
        }
        return ExtendHeaders;
    }

    public static boolean checkHeaderData(byte[] headerData) {
        try {
            switch (headerData[20] & 0xFF) {
                case 0: {
                    return LhaHeader.verifyHeaderChecksum(headerData);
                }
                case 1: {
                    return LhaHeader.verifyHeaderChecksum(headerData) && (LhaHeader.getCRC16Position(headerData) == -1 || LhaHeader.verifyHeaderCRC16(headerData));
                }
                case 2: {
                    return LhaHeader.verifyHeaderCRC16(headerData);
                }
                case 3: {
                    return LhaHeader.verifyHeaderCRC16(headerData);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int getCRC16Position(byte[] headerData) {
        int position;
        int length;
        int WordSize;
        switch (headerData[20] & 0xFF) {
            case 1: {
                WordSize = 2;
                position = length = (headerData[0] & 0xFF) + 2;
                break;
            }
            case 2: {
                WordSize = 2;
                length = 26;
                position = 26;
                break;
            }
            case 3: {
                WordSize = 4;
                length = 32;
                position = 32;
                break;
            }
            default: {
                return -1;
            }
        }
        while (0 < length && position < headerData.length) {
            length = 0;
            for (int i = 0; i < WordSize; ++i) {
                length = length << 8 | headerData[position - (1 + i)] & 0xFF;
            }
            if (headerData[position] == 0) {
                return position + 1;
            }
            position += length;
        }
        return -1;
    }

    private static int calcHeaderChecksum(byte[] headerData) {
        int length = headerData[0] & 0xFF;
        LhaChecksum checksum = new LhaChecksum();
        checksum.update(headerData, 2, length);
        return (int)checksum.getValue();
    }

    private static int calcHeaderCRC16(byte[] headerData) {
        int position = LhaHeader.getCRC16Position(headerData);
        int crcValue = 0;
        if (position != -1) {
            crcValue = LittleEndian.readShort(headerData, position);
            LittleEndian.writeShort(headerData, position, 0);
        }
        CRC16 crc16 = new CRC16();
        crc16.update(headerData);
        if (position != -1) {
            LittleEndian.writeShort(headerData, position, crcValue);
        }
        return (int)crc16.getValue();
    }

    private static int readHeaderChecksum(byte[] headerData) {
        return headerData[1] & 0xFF;
    }

    private static int readHeaderCRC16(byte[] headerData) {
        int position = LhaHeader.getCRC16Position(headerData);
        if (position != -1) {
            return LittleEndian.readShort(headerData, position);
        }
        return -1;
    }

    private static boolean verifyHeaderChecksum(byte[] headerData) {
        switch (headerData[20] & 0xFF) {
            case 0: 
            case 1: {
                return LhaHeader.readHeaderChecksum(headerData) == LhaHeader.calcHeaderChecksum(headerData);
            }
        }
        return false;
    }

    private static boolean verifyHeaderCRC16(byte[] headerData) {
        switch (headerData[20] & 0xFF) {
            case 1: 
            case 2: 
            case 3: {
                return LhaHeader.readHeaderCRC16(headerData) == LhaHeader.calcHeaderCRC16(headerData);
            }
        }
        return false;
    }

    public static byte[] getFirstHeaderData(InputStream in) throws IOException {
        if (in.markSupported()) {
            try {
                int read;
                int stock1 = -1;
                int stock2 = -1;
                while (0 <= (read = in.read())) {
                    if (read == 45 && 0 < stock1) {
                        in.mark(65536);
                        LhaHeader.ensureSkip(in, 3L);
                        if (in.read() == 45) {
                            byte[] HeaderData;
                            LhaHeader.ensureSkip(in, 13L);
                            int HeaderLevel = in.read();
                            in.reset();
                            switch (HeaderLevel) {
                                case 0: {
                                    HeaderData = LhaHeader.readLevel0HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 1: {
                                    HeaderData = LhaHeader.readLevel1HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 2: {
                                    HeaderData = LhaHeader.readLevel2HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                case 3: {
                                    HeaderData = LhaHeader.readLevel3HeaderData(stock1, stock2, read, in);
                                    break;
                                }
                                default: {
                                    HeaderData = null;
                                }
                            }
                            if (HeaderData != null && LhaHeader.checkHeaderData(HeaderData)) {
                                return HeaderData;
                            }
                        }
                        in.reset();
                    }
                    stock1 = stock2;
                    stock2 = read;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    public static byte[] getNextHeaderData(InputStream in) throws IOException {
        if (in.markSupported()) {
            try {
                int first = in.read();
                if (0 < first) {
                    int second = in.read();
                    int third = in.read();
                    in.mark(65536);
                    LhaHeader.ensureSkip(in, 3L);
                    int seventh = in.read();
                    if (third == 45 && seventh == 45) {
                        byte[] HeaderData;
                        LhaHeader.ensureSkip(in, 13L);
                        int HeaderLevel = in.read();
                        in.reset();
                        switch (HeaderLevel) {
                            case 0: {
                                HeaderData = LhaHeader.readLevel0HeaderData(first, second, third, in);
                                break;
                            }
                            case 1: {
                                HeaderData = LhaHeader.readLevel1HeaderData(first, second, third, in);
                                break;
                            }
                            case 2: {
                                HeaderData = LhaHeader.readLevel2HeaderData(first, second, third, in);
                                break;
                            }
                            case 3: {
                                HeaderData = LhaHeader.readLevel3HeaderData(first, second, third, in);
                                break;
                            }
                            default: {
                                HeaderData = null;
                            }
                        }
                        if (HeaderData != null && LhaHeader.checkHeaderData(HeaderData)) {
                            return HeaderData;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    private static byte[] readLevel0HeaderData(int headerLength, int headerChecksum, int compressMethod1, InputStream in) throws IOException {
        int readed;
        byte[] headerData = new byte[headerLength + 2];
        headerData[0] = (byte)headerLength;
        headerData[1] = (byte)headerChecksum;
        headerData[2] = (byte)compressMethod1;
        int length = 0;
        headerLength += 2;
        for (readed = 3; readed < headerLength && 0 <= length; readed += length) {
            length = in.read(headerData, readed, headerLength - readed);
        }
        if (readed == headerLength) {
            return headerData;
        }
        throw new EOFException();
    }

    private static byte[] readLevel1HeaderData(int baseHeaderLength, int baseHeaderChecksum, int compressMethod1, InputStream in) throws IOException {
        int headerLength = baseHeaderLength + 2;
        Vector<byte[]> headers = new Vector<byte[]>();
        byte[] headerData = new byte[headerLength];
        headerData[0] = (byte)baseHeaderLength;
        headerData[1] = (byte)baseHeaderChecksum;
        headerData[2] = (byte)compressMethod1;
        int readed = 0;
        int length = 0;
        do {
            for (readed = 0 == headers.size() ? 3 : 0; readed < headerLength && 0 <= length; readed += length) {
                length = in.read(headerData, readed, headerLength - readed);
            }
            if (readed == headerLength) {
                if (0 == headers.size() && !LhaHeader.verifyHeaderChecksum(headerData)) {
                    return null;
                }
            } else {
                throw new EOFException();
            }
            headers.addElement(headerData);
            length = headerLength;
            headerLength = LittleEndian.readShort(headerData, headerLength - 2);
            headerData = new byte[headerLength];
        } while (0 < headerLength && readed == length);
        headerLength = 0;
        for (int i = 0; i < headers.size(); ++i) {
            headerLength += ((byte[])headers.elementAt(i)).length;
        }
        headerData = new byte[headerLength];
        int position = 0;
        for (int i = 0; i < headers.size(); ++i) {
            byte[] Data = (byte[])headers.elementAt(i);
            System.arraycopy(Data, 0, headerData, position, Data.length);
            position += Data.length;
        }
        return headerData;
    }

    private static byte[] readLevel2HeaderData(int headerLengthLow, int headerLengthHi, int compressMethod1, InputStream in) throws IOException {
        int readed;
        int headerLength = headerLengthHi << 8 | headerLengthLow;
        byte[] headerData = new byte[headerLength];
        headerData[0] = (byte)headerLengthLow;
        headerData[1] = (byte)headerLengthHi;
        headerData[2] = (byte)compressMethod1;
        int length = 0;
        for (readed = 3; readed < headerLength && 0 <= length; readed += length) {
            length = in.read(headerData, readed, headerLength - readed);
        }
        if (readed == headerLength) {
            return headerData;
        }
        throw new EOFException();
    }

    private static byte[] readLevel3HeaderData(int wordSizeLow, int wordSizeHi, int compressMethod1, InputStream in) throws IOException {
        if (wordSizeLow == 4 && wordSizeHi == 0) {
            int readed;
            in.skip(21L);
            int HeaderLength = LittleEndian.readInt(in);
            in.reset();
            byte[] HeaderData = new byte[HeaderLength];
            HeaderData[0] = (byte)wordSizeLow;
            HeaderData[1] = (byte)wordSizeHi;
            HeaderData[2] = (byte)compressMethod1;
            int length = 0;
            for (readed = 3; readed < HeaderLength && 0 <= length; readed += length) {
                length = in.read(HeaderData, readed, HeaderLength - readed);
            }
            if (readed == HeaderLength) {
                return HeaderData;
            }
            throw new EOFException();
        }
        return null;
    }

    public static LhaHeader createInstance(byte[] headerData, Properties property) {
        String generator;
        String packages;
        String encoding = property.getProperty("lha.encoding");
        if (encoding == null) {
            encoding = LhaProperty.getProperty("lha.encoding");
        }
        if ((packages = property.getProperty("lha.packages")) == null) {
            packages = LhaProperty.getProperty("lha.packages");
        }
        if ((generator = property.getProperty("lha.header")) == null) {
            generator = LhaProperty.getProperty("lha.header");
        }
        Hashtable<String, Object> substitute = new Hashtable<String, Object>();
        substitute.put("data", headerData);
        substitute.put("encoding", encoding);
        return (LhaHeader)LhaProperty.parse(generator, substitute, packages);
    }

    private static void ensureSkip(InputStream in, long len) throws IOException {
        while (0L < len) {
            long skiplen = in.skip(len);
            if (skiplen <= 0L) {
                if (0 <= in.read()) {
                    --len;
                    continue;
                }
                throw new EOFException();
            }
            len -= skiplen;
        }
    }
}

