/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.PreLz5Decoder;
import com.orangesignal.jlha.PreLzssDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LzssInputStream
extends InputStream {
    private PreLzssDecoder decoder;
    private int threshold;
    private int maxMatch;
    private long length;
    private byte[] textBuffer;
    private long textPosition;
    private long textDecoded;
    private byte[] markTextBuffer;
    private long markTextPosition;
    private long markTextDecoded;

    public LzssInputStream(PreLzssDecoder decoder) {
        this(decoder, Long.MAX_VALUE);
    }

    public LzssInputStream(PreLzssDecoder decoder, long length) {
        this.maxMatch = decoder.getMaxMatch();
        this.threshold = decoder.getThreshold();
        this.length = length;
        this.decoder = decoder;
        this.textBuffer = new byte[decoder.getDictionarySize()];
        this.textPosition = 0L;
        this.textDecoded = 0L;
        if (this.decoder instanceof PreLz5Decoder) {
            this.initLz5TextBuffer();
        }
    }

    @Override
    public int read() throws IOException {
        block3: {
            if (this.textDecoded <= this.textPosition) {
                try {
                    this.decode();
                }
                catch (EOFException exception) {
                    if (this.textDecoded > this.textPosition) break block3;
                    return -1;
                }
            }
        }
        return this.textBuffer[(int)this.textPosition++ & this.textBuffer.length - 1] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        int position;
        block4: {
            position = index;
            int end = index + length;
            try {
                while (position < end) {
                    if (this.textDecoded <= this.textPosition) {
                        this.decode();
                    }
                    position = this.copyTextBufferToBuffer(buffer, position, end);
                }
            }
            catch (EOFException exception) {
                position = this.copyTextBufferToBuffer(buffer, position, end);
                if (position != index) break block4;
                return -1;
            }
        }
        return position - index;
    }

    @Override
    public long skip(long length) throws IOException {
        long end = this.textPosition + length;
        try {
            while (this.textPosition < end) {
                if (this.textDecoded <= this.textPosition) {
                    this.decode();
                }
                this.textPosition = Math.min(end, this.textDecoded);
            }
        }
        catch (EOFException exception) {
            this.textPosition = Math.min(end, this.textDecoded);
        }
        return length - (end - this.textPosition);
    }

    @Override
    public void mark(int readLimit) {
        readLimit -= (int)(this.textDecoded - this.textPosition);
        int Size = this.textBuffer.length - this.maxMatch;
        readLimit = (readLimit + Size - 1) / Size * Size;
        this.decoder.mark(Math.max(readLimit, 0));
        if (this.markTextBuffer == null) {
            this.markTextBuffer = (byte[])this.textBuffer.clone();
        } else {
            System.arraycopy(this.textBuffer, 0, this.markTextBuffer, 0, this.textBuffer.length);
        }
        this.markTextPosition = this.textPosition;
        this.markTextDecoded = this.textDecoded;
    }

    @Override
    public void reset() throws IOException {
        if (this.markTextBuffer == null) {
            throw new IOException("not marked.");
        }
        if (this.textDecoded - this.markTextPosition <= (long)this.textBuffer.length) {
            this.textPosition = this.markTextPosition;
        } else if (this.decoder.markSupported()) {
            this.decoder.reset();
            System.arraycopy(this.markTextBuffer, 0, this.textBuffer, 0, this.textBuffer.length);
            this.textPosition = this.markTextPosition;
            this.textDecoded = this.markTextDecoded;
        } else {
            throw new IOException("mark/reset not supported.");
        }
    }

    @Override
    public boolean markSupported() {
        return this.decoder.markSupported();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.textDecoded - this.textPosition) + this.decoder.available();
    }

    @Override
    public void close() throws IOException {
        this.decoder.close();
        this.decoder = null;
        this.textBuffer = null;
        this.markTextBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() throws IOException {
        if (this.textDecoded < this.length) {
            int TextStart;
            int TextMask = this.textBuffer.length - 1;
            int TextPos = TextStart = (int)this.textDecoded & TextMask;
            int TextLimit = (int)(Math.min(this.textPosition + (long)this.textBuffer.length - (long)this.maxMatch, this.length) - this.textDecoded) + TextStart;
            try {
                while (TextPos < TextLimit) {
                    int Code = this.decoder.readCode();
                    if (Code < 256) {
                        this.textBuffer[TextMask & TextPos++] = (byte)Code;
                        continue;
                    }
                    int MatchLength = (Code & 0xFF) + this.threshold;
                    int MatchPosition = TextPos - this.decoder.readOffset() - 1;
                    while (0 < MatchLength--) {
                        this.textBuffer[TextMask & TextPos++] = this.textBuffer[TextMask & MatchPosition++];
                    }
                }
            }
            finally {
                this.textDecoded += (long)(TextPos - TextStart);
            }
        } else {
            throw new EOFException();
        }
    }

    private int copyTextBufferToBuffer(byte[] buffer, int position, int end) {
        int length;
        if ((this.textPosition & (long)(~(this.textBuffer.length - 1))) < (this.textDecoded & (long)(~(this.textBuffer.length - 1)))) {
            length = Math.min(this.textBuffer.length - ((int)this.textPosition & this.textBuffer.length - 1), end - position);
            System.arraycopy(this.textBuffer, (int)this.textPosition & this.textBuffer.length - 1, buffer, position, length);
            this.textPosition += (long)length;
            position += length;
        }
        if (this.textPosition < this.textDecoded) {
            length = Math.min((int)(this.textDecoded - this.textPosition), end - position);
            System.arraycopy(this.textBuffer, (int)this.textPosition & this.textBuffer.length - 1, buffer, position, length);
            this.textPosition += (long)length;
            position += length;
        }
        return position;
    }

    private void initLz5TextBuffer() {
        int i;
        int position = 18;
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.textBuffer[position++] = (byte)i;
            }
        }
        for (i = 0; i < 256; ++i) {
            this.textBuffer[position++] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            this.textBuffer[position++] = (byte)(255 - i);
        }
        for (i = 0; i < 128; ++i) {
            this.textBuffer[position++] = 0;
        }
        while (position < this.textBuffer.length) {
            this.textBuffer[position++] = 32;
        }
    }
}

