/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BadHuffmanTableException;
import com.orangesignal.jlha.BitOutputStream;
import com.orangesignal.jlha.Bits;
import com.orangesignal.jlha.CompressMethod;
import com.orangesignal.jlha.PostLzssEncoder;
import com.orangesignal.jlha.StaticHuffman;
import java.io.IOException;
import java.io.OutputStream;

public class PostLh5Encoder
implements PostLzssEncoder {
    private BitOutputStream out;
    private int dictionarySize;
    private int maxMatch;
    private int threshold;
    private int dictionarySizeByteLen;
    private int position;
    private int flagBit;
    private int flagPos;
    private int currentBlock;
    private byte[][] block;
    private int[] blockSize;
    private int[][] blockCodeFreq;
    private int[][] blockOffLenFreq;
    private int[][] pattern;
    private int[][] group;

    public PostLh5Encoder(OutputStream out) {
        this(out, "-lh5-");
    }

    public PostLh5Encoder(OutputStream out, String method) {
        this(out, method, 16384);
    }

    public PostLh5Encoder(OutputStream out, String method, int BufferSize) {
        this(out, method, 1, BufferSize, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PostLh5Encoder(OutputStream out, String method, int BlockNum, int BlockSize, int DivideNum) {
        if (!("-lh4-".equals(method) || "-lh5-".equals(method) || "-lh6-".equals(method) || "-lh7-".equals(method))) {
            if (method != null) throw new IllegalArgumentException("Unknown compress method. " + method);
            throw new NullPointerException("method");
        }
        this.dictionarySize = CompressMethod.toDictionarySize(method);
        this.maxMatch = CompressMethod.toMaxMatch(method);
        this.threshold = CompressMethod.toThreshold(method);
        this.dictionarySizeByteLen = (Bits.len(this.dictionarySize - 1) + 7) / 8;
        int minCapacity = (this.dictionarySizeByteLen + 1) * 8 + 1;
        if (out != null && 0 < BlockNum && 0 <= DivideNum && DivideNum < BlockNum && minCapacity <= BlockSize) {
            this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
            this.currentBlock = 0;
            this.block = new byte[BlockNum][];
            this.blockSize = new int[BlockNum];
            this.blockCodeFreq = new int[BlockNum][];
            this.blockOffLenFreq = new int[BlockNum][];
            int codeFreqSize = 256 + this.maxMatch - this.threshold + 1;
            int offLenFreqSize = Bits.len(this.dictionarySize);
            int i = 0;
            while (true) {
                if (i >= BlockNum) {
                    this.group = PostLh5Encoder.createGroup(BlockNum, DivideNum);
                    this.pattern = PostLh5Encoder.createPattern(BlockNum, DivideNum);
                    this.position = 0;
                    this.flagBit = 0;
                    this.flagPos = 0;
                    return;
                }
                this.block[i] = new byte[BlockSize];
                this.blockCodeFreq[i] = new int[codeFreqSize];
                this.blockOffLenFreq[i] = new int[offLenFreqSize];
                ++i;
            }
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (BlockNum <= 0) {
            throw new IllegalArgumentException("BlockNum too small. BlockNum must be 1 or more.");
        }
        if (DivideNum < 0) throw new IllegalArgumentException("DivideNum out of bounds( 0 to BlockNum - 1(" + (BlockNum - 1) + ") ).");
        if (BlockNum > DivideNum) throw new IllegalArgumentException("BlockSize too small. BlockSize must be larger than " + minCapacity);
        throw new IllegalArgumentException("DivideNum out of bounds( 0 to BlockNum - 1(" + (BlockNum - 1) + ") ).");
    }

    @Override
    public void writeCode(int code) throws IOException {
        int need = (256 <= code ? this.dictionarySizeByteLen + 1 : 1) + (this.flagBit == 0 ? 1 : 0);
        if (this.block[this.currentBlock].length - this.position < need || 65535 <= this.blockSize[this.currentBlock]) {
            ++this.currentBlock;
            if (this.block.length <= this.currentBlock) {
                this.writeOut();
            } else {
                this.position = 0;
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        } else if (this.flagBit == 0) {
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        }
        this.block[this.currentBlock][this.position++] = (byte)code;
        if (256 <= code) {
            byte[] byArray = this.block[this.currentBlock];
            int n = this.flagPos;
            byArray[n] = (byte)(byArray[n] | this.flagBit);
        }
        this.flagBit >>= 1;
        int[] nArray = this.blockCodeFreq[this.currentBlock];
        int n = code;
        nArray[n] = nArray[n] + 1;
        int n2 = this.currentBlock;
        this.blockSize[n2] = this.blockSize[n2] + 1;
    }

    @Override
    public void writeOffset(int offset) {
        for (int shift = this.dictionarySizeByteLen - 1 << 3; 0 <= shift; shift -= 8) {
            this.block[this.currentBlock][this.position++] = (byte)(offset >> shift);
        }
        int[] nArray = this.blockOffLenFreq[this.currentBlock];
        int n = Bits.len(offset);
        nArray[n] = nArray[n] + 1;
    }

    @Override
    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.block = null;
        this.blockCodeFreq = null;
        this.blockOffLenFreq = null;
        this.group = null;
        this.pattern = null;
    }

    @Override
    public int getDictionarySize() {
        return this.dictionarySize;
    }

    @Override
    public int getMaxMatch() {
        return this.maxMatch;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    private void writeOut() throws IOException {
        if (1 < this.block.length) {
            this.writeOutBestPattern();
        } else {
            this.writeOutGroup(new int[]{0});
            this.currentBlock = 0;
        }
        this.position = 0;
        this.flagBit = 0;
    }

    private void writeOutBestPattern() throws IOException {
        int[] bestPattern = null;
        int[] groupHuffLen = new int[this.group.length];
        for (int i = 0; i < this.group.length; ++i) {
            if (this.group != null) {
                int blockSize = 0;
                for (int j = 0; j < this.group[i].length; ++j) {
                    blockSize += this.blockSize[this.group[i][j]];
                }
                if (0 < blockSize && blockSize < 65536) {
                    groupHuffLen[i] = PostLh5Encoder.calcHuffmanCodeLength(this.dictionarySize, PostLh5Encoder.margeArrays(this.group[i], this.blockCodeFreq), PostLh5Encoder.margeArrays(this.group[i], this.blockOffLenFreq));
                    continue;
                }
                if (0 == blockSize) {
                    groupHuffLen[i] = 0;
                    continue;
                }
                groupHuffLen[i] = -1;
                continue;
            }
            groupHuffLen[i] = -1;
        }
        int smallest = Integer.MAX_VALUE;
        for (int[] nArray : this.pattern) {
            int length = 0;
            for (int j = 0; j < nArray.length; ++j) {
                if (0 <= groupHuffLen[nArray[j]]) {
                    length += groupHuffLen[nArray[j]];
                    continue;
                }
                length = Integer.MAX_VALUE;
                break;
            }
            if (length >= smallest) continue;
            bestPattern = nArray;
            smallest = length;
        }
        if (bestPattern != null) {
            for (int[] nArray : bestPattern) {
                this.writeOutGroup(this.group[nArray]);
            }
        } else {
            int i = 0;
            while (i < this.block.length) {
                this.writeOutGroup(new int[]{i++});
            }
        }
        this.currentBlock = 0;
    }

    private void writeOutGroup(int[] group) throws IOException {
        int[] codeFreq = PostLh5Encoder.margeArrays(group, this.blockCodeFreq);
        int[] offLenFreq = PostLh5Encoder.margeArrays(group, this.blockOffLenFreq);
        int blockSize = 0;
        for (int element : group) {
            blockSize += this.blockSize[element];
        }
        if (0 < blockSize) {
            this.out.writeBits(16, blockSize);
            int[] codeLen = StaticHuffman.FreqListToLenList(codeFreq);
            int[] codeCode = StaticHuffman.LenListToCodeList(codeLen);
            int[] offLenLen = StaticHuffman.FreqListToLenList(offLenFreq);
            int[] offLenCode = StaticHuffman.LenListToCodeList(offLenLen);
            if (2 <= PostLh5Encoder.countNoZeroElement(codeFreq)) {
                int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq(codeLen);
                int[] codeLenLen = StaticHuffman.FreqListToLenList(codeLenFreq);
                int[] codeLenCode = StaticHuffman.LenListToCodeList(codeLenLen);
                if (2 <= PostLh5Encoder.countNoZeroElement(codeLenFreq)) {
                    this.writeCodeLenLen(codeLenLen);
                } else {
                    this.out.writeBits(5, 0);
                    this.out.writeBits(5, PostLh5Encoder.getNoZeroElementIndex(codeLenFreq));
                }
                this.writeCodeLen(codeLen, codeLenLen, codeLenCode);
            } else {
                this.out.writeBits(10, 0);
                this.out.writeBits(18, PostLh5Encoder.getNoZeroElementIndex(codeFreq));
            }
            if (2 <= PostLh5Encoder.countNoZeroElement(offLenFreq)) {
                this.writeOffLenLen(offLenLen);
            } else {
                int len = Bits.len(Bits.len(this.dictionarySize));
                this.out.writeBits(len, 0);
                this.out.writeBits(len, PostLh5Encoder.getNoZeroElementIndex(offLenFreq));
            }
            for (int element : group) {
                this.position = 0;
                this.flagBit = 0;
                byte[] buffer = this.block[element];
                for (int j = 0; j < this.blockSize[element]; ++j) {
                    int code;
                    if (this.flagBit == 0) {
                        this.flagBit = 128;
                        ++this.position;
                        this.flagPos = this.flagPos;
                    }
                    if (0 == (buffer[this.flagPos] & this.flagBit)) {
                        code = buffer[this.position++] & 0xFF;
                        this.out.writeBits(codeLen[code], codeCode[code]);
                    } else {
                        code = buffer[this.position++] & 0xFF | 0x100;
                        int offset = 0;
                        for (int k = 0; k < this.dictionarySizeByteLen; ++k) {
                            offset = offset << 8 | buffer[this.position++] & 0xFF;
                        }
                        int offlen = Bits.len(offset);
                        this.out.writeBits(codeLen[code], codeCode[code]);
                        this.out.writeBits(offLenLen[offlen], offLenCode[offlen]);
                        if (1 < offlen) {
                            this.out.writeBits(offlen - 1, offset);
                        }
                    }
                    this.flagBit >>= 1;
                }
            }
            for (int i = 0; i < group.length; ++i) {
                int j;
                this.blockSize[group[i]] = 0;
                codeFreq = this.blockCodeFreq[group[i]];
                for (j = 0; j < codeFreq.length; ++j) {
                    codeFreq[j] = 0;
                }
                offLenFreq = this.blockOffLenFreq[group[i]];
                for (j = 0; j < offLenFreq.length; ++j) {
                    offLenFreq[j] = 0;
                }
            }
        }
    }

    private void writeCodeLenLen(int[] codeLenLen) throws IOException {
        int end;
        for (end = codeLenLen.length; 0 < end && codeLenLen[end - 1] == 0; --end) {
        }
        this.out.writeBits(5, end);
        int index = 0;
        while (index < end) {
            int len;
            if ((len = codeLenLen[index++]) <= 6) {
                this.out.writeBits(3, len);
            } else {
                this.out.writeBits(len - 3, (1 << len - 3) - 2);
            }
            if (index != 3) continue;
            while (codeLenLen[index] == 0 && index < 6) {
                ++index;
            }
            this.out.writeBits(2, index - 3 & 3);
        }
    }

    private void writeCodeLen(int[] codeLen, int[] codeLenLen, int[] codeLenCode) throws IOException {
        int end;
        for (end = codeLen.length; 0 < end && codeLen[end - 1] == 0; --end) {
        }
        this.out.writeBits(9, end);
        int index = 0;
        while (index < end) {
            int len;
            if (0 < (len = codeLen[index++])) {
                this.out.writeBits(codeLenLen[len + 2], codeLenCode[len + 2]);
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                for (int i = 0; i < count; ++i) {
                    this.out.writeBits(codeLenLen[0], codeLenCode[0]);
                }
                continue;
            }
            if (count <= 18) {
                this.out.writeBits(codeLenLen[1], codeLenCode[1]);
                this.out.writeBits(4, count - 3);
                continue;
            }
            if (count == 19) {
                this.out.writeBits(codeLenLen[0], codeLenCode[0]);
                this.out.writeBits(codeLenLen[1], codeLenCode[1]);
                this.out.writeBits(4, 15);
                continue;
            }
            this.out.writeBits(codeLenLen[2], codeLenCode[2]);
            this.out.writeBits(9, count - 20);
        }
    }

    private void writeOffLenLen(int[] offLenLen) throws IOException {
        int end;
        for (end = offLenLen.length; 0 < end && offLenLen[end - 1] == 0; --end) {
        }
        int len = Bits.len(Bits.len(this.dictionarySize));
        this.out.writeBits(len, end);
        int index = 0;
        while (index < end) {
            if ((len = offLenLen[index++]) <= 6) {
                this.out.writeBits(3, len);
                continue;
            }
            this.out.writeBits(len - 3, (1 << len - 3) - 2);
        }
    }

    private static int countNoZeroElement(int[] array) {
        int count = 0;
        for (int element : array) {
            if (0 == element) continue;
            ++count;
        }
        return count;
    }

    private static int getNoZeroElementIndex(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (0 == array[i]) continue;
            return i;
        }
        return 0;
    }

    private static int[] margeArrays(int[] indexes, int[][] arrays) {
        if (1 < indexes.length) {
            int[] array = new int[arrays[0].length];
            for (int indexe : indexes) {
                int[] src = arrays[indexe];
                for (int j = 0; j < src.length; ++j) {
                    int n = j;
                    array[n] = array[n] + src[j];
                }
            }
            return array;
        }
        return arrays[indexes[0]];
    }

    private static int[] createCodeLenFreq(int[] codeLen) {
        int end;
        int[] codeLenFreq = new int[19];
        for (end = codeLen.length; 0 < end && codeLen[end - 1] == 0; --end) {
        }
        int index = 0;
        while (index < end) {
            int len;
            if (0 < (len = codeLen[index++])) {
                int n = len + 2;
                codeLenFreq[n] = codeLenFreq[n] + 1;
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                codeLenFreq[0] = codeLenFreq[0] + count;
                continue;
            }
            if (count <= 18) {
                codeLenFreq[1] = codeLenFreq[1] + 1;
                continue;
            }
            if (count == 19) {
                codeLenFreq[0] = codeLenFreq[0] + 1;
                codeLenFreq[1] = codeLenFreq[1] + 1;
                continue;
            }
            codeLenFreq[2] = codeLenFreq[2] + 1;
        }
        return codeLenFreq;
    }

    private static int calcHuffmanCodeLength(int DictionarySize, int[] codeFreq, int[] offLenFreq) {
        int i;
        int[] offLenLen;
        int[] codeLen;
        int length = 0;
        try {
            codeLen = StaticHuffman.FreqListToLenList(codeFreq);
            StaticHuffman.LenListToCodeList(codeLen);
            offLenLen = StaticHuffman.FreqListToLenList(offLenFreq);
        }
        catch (BadHuffmanTableException exception) {
            throw new Error("caught the BadHuffmanTableException which should be never thrown.");
        }
        length += 16;
        if (2 <= PostLh5Encoder.countNoZeroElement(codeFreq)) {
            int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq(codeLen);
            int[] codeLenLen = StaticHuffman.FreqListToLenList(codeLenFreq);
            if (2 <= PostLh5Encoder.countNoZeroElement(codeLenFreq)) {
                length += PostLh5Encoder.calcCodeLenLen(codeLenLen);
            } else {
                length += 5;
                length += 5;
            }
            length += PostLh5Encoder.calcCodeLen(codeLen, codeLenLen);
        } else {
            length += 10;
            length += 18;
        }
        if (2 <= PostLh5Encoder.countNoZeroElement(offLenFreq)) {
            length += PostLh5Encoder.calcOffLenLen(DictionarySize, offLenLen);
        } else {
            int len = Bits.len(Bits.len(DictionarySize));
            length += len;
            length += len;
        }
        for (i = 0; i < codeFreq.length; ++i) {
            length += codeFreq[i] * codeLen[i];
        }
        for (i = 0; i < offLenFreq.length; ++i) {
            length += offLenFreq[i] * (offLenLen[i] + i - 1);
        }
        return length;
    }

    private static int calcCodeLenLen(int[] codeLenLen) {
        int end;
        int length = 0;
        for (end = codeLenLen.length; 0 < end && codeLenLen[end - 1] == 0; --end) {
        }
        length += 5;
        int index = 0;
        while (index < end) {
            int len;
            length = (len = codeLenLen[index++]) <= 6 ? (length += len) : (length += len - 3);
            if (index != 3) continue;
            while (codeLenLen[index] == 0 && index < 6) {
                ++index;
            }
            length += 2;
        }
        return length;
    }

    private static int calcCodeLen(int[] codeLen, int[] codeLenLen) {
        int end;
        int length = 0;
        for (end = codeLen.length; 0 < end && codeLen[end - 1] == 0; --end) {
        }
        length += 9;
        int index = 0;
        while (index < end) {
            int len;
            if (0 < (len = codeLen[index++])) {
                length += codeLenLen[len + 2];
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                for (int i = 0; i < count; ++i) {
                    length += codeLenLen[0];
                }
                continue;
            }
            if (count <= 18) {
                length += codeLenLen[1];
                length += 4;
                continue;
            }
            if (count == 19) {
                length += codeLenLen[0];
                length += codeLenLen[1];
                length += 4;
                continue;
            }
            length += codeLenLen[2];
            length += 9;
        }
        return length;
    }

    private static int calcOffLenLen(int DictionarySize, int[] offLenLen) {
        int end;
        int length = 0;
        for (end = offLenLen.length; 0 < end && offLenLen[end - 1] == 0; --end) {
        }
        length += Bits.len(Bits.len(DictionarySize));
        int index = 0;
        while (index < end) {
            int len;
            if ((len = offLenLen[index++]) <= 6) {
                length += 3;
                continue;
            }
            length += len - 3;
        }
        return length;
    }

    private static int[][] createGroup(int BlockNum, int DivideNum) {
        int[][] group = new int[(BlockNum + 1) * BlockNum / 2][];
        if (DivideNum == 0) {
            group[0] = new int[BlockNum];
            for (int i = 0; i < BlockNum; ++i) {
                group[0][i] = i;
            }
        } else if (2 < BlockNum && DivideNum == 1) {
            int index = 0;
            for (int size = BlockNum; 0 < size; --size) {
                int i;
                group[index] = new int[size];
                for (i = 0; i < size; ++i) {
                    group[index][i] = i;
                }
                if (size < BlockNum) {
                    group[index += BlockNum - size] = new int[size];
                    for (i = 0; i < size; ++i) {
                        group[index][i] = i + BlockNum - size;
                    }
                }
                ++index;
            }
        } else {
            int index = 0;
            for (int size = BlockNum; 0 < size; --size) {
                int start = 0;
                while (size + start <= BlockNum) {
                    group[index] = new int[size];
                    for (int i = 0; i < size; ++i) {
                        group[index][i] = start + i;
                    }
                    ++index;
                    ++start;
                }
            }
        }
        return group;
    }

    private static int[][] createPattern(int BlockNum, int DivideNum) {
        int index = 0;
        int patternNum = PostLh5Encoder.calcPatternNum(BlockNum, DivideNum);
        int[][] pattern = new int[patternNum][];
        for (int div = 0; div < Math.min(BlockNum, DivideNum + 1); ++div) {
            boolean more;
            int[] divPos = new int[div];
            for (int i = 0; i < divPos.length; ++i) {
                divPos[i] = i;
            }
            do {
                pattern[index] = new int[div + 1];
                int start = 0;
                for (int i = 0; i < divPos.length; ++i) {
                    int len = divPos[i] - start + 1;
                    int num = BlockNum - len;
                    pattern[index][i] = (num + 1) * num / 2 + start;
                    start += len;
                }
                int num = BlockNum - (BlockNum - start);
                pattern[index][divPos.length] = (num + 1) * num / 2 + start;
                ++index;
                more = false;
                int range = BlockNum - 2;
                for (int move = divPos.length - 1; 0 <= move && !more; --move) {
                    if (divPos[move] < range) {
                        int n = move;
                        divPos[n] = divPos[n] + 1;
                        if (move < divPos.length - 1) {
                            for (int i = move; i < divPos.length - 1; ++i) {
                                divPos[i + 1] = divPos[i] + 1;
                            }
                        }
                        more = true;
                    }
                    range = divPos[move] - 1;
                }
            } while (more);
        }
        return pattern;
    }

    private static int calcPatternNum(int BlockNum, int DivideNum) {
        int patternNum = 0;
        for (int div = 0; div <= DivideNum; ++div) {
            int count = div <= BlockNum / 2 ? div : BlockNum - 1 - div;
            int numerator = 1;
            for (int i = 1; i <= count; ++i) {
                numerator *= BlockNum - i;
            }
            int denominator = 1;
            for (int i = 1; i <= count; ++i) {
                denominator *= i;
            }
            patternNum += numerator / denominator;
        }
        return patternNum;
    }
}

