/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BitDataBrokenException;
import com.orangesignal.jlha.BitInputStream;
import com.orangesignal.jlha.Bits;
import com.orangesignal.jlha.PreLzssDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PreLzsDecoder
implements PreLzssDecoder {
    private static final int DICTIONARY_SIZE = 2048;
    private static final int MAX_MATCH = 17;
    private static final int THRESHOLD = 2;
    private static final int OffsetBits = Bits.len(2047);
    private static final int LengthBits = Bits.len(15);
    private BitInputStream in;
    private int position;
    private int matchOffset;
    private int matchLength;
    private int markPosition;
    private int markMatchOffset;
    private int markMatchLength;

    public PreLzsDecoder(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.in = in instanceof BitInputStream ? (BitInputStream)in : new BitInputStream(in);
        this.position = 0;
        this.matchOffset = 0;
        this.matchLength = 0;
    }

    @Override
    public int readCode() throws IOException {
        try {
            if (this.in.readBoolean()) {
                ++this.position;
                return this.in.readBits(8);
            }
            this.matchOffset = this.in.readBits(OffsetBits);
            this.matchLength = this.in.readBits(LengthBits);
            return this.matchLength | 0x100;
        }
        catch (BitDataBrokenException exception) {
            if (exception.getCause() instanceof EOFException) {
                throw (EOFException)exception.getCause();
            }
            throw exception;
        }
    }

    @Override
    public int readOffset() throws IOException {
        int offset = this.position - this.matchOffset - 1 - 17 & 0x7FF;
        this.position += this.matchLength + 2;
        return offset;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark((readLimit * 9 + 7) / 8 + 1);
        this.markPosition = this.position;
        this.markMatchOffset = this.matchOffset;
        this.markMatchLength = this.matchLength;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.position = this.markPosition;
        this.matchOffset = this.markMatchOffset;
        this.matchLength = this.markMatchLength;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 9 - 2, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public int getDictionarySize() {
        return 2048;
    }

    @Override
    public int getMaxMatch() {
        return 17;
    }

    @Override
    public int getThreshold() {
        return 2;
    }
}

