/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.block;

import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.block.OAbstractBlock;
import java.util.List;

public class OConsoleBlock
extends OAbstractBlock {
    protected String file;
    protected List<String> commands;
    protected OConsoleDatabaseApp console;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "{file:{optional:true,description:'Input filename with commands to execute'}}{commands:{optional:true,description:'Commands to execute in sequence as an array of strings'}}]}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("file")) {
            this.file = (String)iConfiguration.field("file");
        }
        if (iConfiguration.containsField("commands")) {
            this.commands = (List)iConfiguration.field("commands");
        }
        if (this.file == null && this.commands == null) {
            throw new OConfigurationException("file or commands are mandatory");
        }
        this.console = this.file != null ? new OConsoleDatabaseApp(new String[]{this.file}) : new OConsoleDatabaseApp(this.commands.toArray(new String[this.commands.size()]));
    }

    @Override
    public String getName() {
        return "console";
    }

    @Override
    public Object executeBlock() {
        return this.console.run();
    }
}

