/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.http;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLPlugin;
import com.orientechnologies.orient.etl.context.OETLContext;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.context.OETLMessageHandler;
import com.orientechnologies.orient.etl.http.OETLListener;
import com.orientechnologies.orient.etl.util.OMigrationConfigManager;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.orient.server.OServer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class OETLJob
implements Runnable {
    private final ODocument cfg;
    private OETLListener listener;
    public Status status;
    public PrintStream stream;
    private ByteArrayOutputStream baos;
    private OPluginMessageHandler messageHandler;
    private OServer currentServerInstance;

    public OETLJob(ODocument cfg, OServer currentServerInstance, OETLListener listener) {
        this.cfg = cfg;
        this.listener = listener;
        this.baos = new ByteArrayOutputStream();
        this.stream = new PrintStream(this.baos);
        this.currentServerInstance = currentServerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ODocument jsonConfig = new ODocument().fromJSON((String)this.cfg.field("jsonConfig"), "noMap");
        int logLevel = (Integer)this.cfg.field("logLevel");
        String configName = (String)this.cfg.field("configName");
        String outDBName = (String)this.cfg.field("outDBName");
        String outOrientGraphUri = this.currentServerInstance.getDatabaseDirectory() + outDBName;
        String dbURL = "plocal:" + outOrientGraphUri;
        ((ODocument)((ODocument)jsonConfig.field("loader")).field("orientdb")).field("dbURL", (Object)dbURL);
        this.status = Status.RUNNING;
        this.messageHandler = new OETLMessageHandler(this.stream, logLevel);
        OETLPlugin etlPlugin = new OETLPlugin();
        String outDBConfigPath = null;
        try {
            outDBConfigPath = OMigrationConfigManager.writeConfigurationInTargetDB(jsonConfig, outOrientGraphUri, configName);
        }
        catch (Exception e) {
            ((OETLContext)OETLContextWrapper.getInstance().getContext()).printExceptionMessage(e, "Impossible to write etl configuration in the specified path.", "error");
            ((OETLContext)OETLContextWrapper.getInstance().getContext()).printExceptionStackTrace(e, "error");
        }
        try {
            String finalJsonConfig = jsonConfig.toJSON("prettyPrint");
            etlPlugin.executeJob(finalJsonConfig, outDBConfigPath, this.messageHandler);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error during execution of job", (Throwable)e, new Object[0]);
        }
        OETLListener oETLListener = this.listener;
        synchronized (oETLListener) {
            this.status = Status.FINISHED;
            try {
                this.listener.wait(5000L);
                this.listener.onEnd(this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void validate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument status() {
        OETLListener oETLListener = this.listener;
        synchronized (oETLListener) {
            ODocument status = new ODocument();
            status.field("cfg", (Object)this.cfg);
            status.field("status", (Object)this.status);
            String lastBatchLog = "";
            if (this.messageHandler != null) {
                lastBatchLog = this.extractBatchLog();
            }
            status.field("log", (Object)lastBatchLog);
            if (this.status == Status.FINISHED) {
                this.listener.notifyAll();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractBatchLog() {
        String lastBatchLog = "Current status not correctly loaded.";
        OPluginMessageHandler oPluginMessageHandler = this.messageHandler;
        synchronized (oPluginMessageHandler) {
            int baosInitSize = this.baos.size();
            try {
                lastBatchLog = this.baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                OLogManager.instance().error((Object)this, "UTF-8 encoding is not supported", (Throwable)e, new Object[0]);
            }
            int baosFinalSize = this.baos.size();
            if (baosFinalSize - baosInitSize > 0) {
                OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "Losing some buffer info.");
            } else {
                this.baos.reset();
            }
        }
        return lastBatchLog;
    }

    public static enum Status {
        STARTED,
        RUNNING,
        FINISHED;

    }
}

