/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.source;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.source.OAbstractSource;
import com.orientechnologies.orient.etl.source.OSourceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;

public class OFileSource
extends OAbstractSource {
    protected String fileName;
    protected String path;
    protected boolean lockFile = false;
    protected long byteParsed = 0L;
    protected long byteToParse = -1L;
    protected long skipFirst = 0L;
    protected long skipLast = 0L;
    protected RandomAccessFile raf = null;
    protected FileChannel channel = null;
    protected InputStreamReader fileReader = null;
    protected FileInputStream fis = null;
    protected FileLock lock = null;
    private Charset encoding = Charset.forName("UTF-8");
    private File input;

    @Override
    public String getUnit() {
        return "bytes";
    }

    @Override
    public ODocument getConfiguration() {
        return null;
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("lock")) {
            this.lockFile = (Boolean)iConfiguration.field("lock");
        }
        if (iConfiguration.containsField("skipFirst")) {
            this.skipFirst = Long.parseLong((String)iConfiguration.field("skipFirst"));
        }
        if (iConfiguration.containsField("skipLast")) {
            this.skipLast = Long.parseLong((String)iConfiguration.field("skipLast"));
        }
        if (iConfiguration.containsField("encoding")) {
            this.encoding = Charset.forName((String)iConfiguration.field("encoding"));
        }
        this.path = (String)this.resolve(iConfiguration.field("path"));
        this.input = new File(this.path);
        if (!this.input.exists()) {
            throw new OSourceException("[File source] path '" + this.path + "' not exists");
        }
        this.fileName = this.input.getName();
        this.log(OETLProcessor.LOG_LEVELS.INFO, "Load from file " + this.path, new Object[0]);
    }

    @Override
    public void end() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fileReader != null) {
            try {
                this.fileReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return "file";
    }

    @Override
    public void begin() {
        try {
            String fileMode = this.lockFile ? "rw" : "r";
            this.raf = new RandomAccessFile(this.input, fileMode);
            this.channel = this.raf.getChannel();
            this.fis = new FileInputStream(this.input);
            if (this.fileName.endsWith(".gz")) {
                this.fileReader = new InputStreamReader((InputStream)new GZIPInputStream(this.fis), this.encoding);
            } else {
                this.fileReader = new InputStreamReader((InputStream)new FileInputStream(this.input), this.encoding);
                this.byteToParse = this.input.length();
            }
        }
        catch (Exception e) {
            this.end();
        }
        this.byteParsed = 0L;
        if (this.lockFile) {
            try {
                this.lock = this.channel.lock();
            }
            catch (IOException e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on locking file: %s", new Object[]{e, this.fileName});
            }
        }
        this.log(OETLProcessor.LOG_LEVELS.INFO, "Reading from file " + this.path + " with encoding " + this.encoding.displayName(), new Object[0]);
    }

    public boolean isClosed() {
        return this.fileReader != null;
    }

    public Reader getFileReader() {
        return this.fileReader;
    }

    @Override
    public Reader read() {
        return this.fileReader;
    }
}

