/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public abstract class OAbstractLookupTransformer
extends OAbstractTransformer {
    protected String joinFieldName;
    protected Object joinValue;
    protected String lookup;
    protected ACTION unresolvedLinkAction = ACTION.NOTHING;
    private OSQLQuery<ODocument> sqlQuery;
    private OIndex<?> index;

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.joinFieldName = (String)iConfiguration.field("joinFieldName");
        if (iConfiguration.containsField("joinValue")) {
            this.joinValue = iConfiguration.field("joinValue");
        }
        if (iConfiguration.containsField("lookup")) {
            this.lookup = (String)iConfiguration.field("lookup");
        }
        if (iConfiguration.containsField("unresolvedLinkAction")) {
            this.unresolvedLinkAction = ACTION.valueOf(iConfiguration.field("unresolvedLinkAction").toString().toUpperCase(Locale.ENGLISH));
        }
    }

    protected Object lookup(Object joinValue, boolean iReturnRIDS) {
        ArrayList<Object> result = null;
        if (joinValue != null) {
            if (this.sqlQuery == null && this.index == null) {
                if (this.lookup.toUpperCase(Locale.ENGLISH).startsWith("SELECT")) {
                    this.sqlQuery = new OSQLSynchQuery(this.lookup);
                } else {
                    this.index = this.pipeline.getDocumentDatabase().getMetadata().getIndexManager().getIndex(this.lookup);
                    if (this.index == null) {
                        OETLContextWrapper.getInstance().getMessageHandler().warn((Object)this, "WARNING: index %s not found. Lookups could be really slow", new Object[]{this.lookup});
                        String[] parts = this.lookup.split("\\.");
                        this.sqlQuery = new OSQLSynchQuery("SELECT FROM " + parts[0] + " WHERE " + parts[1] + " = ?");
                    }
                }
            }
            if (this.index != null) {
                OType idxFieldType = this.index.getDefinition().getTypes()[0];
                joinValue = OType.convert((Object)joinValue, (Class)idxFieldType.getDefaultJavaType());
                result = this.index.get(joinValue);
            } else {
                if (this.sqlQuery instanceof OSQLSynchQuery) {
                    ((OSQLSynchQuery)this.sqlQuery).resetPagination();
                }
                result = this.pipeline.getDocumentDatabase().query(this.sqlQuery, new Object[]{joinValue});
            }
            if (result != null && result instanceof Collection) {
                Collection coll = result;
                if (!coll.isEmpty()) {
                    if (iReturnRIDS) {
                        ArrayList<ORID> resultRIDs = new ArrayList<ORID>(coll.size());
                        for (Object o : coll) {
                            if (!(o instanceof OIdentifiable)) continue;
                            resultRIDs.add(((OIdentifiable)o).getIdentity());
                        }
                        result = resultRIDs;
                    }
                } else {
                    result = null;
                }
            } else if (result instanceof OIdentifiable) {
                result = iReturnRIDS ? ((OIdentifiable)result).getIdentity() : ((OIdentifiable)result).getRecord();
            }
        }
        return result;
    }

    protected static enum ACTION {
        NOTHING,
        WARNING,
        ERROR,
        HALT,
        SKIP,
        CREATE;

    }
}

