/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractLookupTransformer;
import com.orientechnologies.orient.etl.transformer.OTransformException;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.List;

public class OEdgeTransformer
extends OAbstractLookupTransformer {
    private String edgeClass = "E";
    private boolean directionOut = true;
    private ODocument targetVertexFields;
    private ODocument edgeFields;
    private boolean skipDuplicates = false;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{joinValue:{optional:true,description:'value to use for join'}},{joinFieldName:{optional:true,description:'field name containing the value to join'}},{lookup:{optional:false,description:'<Class>.<property> or Query to execute'}},{direction:{optional:true,description:'Direction between 'in' and 'out'. Default is 'out''}},{class:{optional:true,description:'Edge class name. Default is 'E''}},{targetVertexFields:{optional:true,description:'Map of fields to set in target vertex. Use ${$input.<field>} to get input field values'}},{edgeFields:{optional:true,description:'Map of fields to set in edge. Use ${$input.<field>} to get input field values'}},{skipDuplicates:{optional:true,description:'Duplicated edges (with a composite index built on both out and in properties) are skipped', default:false}},{unresolvedLinkAction:{optional:true,description:'action when the target vertex is not found',values:" + this.stringArray2Json((Object[])OAbstractLookupTransformer.ACTION.values()) + "}}],input:['ODocument','OrientVertex'],output:'OrientVertex'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.edgeClass = (String)iConfiguration.field("class");
        if (iConfiguration.containsField("direction")) {
            String direction = (String)iConfiguration.field("direction");
            if ("out".equalsIgnoreCase(direction)) {
                this.directionOut = true;
            } else if ("in".equalsIgnoreCase(direction)) {
                this.directionOut = false;
            } else {
                throw new OConfigurationException("Direction can be 'in' or 'out', but found: " + direction);
            }
        }
        if (iConfiguration.containsField("targetVertexFields")) {
            this.targetVertexFields = (ODocument)iConfiguration.field("targetVertexFields");
        }
        if (iConfiguration.containsField("edgeFields")) {
            this.edgeFields = (ODocument)iConfiguration.field("edgeFields");
        }
        if (iConfiguration.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)this.resolve(iConfiguration.field("skipDuplicates"));
        }
    }

    @Override
    public String getName() {
        return "edge";
    }

    @Override
    public void begin() {
        OrientEdgeType cls = this.pipeline.getGraphDatabase().getEdgeType(this.edgeClass);
        if (cls == null) {
            this.pipeline.getGraphDatabase().createEdgeType(this.edgeClass);
        }
        super.begin();
    }

    @Override
    public Object executeTransform(Object input) {
        for (Object o : OMultiValue.getMultiValueIterable((Object)input)) {
            Object joinCurrentValue;
            OrientVertex vertex;
            if (o instanceof OrientVertex) {
                vertex = (OrientVertex)o;
            } else if (o instanceof OIdentifiable) {
                vertex = this.pipeline.getGraphDatabase().getVertex(o);
            } else {
                throw new OTransformException(this.getName() + ": input type '" + o + "' is not supported");
            }
            Object object = joinCurrentValue = this.joinValue != null ? this.joinValue : vertex.getProperty(this.joinFieldName);
            if (OMultiValue.isMultiValue((Object)joinCurrentValue)) {
                for (Object ob : OMultiValue.getMultiValueIterable((Object)joinCurrentValue)) {
                    Object r;
                    if (this.createEdge(vertex, ob, r = this.lookup(ob, true)) != null || this.unresolvedLinkAction != OAbstractLookupTransformer.ACTION.SKIP) continue;
                    return null;
                }
                continue;
            }
            Object result = this.lookup(joinCurrentValue, true);
            if (this.createEdge(vertex, joinCurrentValue, result) != null || this.unresolvedLinkAction != OAbstractLookupTransformer.ACTION.SKIP) continue;
            return null;
        }
        return input;
    }

    private List<OrientEdge> createEdge(OrientVertex vertex, Object joinCurrentValue, Object result) {
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "joinCurrentValue=%s, lookupResult=%s", joinCurrentValue, result);
        if (result == null) {
            switch (this.unresolvedLinkAction) {
                case CREATE: {
                    if (joinCurrentValue == null) break;
                    if (this.lookup != null) {
                        String[] lookupParts = this.lookup.split("\\.");
                        OrientVertex linkedV = this.pipeline.getGraphDatabase().addTemporaryVertex(lookupParts[0], new Object[0]);
                        linkedV.setProperty(lookupParts[1], joinCurrentValue);
                        if (this.targetVertexFields != null) {
                            for (String f : this.targetVertexFields.fieldNames()) {
                                linkedV.setProperty(f, this.resolve(this.targetVertexFields.field(f)));
                            }
                        }
                        linkedV.save();
                        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "created new vertex=%s", linkedV.getRecord());
                        result = linkedV.getIdentity();
                        break;
                    }
                    throw new OConfigurationException("Cannot create linked document because target class is unknown. Use 'lookup' field");
                }
                case ERROR: {
                    this.processor.getStats().incrementErrors();
                    this.log(OETLProcessor.LOG_LEVELS.ERROR, "%s: ERROR Cannot resolve join for value '%s'", this.getName(), joinCurrentValue);
                    break;
                }
                case WARNING: {
                    this.processor.getStats().incrementWarnings();
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "%s: WARN Cannot resolve join for value '%s'", this.getName(), joinCurrentValue);
                    break;
                }
                case SKIP: {
                    return null;
                }
                case HALT: {
                    throw new OETLProcessHaltedException("Cannot resolve join for value '" + joinCurrentValue + "'");
                }
                default: {
                    return null;
                }
            }
        }
        if (result != null) {
            ArrayList<OrientEdge> edges;
            if (OMultiValue.isMultiValue((Object)result)) {
                int size = OMultiValue.getSize((Object)result);
                if (size == 0) {
                    return null;
                }
                edges = new ArrayList(size);
            } else {
                edges = new ArrayList<OrientEdge>(1);
            }
            for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                OIdentifiable oid = (OIdentifiable)o;
                OrientVertex targetVertex = this.pipeline.getGraphDatabase().getVertex((Object)oid);
                try {
                    OrientEdge edge = this.directionOut ? (OrientEdge)vertex.addEdge(this.edgeClass, (Vertex)targetVertex) : (OrientEdge)targetVertex.addEdge(this.edgeClass, (Vertex)vertex);
                    if (this.edgeFields != null) {
                        for (String f : this.edgeFields.fieldNames()) {
                            edge.setProperty(f, this.resolve(this.edgeFields.field(f)));
                        }
                    }
                    edges.add(edge);
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "created new edge=%s", edge);
                }
                catch (ORecordDuplicatedException e) {
                    if (this.skipDuplicates) {
                        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "skipped creation of new edge because already exists", new Object[0]);
                        continue;
                    }
                    this.log(OETLProcessor.LOG_LEVELS.ERROR, "error on creation of new edge because it already exists (skipDuplicates=false)", new Object[0]);
                    throw e;
                }
            }
            return edges;
        }
        return null;
    }
}

