/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GeoProjectionUtils;
import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    private static final short MIN_LON = -180;
    private static final short MIN_LAT = -90;
    public static final short BITS = 32;
    private static final double LON_SCALE = 1.1930464708333334E7;
    private static final double LAT_SCALE = 2.3860929416666668E7;
    public static final double TOLERANCE = 1.0E-6;
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;

    private GeoUtils() {
    }

    public static Long mortonHash(double lon, double lat) {
        return BitUtil.interleave((long)GeoUtils.scaleLon(lon), (long)GeoUtils.scaleLat(lat));
    }

    public static double mortonUnhashLon(long hash) {
        return GeoUtils.unscaleLon(BitUtil.deinterleave((long)hash));
    }

    public static double mortonUnhashLat(long hash) {
        return GeoUtils.unscaleLat(BitUtil.deinterleave((long)(hash >>> 1)));
    }

    private static long scaleLon(double val) {
        return (long)((val - -180.0) * 1.1930464708333334E7);
    }

    private static long scaleLat(double val) {
        return (long)((val - -90.0) * 2.3860929416666668E7);
    }

    private static double unscaleLon(long val) {
        return (double)val / 1.1930464708333334E7 + -180.0;
    }

    private static double unscaleLat(long val) {
        return (double)val / 2.3860929416666668E7 + -90.0;
    }

    public static double compare(double v1, double v2) {
        double compare = v1 - v2;
        return Math.abs(compare) <= 1.0E-6 ? 0.0 : compare;
    }

    public static double normalizeLon(double lon_deg) {
        if (lon_deg >= -180.0 && lon_deg <= 180.0) {
            return lon_deg;
        }
        double off = (lon_deg + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && lon_deg > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }

    public static double normalizeLat(double lat_deg) {
        if (lat_deg >= -90.0 && lat_deg <= 90.0) {
            return lat_deg;
        }
        double off = Math.abs((lat_deg + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    public static final boolean bboxContains(double lon, double lat, double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.compare(lon, minLon) >= 0.0 && GeoUtils.compare(lon, maxLon) <= 0.0 && GeoUtils.compare(lat, minLat) >= 0.0 && GeoUtils.compare(lat, maxLat) <= 0.0;
    }

    public static boolean pointInPolygon(double[] x, double[] y, double lat, double lon) {
        assert (x.length == y.length);
        boolean inPoly = false;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < lon && x[i - 1] >= lon) && (!(x[i - 1] < lon) || !(x[i] >= lon)) || !(y[i] + (lon - x[i]) / (x[i - 1] - x[i]) * (y[i - 1] - y[i]) < lat)) continue;
            inPoly = !inPoly;
        }
        return inPoly;
    }

    public static String geoTermToString(long term) {
        StringBuilder s = new StringBuilder(64);
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(term);
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            s.append('0');
        }
        if (term != 0L) {
            s.append(Long.toBinaryString(term));
        }
        return s.toString();
    }

    public static boolean rectDisjoint(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public static boolean rectWithin(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMinX < bMinX || aMinY < bMinY || aMaxX > bMaxX || aMaxY > bMaxY);
    }

    public static boolean rectCrosses(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !GeoUtils.rectDisjoint(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY) && !GeoUtils.rectWithin(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY);
    }

    public static boolean rectContains(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(bMinX < aMinX || bMinY < aMinY || bMaxX > aMaxX || bMaxY > aMaxY);
    }

    public static boolean rectIntersects(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY);
    }

    public static boolean rectCrossesPoly(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        if (GeoUtils.rectDisjoint(rMinX, rMinY, rMaxX, rMaxY, sMinX, sMinY, sMaxX, sMaxY)) {
            return false;
        }
        double[][] bbox = new double[][]{{rMinX, rMinY}, {rMaxX, rMinY}, {rMaxX, rMaxY}, {rMinX, rMaxY}, {rMinX, rMinY}};
        int polyLength = shapeX.length - 1;
        for (int b = 0; b < 4; b = (int)((short)(b + 1))) {
            double a1 = bbox[b + 1][1] - bbox[b][1];
            double b1 = bbox[b][0] - bbox[b + 1][0];
            double c1 = a1 * bbox[b + 1][0] + b1 * bbox[b + 1][1];
            for (int p = 0; p < polyLength; ++p) {
                boolean touching;
                double b2 = shapeX[p] - shapeX[p + 1];
                double a2 = shapeY[p + 1] - shapeY[p];
                double d = a1 * b2 - a2 * b1;
                if (d == 0.0) continue;
                double c2 = a2 * shapeX[p + 1] + b2 * shapeY[p + 1];
                double s = 1.0 / d * (b2 * c1 - b1 * c2);
                double t = 1.0 / d * (a1 * c2 - a2 * c1);
                double x00 = StrictMath.min(bbox[b][0], bbox[b + 1][0]) - 1.0E-6;
                double x01 = StrictMath.max(bbox[b][0], bbox[b + 1][0]) + 1.0E-6;
                double y00 = StrictMath.min(bbox[b][1], bbox[b + 1][1]) - 1.0E-6;
                double y01 = StrictMath.max(bbox[b][1], bbox[b + 1][1]) + 1.0E-6;
                double x10 = StrictMath.min(shapeX[p], shapeX[p + 1]) - 1.0E-6;
                double x11 = StrictMath.max(shapeX[p], shapeX[p + 1]) + 1.0E-6;
                double y10 = StrictMath.min(shapeY[p], shapeY[p + 1]) - 1.0E-6;
                double y11 = StrictMath.max(shapeY[p], shapeY[p + 1]) + 1.0E-6;
                boolean bl = touching = x00 == s && y00 == t || x01 == s && y01 == t || x10 == s && y10 == t || x11 == s && y11 == t;
                if (touching || x00 > s || x01 < s || y00 > t || y01 < t || x10 > s || x11 < s || y10 > t || y11 < t) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList<double[]> circleToPoly(double lon, double lat, double radius) {
        int sides = 25;
        ArrayList<double[]> geometry = new ArrayList<double[]>();
        double[] lons = new double[25];
        double[] lats = new double[25];
        double[] pt = new double[2];
        int sidesLen = 24;
        for (int i = 0; i < 24; ++i) {
            double angle = i * 360 / 25;
            pt = GeoProjectionUtils.pointFromLonLatBearing(lon, lat, angle, radius, pt);
            lons[i] = pt[0];
            lats[i] = pt[1];
        }
        lons[24] = lons[0];
        lats[24] = lats[0];
        geometry.add(lons);
        geometry.add(lats);
        return geometry;
    }

    public static boolean rectWithinPoly(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        return !GeoUtils.rectCrossesPoly(rMinX, rMinY, rMaxX, rMaxY, shapeX, shapeY, sMinX, sMinY, sMaxX, sMaxY) && GeoUtils.pointInPolygon(shapeX, shapeY, rMinY, rMinX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMinY, rMaxX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMaxX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMinX);
    }

    private static boolean rectAnyCornersOutsideCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radius) {
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMinX) * 1000.0 > radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMinX) * 1000.0 > radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMaxX) * 1000.0 > radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMaxX) * 1000.0 > radius;
    }

    private static boolean rectAnyCornersInCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radius) {
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMinX) * 1000.0 <= radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMinX) * 1000.0 <= radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMaxX) * 1000.0 <= radius || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMaxX) * 1000.0 <= radius;
    }

    public static boolean rectWithinCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radius) {
        return !GeoUtils.rectAnyCornersOutsideCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radius);
    }

    public static boolean rectCrossesCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radius) {
        return GeoUtils.rectAnyCornersInCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radius) || GeoUtils.lineCrossesSphere(rMinX, rMinY, 0.0, rMaxX, rMinY, 0.0, centerLon, centerLat, 0.0, radius) || GeoUtils.lineCrossesSphere(rMaxX, rMinY, 0.0, rMaxX, rMaxY, 0.0, centerLon, centerLat, 0.0, radius) || GeoUtils.lineCrossesSphere(rMaxX, rMaxY, 0.0, rMinX, rMaxY, 0.0, centerLon, centerLat, 0.0, radius) || GeoUtils.lineCrossesSphere(rMinX, rMaxY, 0.0, rMinX, rMinY, 0.0, centerLon, centerLat, 0.0, radius);
    }

    public static boolean circleWithinRect(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radius) {
        return !(centerLon < rMinX || centerLon > rMaxX || centerLat > rMaxY || centerLat < rMinY || SloppyMath.haversin((double)rMinY, (double)centerLon, (double)centerLat, (double)centerLon) < radius || SloppyMath.haversin((double)rMaxY, (double)centerLon, (double)centerLat, (double)centerLon) < radius || SloppyMath.haversin((double)centerLat, (double)rMinX, (double)centerLat, (double)centerLon) < radius || SloppyMath.haversin((double)centerLat, (double)rMaxX, (double)centerLat, (double)centerLon) < radius);
    }

    private static boolean lineCrossesSphere(double lon1, double lat1, double alt1, double lon2, double lat2, double alt2, double centerLon, double centerLat, double centerAlt, double radius) {
        double c;
        double a;
        double dZ;
        double fZ;
        double dY;
        double fY;
        double dX;
        double[] ecf1 = GeoProjectionUtils.llaToECF(lon1, lat1, alt1, null);
        double[] ecf2 = GeoProjectionUtils.llaToECF(lon2, lat2, alt2, null);
        double[] cntr = GeoProjectionUtils.llaToECF(centerLon, centerLat, centerAlt, null);
        double fX = ecf1[0] - cntr[0];
        double b = 2.0 * (fX * (dX = ecf2[0] - ecf1[0]) + (fY = ecf1[1] - cntr[1]) * (dY = ecf2[1] - ecf1[1]) + (fZ = ecf1[2] - cntr[2]) * (dZ = ecf2[2] - ecf1[2]));
        double discrim = b * b - 4.0 * (a = dX * dX + dY * dY + dZ * dZ) * (c = fX * fX + fY * fY + fZ * fZ - radius * radius);
        if (discrim < 0.0) {
            return false;
        }
        discrim = StrictMath.sqrt(discrim);
        double a2 = 2.0 * a;
        double t1 = (-b - discrim) / a2;
        double t2 = (-b + discrim) / a2;
        if (t1 < 0.0 || t1 > 1.0) {
            return !(t2 < 0.0) && !(t2 > 1.0);
        }
        return true;
    }

    public static boolean isValidLat(double lat) {
        return !Double.isNaN(lat) && lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return !Double.isNaN(lon) && lon >= -180.0 && lon <= 180.0;
    }
}

