/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.IOOutOfMemoryHandler;
import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.internal.networking.spinning.AbstractHandler;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.nio.ByteBuffer;

public class SpinningSocketReader
extends AbstractHandler
implements SocketReader {
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final SocketReaderInitializer initializer;
    private volatile long lastReadTime;
    private ReadHandler readHandler;
    private ByteBuffer inputBuffer;
    private final ByteBuffer protocolBuffer = ByteBuffer.allocate(3);

    public SpinningSocketReader(SocketConnection connection, ILogger logger, IOOutOfMemoryHandler oomeHandler, SocketReaderInitializer initializer) {
        super(connection, logger, oomeHandler);
        this.initializer = initializer;
    }

    @Override
    public ByteBuffer getProtocolBuffer() {
        return this.protocolBuffer;
    }

    @Override
    public void initInputBuffer(ByteBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    @Override
    public void initReadHandler(ReadHandler readHandler) {
        this.readHandler = readHandler;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    @Override
    public SwCounter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    @Override
    public SwCounter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }

    public void read() throws Exception {
        int readBytes;
        if (!this.connection.isAlive()) {
            this.socketChannel.closeInbound();
            return;
        }
        if (this.readHandler == null) {
            this.initializer.init(this.connection, this);
            if (this.readHandler == null) {
                return;
            }
        }
        if ((readBytes = this.socketChannel.read(this.inputBuffer)) <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.lastReadTime = System.currentTimeMillis();
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.readHandler.onRead(this.inputBuffer);
        if (this.inputBuffer.hasRemaining()) {
            this.inputBuffer.compact();
        } else {
            this.inputBuffer.clear();
        }
    }
}

