/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.NullQueryCache;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheEndToEndProvider<K, V> {
    private static final int MUTEX_COUNT = 16;
    private static final int MASK = 15;
    private final ConstructorFunction<String, ConcurrentMap<String, InternalQueryCache<K, V>>> constructorFunction = new ConstructorFunction<String, ConcurrentMap<String, InternalQueryCache<K, V>>>(){

        @Override
        public ConcurrentMap<String, InternalQueryCache<K, V>> createNew(String arg) {
            return new ConcurrentHashMap();
        }
    };
    private final Object[] mutexes = this.createMutexes();
    private final ConcurrentMap<String, ConcurrentMap<String, InternalQueryCache<K, V>>> queryCaches = new ConcurrentHashMap<String, ConcurrentMap<String, InternalQueryCache<K, V>>>();

    private Object[] createMutexes() {
        Object[] mutexes = new Object[16];
        for (int i = 0; i < 16; ++i) {
            mutexes[i] = new Object();
        }
        return mutexes;
    }

    private Object getMutex(String name) {
        int hashCode = name.hashCode();
        if (hashCode == Integer.MIN_VALUE) {
            hashCode = 0;
        }
        hashCode = Math.abs(hashCode);
        return this.mutexes[hashCode & 0xF];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalQueryCache<K, V> getOrCreateQueryCache(String mapName, String cacheName, ConstructorFunction<String, InternalQueryCache<K, V>> constructor) {
        Object mutex;
        ConcurrentMap<String, InternalQueryCache<K, V>> queryCachesOfMap = ConcurrencyUtil.getOrPutIfAbsent(this.queryCaches, mapName, this.constructorFunction);
        Object object = mutex = this.getMutex(cacheName);
        synchronized (object) {
            InternalQueryCache<K, V> cache = ConcurrencyUtil.getOrPutSynchronized(queryCachesOfMap, cacheName, mutex, constructor);
            if (cache == NullQueryCache.NULL_QUERY_CACHE) {
                this.remove(mapName, cacheName);
                return null;
            }
            return cache;
        }
    }

    public InternalQueryCache<K, V> remove(String mapName, String cacheName) {
        ConcurrentMap queryCachesOfMap = (ConcurrentMap)this.queryCaches.get(mapName);
        return (InternalQueryCache)queryCachesOfMap.remove(cacheName);
    }
}

