/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverEventListener;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OGraphRepair {
    private OStorageRecoverEventListener eventListener;

    public void repair(OrientBaseGraph graph, OCommandOutputListener outputListener, Map<String, List<String>> options) {
        this.message(outputListener, "Repair of graph '" + graph.getRawGraph().getURL() + "' is started ...\n");
        long beginTime = System.currentTimeMillis();
        ORepairStats stats = new ORepairStats();
        this.repairEdges(graph, stats, outputListener, options, false);
        this.repairVertices(graph, stats, outputListener, options, false);
        this.message(outputListener, "Repair of graph '" + graph.getRawGraph().getURL() + "' completed in " + (System.currentTimeMillis() - beginTime) / 1000L + " secs\n");
        this.message(outputListener, " scannedEdges.....: " + stats.scannedEdges + "\n");
        this.message(outputListener, " removedEdges.....: " + stats.removedEdges + "\n");
        this.message(outputListener, " scannedVertices..: " + stats.scannedVertices + "\n");
        this.message(outputListener, " scannedLinks.....: " + stats.scannedLinks + "\n");
        this.message(outputListener, " removedLinks.....: " + stats.removedLinks + "\n");
        this.message(outputListener, " repairedVertices.: " + stats.repairedVertices + "\n");
    }

    public void check(OrientBaseGraph graph, OCommandOutputListener outputListener, Map<String, List<String>> options) {
        this.message(outputListener, "Check of graph '" + graph.getRawGraph().getURL() + "' is started...\n");
        long beginTime = System.currentTimeMillis();
        ORepairStats stats = new ORepairStats();
        this.repairEdges(graph, stats, outputListener, options, true);
        this.repairVertices(graph, stats, outputListener, options, true);
        this.message(outputListener, "Check of graph '" + graph.getRawGraph().getURL() + "' completed in " + (System.currentTimeMillis() - beginTime) / 1000L + " secs\n");
        this.message(outputListener, " scannedEdges.....: " + stats.scannedEdges + "\n");
        this.message(outputListener, " edgesToRemove....: " + stats.removedEdges + "\n");
        this.message(outputListener, " scannedVertices..: " + stats.scannedVertices + "\n");
        this.message(outputListener, " scannedLinks.....: " + stats.scannedLinks + "\n");
        this.message(outputListener, " linksToRemove....: " + stats.removedLinks + "\n");
        this.message(outputListener, " verticesToRepair.: " + stats.repairedVertices + "\n");
    }

    protected void repairEdges(OrientBaseGraph graph, ORepairStats stats, OCommandOutputListener outputListener, Map<String, List<String>> options, boolean checkOnly) {
        ODatabaseDocumentTx db = graph.getRawGraph();
        OMetadataDefault metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OrientConfigurableGraph.Settings settings = graph.settings;
        boolean useVertexFieldsForEdgeLabels = settings.isUseVertexFieldsForEdgeLabels();
        OClass edgeClass = schema.getClass("E");
        if (edgeClass != null) {
            long countEdges = db.countClass(edgeClass.getName());
            long skipEdges = 0L;
            if (options != null && options.get("-skipEdges") != null) {
                skipEdges = Long.parseLong(options.get("-skipEdges").get(0));
            }
            this.message(outputListener, "Scanning " + countEdges + " edges (skipEdges=" + skipEdges + ")...\n");
            long parsedEdges = 0L;
            long beginTime = System.currentTimeMillis();
            for (ODocument edge : db.browseClass(edgeClass.getName())) {
                ORID edgeId = edge.getIdentity();
                if (skipEdges > 0L && ++parsedEdges <= skipEdges) continue;
                ++stats.scannedEdges;
                if (this.eventListener != null) {
                    this.eventListener.onScannedEdge(edge);
                }
                if (outputListener != null && stats.scannedEdges % 100000L == 0L) {
                    long speedPerSecond = (long)((double)parsedEdges / ((double)(System.currentTimeMillis() - beginTime) / 1000.0));
                    if (speedPerSecond < 1L) {
                        speedPerSecond = 1L;
                    }
                    long remaining = (countEdges - parsedEdges) / speedPerSecond;
                    this.message(outputListener, "+ edges: scanned " + stats.scannedEdges + ", removed " + stats.removedEdges + " (estimated remaining time " + remaining + " secs)\n");
                }
                boolean outVertexMissing = false;
                String removalReason = "";
                OIdentifiable out = OrientEdge.getConnection(edge, Direction.OUT);
                if (out == null) {
                    outVertexMissing = true;
                } else {
                    ODocument outVertex;
                    try {
                        outVertex = (ODocument)out.getRecord();
                    }
                    catch (ORecordNotFoundException e) {
                        outVertex = null;
                    }
                    if (outVertex == null) {
                        outVertexMissing = true;
                    } else {
                        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edge.getClassName(), useVertexFieldsForEdgeLabels);
                        Object outEdges = outVertex.field(outFieldName);
                        if (outEdges == null) {
                            outVertexMissing = true;
                        } else if (outEdges instanceof ORidBag) {
                            if (!((ORidBag)outEdges).contains((OIdentifiable)edgeId)) {
                                outVertexMissing = true;
                            }
                        } else if (outEdges instanceof Collection) {
                            if (!((Collection)outEdges).contains(edgeId)) {
                                outVertexMissing = true;
                            }
                        } else if (outEdges instanceof OIdentifiable && ((OIdentifiable)outEdges).getIdentity().equals(edgeId)) {
                            outVertexMissing = true;
                        }
                    }
                }
                if (outVertexMissing) {
                    removalReason = "outgoing vertex (" + out + ") does not contain the edge";
                }
                boolean inVertexMissing = false;
                OIdentifiable in = OrientEdge.getConnection(edge, Direction.IN);
                if (in == null) {
                    inVertexMissing = true;
                } else {
                    ODocument inVertex;
                    try {
                        inVertex = (ODocument)in.getRecord();
                    }
                    catch (ORecordNotFoundException e) {
                        inVertex = null;
                    }
                    if (inVertex == null) {
                        inVertexMissing = true;
                    } else {
                        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edge.getClassName(), useVertexFieldsForEdgeLabels);
                        Object inEdges = inVertex.field(inFieldName);
                        if (inEdges == null) {
                            inVertexMissing = true;
                        } else if (inEdges instanceof ORidBag) {
                            if (!((ORidBag)inEdges).contains((OIdentifiable)edgeId)) {
                                inVertexMissing = true;
                            }
                        } else if (inEdges instanceof Collection) {
                            if (!((Collection)inEdges).contains(edgeId)) {
                                inVertexMissing = true;
                            }
                        } else if (inEdges instanceof OIdentifiable && ((OIdentifiable)inEdges).getIdentity().equals(edgeId)) {
                            inVertexMissing = true;
                        }
                    }
                }
                if (inVertexMissing) {
                    if (!removalReason.isEmpty()) {
                        removalReason = removalReason + ", ";
                    }
                    removalReason = removalReason + "incoming vertex (" + in + ") does not contain the edge";
                }
                if (!outVertexMissing && !inVertexMissing) continue;
                try {
                    if (!checkOnly) {
                        this.message(outputListener, "+ deleting corrupted edge " + edge + " because " + removalReason + "\n");
                        edge.delete();
                    } else {
                        this.message(outputListener, "+ found corrupted edge " + edge + " because " + removalReason + "\n");
                    }
                    ++stats.removedEdges;
                    if (this.eventListener == null) continue;
                    this.eventListener.onRemovedEdge(edge);
                }
                catch (Exception e) {
                    this.message(outputListener, "Error on deleting edge " + edge.getIdentity() + " (" + e.getMessage() + ")");
                }
            }
            this.message(outputListener, "Scanning edges completed\n");
        }
    }

    protected void repairVertices(OrientBaseGraph graph, ORepairStats stats, OCommandOutputListener outputListener, Map<String, List<String>> options, boolean checkOnly) {
        ODatabaseDocumentTx db = graph.getRawGraph();
        OMetadataDefault metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OClass vertexClass = schema.getClass("V");
        if (vertexClass != null) {
            long countVertices = db.countClass(vertexClass.getName());
            long skipVertices = 0L;
            if (options != null && options.get("-skipVertices") != null) {
                skipVertices = Long.parseLong(options.get("-skipVertices").get(0));
            }
            this.message(outputListener, "Scanning " + countVertices + " vertices...\n");
            long parsedVertices = 0L;
            long beginTime = System.currentTimeMillis();
            for (ODocument vertex : db.browseClass(vertexClass.getName())) {
                if (skipVertices > 0L && ++parsedVertices <= skipVertices) continue;
                ++stats.scannedVertices;
                if (this.eventListener != null) {
                    this.eventListener.onScannedVertex(vertex);
                }
                if (outputListener != null && stats.scannedVertices % 100000L == 0L) {
                    long speedPerSecond = (long)((double)parsedVertices / ((double)(System.currentTimeMillis() - beginTime) / 1000.0));
                    if (speedPerSecond < 1L) {
                        speedPerSecond = 1L;
                    }
                    long remaining = (countVertices - parsedVertices) / speedPerSecond;
                    this.message(outputListener, "+ vertices: scanned " + stats.scannedVertices + ", repaired " + stats.repairedVertices + " (estimated remaining time " + remaining + " secs)\n");
                }
                OrientVertex v = graph.getVertex(vertex);
                for (String fieldName : vertex.fieldNames()) {
                    Object o;
                    Iterator it;
                    Object fieldValue;
                    OPair<Direction, String> connection = v.getConnection(Direction.BOTH, fieldName, null);
                    if (connection == null || (fieldValue = vertex.rawField(fieldName)) == null) continue;
                    if (fieldValue instanceof OIdentifiable) {
                        if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)fieldValue, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                        if (!checkOnly) {
                            vertex.field(fieldName, null);
                            continue;
                        }
                        this.message(outputListener, "+ found corrupted vertex " + vertex + " the property " + fieldName + " could be removed\n");
                        continue;
                    }
                    if (fieldValue instanceof Collection) {
                        Collection coll = (Collection)fieldValue;
                        it = coll.iterator();
                        while (it.hasNext()) {
                            o = it.next();
                            if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)o, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                            if (!checkOnly) {
                                it.remove();
                                continue;
                            }
                            this.message(outputListener, "+ found corrupted vertex " + vertex + " the edge should be removed from property " + fieldName + " (collection)\n");
                        }
                        continue;
                    }
                    if (!(fieldValue instanceof ORidBag)) continue;
                    ORidBag ridbag = (ORidBag)fieldValue;
                    if (ridbag.size() == 0) {
                        vertex.removeField(fieldName);
                    } else if (!ridbag.isEmbedded() && ridbag.size() < OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger()) {
                        vertex.setDirty();
                    }
                    it = ridbag.rawIterator();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)o, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                        if (!checkOnly) {
                            it.remove();
                            continue;
                        }
                        this.message(outputListener, "+ found corrupted vertex " + vertex + " the edge should be removed from property " + fieldName + " (ridbag)\n");
                    }
                }
                if (!vertex.isDirty()) continue;
                ++stats.repairedVertices;
                if (this.eventListener != null) {
                    this.eventListener.onRepairedVertex(vertex);
                }
                this.message(outputListener, "+ repaired corrupted vertex " + vertex + "\n");
                vertex.save();
            }
            this.message(outputListener, "Scanning vertices completed\n");
        }
    }

    private void onScannedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.scannedLinks;
        if (this.eventListener != null) {
            this.eventListener.onScannedLink(fieldValue);
        }
    }

    private void onRemovedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.removedLinks;
        if (this.eventListener != null) {
            this.eventListener.onRemovedLink(fieldValue);
        }
    }

    public OStorageRecoverEventListener getEventListener() {
        return this.eventListener;
    }

    public OGraphRepair setEventListener(OStorageRecoverEventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    private void message(OCommandOutputListener outputListener, String message) {
        if (outputListener != null) {
            outputListener.onMessage(message);
        }
    }

    private boolean isEdgeBroken(OIdentifiable vertex, String fieldName, Direction direction, OIdentifiable edgeRID, ORepairStats stats, boolean useVertexFieldsForEdgeLabels) {
        this.onScannedLink(stats, edgeRID);
        boolean broken = false;
        if (edgeRID == null) {
            broken = true;
        } else {
            ODocument record = null;
            try {
                record = (ODocument)edgeRID.getIdentity().getRecord();
            }
            catch (ORecordNotFoundException e) {
                broken = true;
            }
            if (record == null) {
                broken = true;
            } else {
                OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
                if (immutableClass == null || !immutableClass.isVertexType() && !immutableClass.isEdgeType()) {
                    broken = true;
                } else if (immutableClass.isVertexType()) {
                    String inverseFieldName = OrientVertex.getInverseConnectionFieldName(fieldName, useVertexFieldsForEdgeLabels);
                    Object inverseEdgeContainer = record.field(inverseFieldName);
                    if (inverseEdgeContainer == null) {
                        broken = true;
                    } else if (inverseEdgeContainer instanceof OIdentifiable) {
                        if (!inverseEdgeContainer.equals(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof Collection) {
                        if (!((Collection)inverseEdgeContainer).contains(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof ORidBag && !((ORidBag)inverseEdgeContainer).contains(vertex)) {
                        broken = true;
                    }
                } else {
                    OIdentifiable backRID = OrientEdge.getConnection(record, direction);
                    if (backRID == null || !backRID.equals(vertex)) {
                        broken = true;
                    }
                }
            }
        }
        if (broken) {
            this.onRemovedLink(stats, edgeRID);
            return true;
        }
        return false;
    }

    private class ORepairStats {
        long scannedEdges = 0L;
        long removedEdges = 0L;
        long scannedVertices = 0L;
        long scannedLinks = 0L;
        long removedLinks = 0L;
        long repairedVertices = 0L;

        private ORepairStats() {
        }
    }
}

