/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapPipe<S extends Element>
extends AbstractPipe<S, Map<String, Object>>
implements TransformPipe<S, Map<String, Object>> {
    private final String[] keys;
    private static final String ID = "id";
    private static final String LABEL = "label";

    public PropertyMapPipe(String ... keys) {
        this.keys = keys;
    }

    @Override
    protected Map<String, Object> processNextStart() {
        Element element = (Element)this.starts.next();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.keys.length == 0) {
            for (String key : element.getPropertyKeys()) {
                map.put(key, element.getProperty(key));
            }
        } else {
            for (String key : this.keys) {
                if (key.equals(ID)) {
                    map.put(ID, element.getId());
                    continue;
                }
                if (element instanceof Edge && key.equals(LABEL)) {
                    map.put(LABEL, ((Edge)element).getLabel());
                    continue;
                }
                map.put(key, element.getProperty(key));
            }
        }
        return map;
    }
}

