/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ODistributedTxContextImpl
implements ODistributedTxContext {
    private final ODistributedDatabase db;
    private final ODistributedRequestId reqId;
    private final List<ORemoteTask> undoTasks = new ArrayList<ORemoteTask>();
    private final List<ORID> acquiredLocks = new ArrayList<ORID>();
    private final long startedOn = System.currentTimeMillis();
    private final AtomicBoolean canceled = new AtomicBoolean(false);

    public ODistributedTxContextImpl(ODistributedDatabase iDatabase, ODistributedRequestId iRequestId) {
        this.db = iDatabase;
        this.reqId = iRequestId;
    }

    public String toString() {
        return "reqId=" + this.reqId + " undoTasks=" + this.undoTasks.size() + " startedOn=" + this.startedOn;
    }

    public Set<ORecordId> cancel(ODistributedServerManager dManager, ODatabaseDocumentInternal database) {
        this.canceled.set(true);
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: canceled (locks=%s undo=%d startedOn=%s thread=%d)", (Object[])new Object[]{this.reqId, this.acquiredLocks, this.undoTasks.size(), new Date(this.startedOn), Thread.currentThread().getId()});
        ODistributedResponseManager respMgr = dManager.getMessageService().getResponseManager(this.reqId);
        if (respMgr != null) {
            respMgr.cancel();
        }
        Set<ORecordId> ridsInvolved = this.rollback(database);
        this.destroy();
        return ridsInvolved;
    }

    public synchronized void lock(ORID rid) {
        this.lock(rid, -1L);
    }

    public synchronized void lock(ORID rid, long timeout) {
        if (timeout < 0L) {
            timeout = OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsInteger();
        }
        if (!rid.isPersistent()) {
            rid = new ORecordId(rid.getClusterId(), -1L);
            if (timeout > 0L) {
                timeout *= 10L;
            }
        }
        if (this.db.lockRecord(rid, this.reqId, timeout)) {
            this.acquiredLocks.add(rid);
        }
    }

    public ODistributedRequestId getReqId() {
        return this.reqId;
    }

    public synchronized void addUndoTask(ORemoteTask undoTask) {
        this.undoTasks.add(undoTask);
    }

    public synchronized void commit() {
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: committing transaction on database '%s' (locks=%s thread=%d)", (Object[])new Object[]{this.reqId, this.db.getDatabaseName(), this.acquiredLocks, Thread.currentThread().getId()});
    }

    public synchronized void fix(ODatabaseDocumentInternal database, List<ORemoteTask> fixTasks) {
        ODistributedTxContextImpl.executeFix(this, this, database, fixTasks, this.reqId, this.db);
    }

    public synchronized Set<ORecordId> rollback(ODatabaseDocumentInternal database) {
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: rolling back transaction on database '%s' (undo=%d tx=%s)", (Object[])new Object[]{this.reqId, database != null ? database.getName() : "?", this.undoTasks.size(), database.getTransaction().isActive()});
        HashSet<ORecordId> rids = new HashSet<ORecordId>();
        for (ORemoteTask task : this.undoTasks) {
            try {
                if (task == null) continue;
                this.db.getManager().executeOnLocalNode(this.reqId, task, database);
                if (!(task instanceof OAbstractRecordReplicatedTask)) continue;
                rids.add(((OAbstractRecordReplicatedTask)task).getRid());
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on rolling back transaction %s task %s", (Throwable)e, (Object[])new Object[]{this.reqId, task});
            }
        }
        return rids;
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public synchronized void destroy() {
        this.unlock();
        this.clearUndo();
    }

    public synchronized void clearUndo() {
        this.undoTasks.clear();
    }

    public synchronized void unlock() {
        if (!this.acquiredLocks.isEmpty()) {
            for (ORID lockedRID : this.acquiredLocks) {
                this.db.unlockRecord((OIdentifiable)lockedRID, this.reqId);
            }
            this.acquiredLocks.clear();
        }
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeFix(Object me, ODistributedTxContext context, ODatabaseDocumentInternal database, List<ORemoteTask> fixTasks, ODistributedRequestId requestId, ODistributedDatabase ddb) {
        ODistributedServerLog.debug((Object)me, (String)ddb.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: fixing transaction (db=%s tasks=%d)", (Object[])new Object[]{requestId, ddb.getDatabaseName(), fixTasks.size()});
        HashSet<ORecordId> locked = new HashSet<ORecordId>();
        for (ORemoteTask oRemoteTask : fixTasks) {
            ORecordId rid;
            if (!(oRemoteTask instanceof OAbstractRecordReplicatedTask) || !ddb.forceLockRecord((ORID)(rid = ((OAbstractRecordReplicatedTask)oRemoteTask).getRid()), requestId)) continue;
            locked.add(rid);
        }
        try {
            for (ORemoteTask oRemoteTask : fixTasks) {
                try {
                    if (oRemoteTask instanceof OAbstractRecordReplicatedTask) {
                        ((OAbstractRecordReplicatedTask)oRemoteTask).setLockRecords(false);
                    }
                    oRemoteTask.execute(requestId, ddb.getManager().getServerInstance(), ddb.getManager(), database);
                }
                catch (Exception e) {
                    ODistributedServerLog.debug((Object)me, (String)ddb.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on fixing transaction %s db=%s task=%s", (Throwable)e, (Object[])new Object[]{requestId, ddb.getDatabaseName(), oRemoteTask});
                }
            }
        }
        finally {
            for (ORID oRID : locked) {
                ddb.unlockRecord((OIdentifiable)oRID, requestId);
            }
        }
    }
}

