/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class OIncrementalServerSync {
    private static final byte[] EMPTY_CONTENT = new byte[0];

    public void importDelta(OServer serverInstance, final ODatabaseDocumentInternal db, final FileInputStream in, final String iNode) throws IOException {
        final String nodeName = serverInstance.getDistributedManager().getLocalNodeName();
        try {
            serverInstance.openDatabase((ODatabaseInternal)db);
            OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public Object call() throws Exception {
                    db.activateOnCurrentThread();
                    totalRecords = 0L;
                    totalCreated = 0L;
                    totalUpdated = 0L;
                    totalDeleted = 0L;
                    totalHoles = 0L;
                    totalSkipped = 0L;
                    ODistributedServerLog.info((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("Started import of delta for database '" + db.getName() + "'"), (Object[])new Object[0]);
                    lastLap = System.currentTimeMillis();
                    try {
                        input = new DataInputStream(in);
                        try {
                            records = input.readLong();
                            block20: for (i = 0L; i < records; ++i) {
                                block26: {
                                    block25: {
                                        clusterId = input.readInt();
                                        clusterPos = input.readLong();
                                        deleted = input.readBoolean();
                                        rid = new ORecordId(clusterId, clusterPos);
                                        ++totalRecords;
                                        cluster = (OPaginatedCluster)db.getStorage().getUnderlying().getClusterById(rid.getClusterId());
                                        recordStatus = cluster.getRecordStatus(rid.getClusterPosition());
                                        newRecord = null;
                                        if (!deleted) break block25;
                                        ODistributedServerLog.debug((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- deleting %s", (Object[])new Object[]{rid});
                                        switch (2.$SwitchMap$com$orientechnologies$orient$core$storage$impl$local$paginated$OPaginatedCluster$RECORD_STATUS[recordStatus.ordinal()]) {
                                            case 1: {
                                                ++totalSkipped;
                                                continue block20;
                                            }
                                            case 2: 
                                            case 3: {
                                                db.delete((ORID)rid);
                                                ** GOTO lbl37
                                            }
                                            case 4: {
                                                ++totalSkipped;
                                            }
lbl37:
                                            // 3 sources

                                            default: {
                                                ++totalDeleted;
                                                break;
                                            }
                                        }
                                        break block26;
                                    }
                                    recordVersion = input.readInt();
                                    recordType = input.readByte();
                                    recordSize = input.readInt();
                                    recordContent = new byte[recordSize];
                                    input.read(recordContent);
                                    switch (2.$SwitchMap$com$orientechnologies$orient$core$storage$impl$local$paginated$OPaginatedCluster$RECORD_STATUS[recordStatus.ordinal()]) {
                                        case 1: {
                                            ++totalSkipped;
                                            continue block20;
                                        }
                                        case 2: 
                                        case 3: {
                                            newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
                                            ORecordInternal.fill((ORecord)newRecord, (ORID)rid, (int)ORecordVersionHelper.setRollbackMode((int)recordVersion), (byte[])recordContent, (boolean)true);
                                            loadedRecord = rid.getRecord();
                                            if (loadedRecord instanceof ODocument) {
                                                loadedDocument = (ODocument)loadedRecord;
                                                loadedDocument.merge((ODocument)newRecord, false, false);
                                                ORecordInternal.setVersion((ORecord)loadedRecord, (int)ORecordVersionHelper.setRollbackMode((int)recordVersion));
                                                loadedDocument.setDirty();
                                                newRecord = loadedDocument;
                                            }
                                            newRecord.save();
                                            ODistributedServerLog.debug((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- updating rid=%s type=%d size=%d v=%d content=%s", (Object[])new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                            ++totalUpdated;
                                            ** GOTO lbl107
                                        }
                                        case 4: {
                                            do {
                                                newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
                                                ORecordInternal.fill((ORecord)newRecord, (ORID)new ORecordId(rid.getClusterId(), -1L), (int)recordVersion, (byte[])recordContent, (boolean)true);
                                                try {
                                                    newRecord.save();
                                                }
                                                catch (ORecordNotFoundException e) {
                                                    ODistributedServerLog.info((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- error on saving record (not found) rid=%s type=%d size=%d v=%d content=%s", (Object[])new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                                }
                                                catch (ORecordDuplicatedException e) {
                                                    ODistributedServerLog.info((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- error on saving record (duplicated %s) rid=%s type=%d size=%d v=%d content=%s", (Object[])new Object[]{e.getRid(), rid, (int)recordType, recordSize, recordVersion, newRecord});
                                                    duplicatedRecord = (ORecord)db.load(e.getRid(), null, true);
                                                    if (duplicatedRecord != null) break;
                                                    doc = (ODocument)newRecord;
                                                    index = db.getMetadata().getIndexManager().getIndex(e.getIndexName());
                                                    fields = index.getDefinition().getFields();
                                                    values = new ArrayList<Object>(fields.size());
                                                    for (String f : fields) {
                                                        values.add(doc.field(f));
                                                    }
                                                    keyValue = index.getDefinition().createValue(values);
                                                    index.remove(keyValue, (OIdentifiable)e.getRid());
                                                    newRecord.save();
                                                }
                                                if (newRecord.getIdentity().getClusterPosition() >= clusterPos) continue;
                                                ODistributedServerLog.debug((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- creating hole rid=%s", (Object[])new Object[]{newRecord.getIdentity()});
                                                newRecord.delete();
                                                ++totalHoles;
                                            } while (newRecord.getIdentity().getClusterPosition() < clusterPos);
                                            ODistributedServerLog.debug((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"DELTA <- creating rid=%s type=%d size=%d v=%d content=%s", (Object[])new Object[]{rid, (int)recordType, recordSize, recordVersion, newRecord});
                                            ++totalCreated;
                                        }
lbl107:
                                        // 3 sources

                                        default: {
                                            if (!newRecord.getIdentity().isPersistent() || newRecord.getIdentity().equals(rid)) break;
                                            throw new ODistributedDatabaseDeltaSyncException("Error on synchronization of records, rids are different: saved " + newRecord.getIdentity() + ", but it should be " + rid);
                                        }
                                    }
                                }
                                if ((now = System.currentTimeMillis()) - lastLap <= 2000L) continue;
                                ODistributedServerLog.info((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"- %,d total entries: %,d created, %,d updated, %,d deleted, %,d holes, %,d skipped...", (Object[])new Object[]{totalRecords, totalCreated, totalUpdated, totalDeleted, totalHoles, totalSkipped});
                                lastLap = now;
                            }
                            db.getMetadata().reload();
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database delta '%s' on local server", (Throwable)e, (Object[])new Object[]{db.getName()});
                        throw OException.wrapException((OException)new ODistributedException("Error on installing database delta '" + db.getName() + "' on local server"), (Throwable)e);
                    }
                    ODistributedServerLog.info((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Installed database delta for '%s'. %d total entries: %d created, %d updated, %d deleted, %d holes, %,d skipped", (Object[])new Object[]{db.getName(), totalRecords, totalCreated, totalUpdated, totalDeleted, totalHoles, totalSkipped});
                    return null;
                }
            });
            db.activateOnCurrentThread();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error while applying changes of database delta sync on '%s': forcing full database sync...", (Throwable)e, (Object[])new Object[]{db.getName()});
            throw OException.wrapException((OException)new ODistributedDatabaseDeltaSyncException("Error while applying changes of database delta sync on '" + db.getName() + "': forcing full database sync..."), (Throwable)e);
        }
    }
}

